/*
 * Decompiled with CFR 0.152.
 */
package com.dremio.jdbc.shaded.com.dremio.common.nodes;

import com.dremio.jdbc.shaded.com.dremio.exec.proto.CoordinationProtos;
import com.dremio.jdbc.shaded.com.google.common.base.Preconditions;
import java.util.Collection;
import java.util.stream.Collectors;

public class EndpointHelper {
    public static CoordinationProtos.NodeEndpoint getMinimalEndpoint(CoordinationProtos.NodeEndpoint endpoint) {
        CoordinationProtos.NodeEndpoint.Builder builder = CoordinationProtos.NodeEndpoint.newBuilder();
        if (endpoint.hasAddress()) {
            builder.setAddress(endpoint.getAddress());
        }
        if (endpoint.hasFabricPort()) {
            builder.setFabricPort(endpoint.getFabricPort());
        }
        if (endpoint.hasEngineId()) {
            builder.setEngineId(endpoint.getEngineId());
        }
        return builder.build();
    }

    public static String getMinimalString(CoordinationProtos.NodeEndpoint endpoint) {
        return endpoint.getAddress() + ":" + endpoint.getFabricPort();
    }

    public static String getMinimalString(Collection<CoordinationProtos.NodeEndpoint> endpoints) {
        return endpoints.stream().map(EndpointHelper::getMinimalString).collect(Collectors.joining(","));
    }

    public static CoordinationProtos.NodeEndpoint hostPortStrToConduitEndpoint(String hostPortString) {
        String[] parts = hostPortString.split(":");
        Preconditions.checkArgument(parts.length == 2);
        CoordinationProtos.NodeEndpoint.Builder builder = CoordinationProtos.NodeEndpoint.newBuilder();
        builder.setAddress(parts[0]);
        builder.setConduitPort(Integer.valueOf(parts[1]));
        return builder.build();
    }
}

