/*
 * Decompiled with CFR 0.152.
 */
package com.dremio.jdbc.shaded.com.dremio.common.scanner;

import com.dremio.jdbc.shaded.com.dremio.common.config.SabotConfig;
import com.dremio.jdbc.shaded.com.dremio.common.scanner.ClassPathScanner;
import com.dremio.jdbc.shaded.com.dremio.common.scanner.persistence.ScanResult;
import com.dremio.jdbc.shaded.com.fasterxml.jackson.databind.ObjectMapper;
import com.dremio.jdbc.shaded.com.fasterxml.jackson.databind.ObjectReader;
import com.dremio.jdbc.shaded.com.fasterxml.jackson.databind.ObjectWriter;
import com.dremio.jdbc.shaded.com.fasterxml.jackson.databind.SerializationFeature;
import com.dremio.jdbc.shaded.org.slf4j.Logger;
import com.dremio.jdbc.shaded.org.slf4j.LoggerFactory;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;

public class BuildTimeScan {
    private static final Logger logger = LoggerFactory.getLogger(BuildTimeScan.class);
    private static final String REGISTRY_FILE = "META-INF/dremio-module-scan/registry.json";
    private static final ObjectMapper mapper = new ObjectMapper().enable(SerializationFeature.INDENT_OUTPUT);
    private static final ObjectReader reader = mapper.readerFor(ScanResult.class);
    private static final ObjectWriter writer = mapper.writerFor(ScanResult.class);

    static Collection<URL> getPrescannedPaths() {
        return ClassPathScanner.forResource(REGISTRY_FILE, true);
    }

    static ScanResult load() {
        return BuildTimeScan.loadExcept(null);
    }

    private static ScanResult loadExcept(URL ignored) {
        Collection<URL> preScanned = ClassPathScanner.forResource(REGISTRY_FILE, false);
        ScanResult result = null;
        for (URL u : preScanned) {
            if (ignored != null && u.toString().startsWith(ignored.toString())) continue;
            try {
                InputStream reflections = u.openStream();
                try {
                    ScanResult ref = (ScanResult)reader.readValue(reflections);
                    if (result == null) {
                        result = ref;
                        continue;
                    }
                    result = result.merge(ref);
                }
                finally {
                    if (reflections == null) continue;
                    reflections.close();
                }
            }
            catch (IOException e) {
                throw new RuntimeException("can't read function registry at " + String.valueOf(u), e);
            }
        }
        if (result != null) {
            if (logger.isInfoEnabled()) {
                StringBuilder sb = new StringBuilder();
                for (URL u : preScanned) {
                    sb.append("\n\t- ");
                    sb.append(u.toExternalForm());
                }
                logger.info("Loaded prescanned packages {} from locations:{}", (Object)result.getScannedPackages(), (Object)sb);
            }
            return result;
        }
        return ClassPathScanner.emptyResult();
    }

    private static void save(ScanResult scanResult, File file) {
        try {
            writer.writeValue(file, (Object)scanResult);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static void main(String[] args) throws Exception {
        if (args.length != 1) {
            throw new IllegalArgumentException("Usage: java {cp} " + ClassPathScanner.class.getName() + " path/to/scan");
        }
        Object basePath = args[0];
        System.out.println("Scanning: " + (String)basePath);
        File registryFile = new File((String)basePath, REGISTRY_FILE);
        File dir = registryFile.getParentFile();
        if (!dir.exists() && !dir.mkdirs() || !dir.isDirectory()) {
            throw new IllegalArgumentException("could not create dir " + dir.getAbsolutePath());
        }
        SabotConfig config = SabotConfig.create();
        if (!((String)basePath).endsWith("/")) {
            basePath = (String)basePath + "/";
        }
        if (!((String)basePath).startsWith("/")) {
            basePath = "/" + (String)basePath;
        }
        URL url = new URL("file:" + (String)basePath);
        Collection<URL> markedPaths = ClassPathScanner.getMarkedPaths();
        if (!markedPaths.contains(url)) {
            throw new IllegalArgumentException(String.valueOf(url) + " not in " + String.valueOf(markedPaths));
        }
        List<String> packagePrefixes = ClassPathScanner.getPackagePrefixes(config);
        List<String> baseClasses = ClassPathScanner.getScannedBaseClasses(config);
        List<String> scannedAnnotations = ClassPathScanner.getScannedAnnotations(config);
        ScanResult preScanned = BuildTimeScan.loadExcept(url);
        ScanResult scan = ClassPathScanner.scan(Arrays.asList(url), packagePrefixes, baseClasses, scannedAnnotations, preScanned);
        BuildTimeScan.save(scan, registryFile);
    }
}

