/*
 * Decompiled with CFR 0.152.
 */
package com.dremio.jdbc.shaded.com.dremio.common.scanner;

import com.dremio.jdbc.shaded.com.dremio.common.SuppressForbidden;
import com.dremio.jdbc.shaded.com.dremio.common.config.SabotConfig;
import com.dremio.jdbc.shaded.com.dremio.common.exceptions.UserException;
import com.dremio.jdbc.shaded.com.dremio.common.scanner.RunTimeScan;
import com.dremio.jdbc.shaded.com.dremio.common.scanner.persistence.AnnotatedClassDescriptor;
import com.dremio.jdbc.shaded.com.dremio.common.scanner.persistence.AnnotationDescriptor;
import com.dremio.jdbc.shaded.com.dremio.common.scanner.persistence.AttributeDescriptor;
import com.dremio.jdbc.shaded.com.dremio.common.scanner.persistence.ChildClassDescriptor;
import com.dremio.jdbc.shaded.com.dremio.common.scanner.persistence.FieldDescriptor;
import com.dremio.jdbc.shaded.com.dremio.common.scanner.persistence.ParentClassDescriptor;
import com.dremio.jdbc.shaded.com.dremio.common.scanner.persistence.ScanResult;
import com.dremio.jdbc.shaded.com.google.common.base.Stopwatch;
import com.dremio.jdbc.shaded.com.google.common.collect.HashMultimap;
import com.dremio.jdbc.shaded.com.google.common.collect.Multimap;
import com.dremio.jdbc.shaded.com.google.common.collect.Sets;
import com.dremio.jdbc.shaded.javassist.bytecode.AnnotationsAttribute;
import com.dremio.jdbc.shaded.javassist.bytecode.ClassFile;
import com.dremio.jdbc.shaded.javassist.bytecode.FieldInfo;
import com.dremio.jdbc.shaded.javassist.bytecode.annotation.Annotation;
import com.dremio.jdbc.shaded.javassist.bytecode.annotation.AnnotationMemberValue;
import com.dremio.jdbc.shaded.javassist.bytecode.annotation.ArrayMemberValue;
import com.dremio.jdbc.shaded.javassist.bytecode.annotation.BooleanMemberValue;
import com.dremio.jdbc.shaded.javassist.bytecode.annotation.ByteMemberValue;
import com.dremio.jdbc.shaded.javassist.bytecode.annotation.CharMemberValue;
import com.dremio.jdbc.shaded.javassist.bytecode.annotation.ClassMemberValue;
import com.dremio.jdbc.shaded.javassist.bytecode.annotation.DoubleMemberValue;
import com.dremio.jdbc.shaded.javassist.bytecode.annotation.EnumMemberValue;
import com.dremio.jdbc.shaded.javassist.bytecode.annotation.FloatMemberValue;
import com.dremio.jdbc.shaded.javassist.bytecode.annotation.IntegerMemberValue;
import com.dremio.jdbc.shaded.javassist.bytecode.annotation.LongMemberValue;
import com.dremio.jdbc.shaded.javassist.bytecode.annotation.MemberValue;
import com.dremio.jdbc.shaded.javassist.bytecode.annotation.MemberValueVisitor;
import com.dremio.jdbc.shaded.javassist.bytecode.annotation.ShortMemberValue;
import com.dremio.jdbc.shaded.javassist.bytecode.annotation.StringMemberValue;
import com.dremio.jdbc.shaded.org.reflections.Reflections;
import com.dremio.jdbc.shaded.org.reflections.scanners.Scanner;
import com.dremio.jdbc.shaded.org.reflections.util.ConfigurationBuilder;
import com.dremio.jdbc.shaded.org.reflections.util.FilterBuilder;
import com.dremio.jdbc.shaded.org.slf4j.Logger;
import com.dremio.jdbc.shaded.org.slf4j.LoggerFactory;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;

public final class ClassPathScanner {
    private static final Logger logger = LoggerFactory.getLogger(ClassPathScanner.class);
    private static final String IMPLEMENTATIONS_SCAN_PACKAGES = "dremio.classpath.scanning.packages";
    private static final String IMPLEMENTATIONS_SCAN_CLASSES = "dremio.classpath.scanning.base.classes";
    private static final String IMPLEMENTATIONS_SCAN_ANNOTATIONS = "dremio.classpath.scanning.annotations";
    private static final String IMPLEMENTATIONS_SCAN_CACHE = "dremio.classpath.scanning.cache.enabled";

    static Collection<URL> getMarkedPaths() {
        return ClassPathScanner.forResource("sabot-module.conf", true);
    }

    public static Collection<URL> getConfigURLs() {
        return ClassPathScanner.forResource("sabot-module.conf", false);
    }

    public static Collection<URL> forResource(String resourcePathname, boolean returnRootPathname) {
        logger.debug("Scanning classpath for resources with pathname \"{}\".", (Object)resourcePathname);
        LinkedHashSet<URL> resultUrlSet = Sets.newLinkedHashSet();
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        try {
            Enumeration<URL> resourceUrls = classLoader.getResources(resourcePathname);
            while (resourceUrls.hasMoreElements()) {
                URL resourceUrl = resourceUrls.nextElement();
                logger.trace("- found a(n) {} at {}.", (Object)resourcePathname, (Object)resourceUrl);
                int index = resourceUrl.toExternalForm().lastIndexOf(resourcePathname);
                if (index != -1 && returnRootPathname) {
                    URL classpathRootUrl = new URL(resourceUrl.toExternalForm().substring(0, index));
                    resultUrlSet.add(classpathRootUrl);
                    logger.debug("- collected resource's classpath root URL {}.", (Object)classpathRootUrl);
                    continue;
                }
                resultUrlSet.add(resourceUrl);
                logger.debug("- collected resource URL {}.", (Object)resourceUrl);
            }
        }
        catch (IOException e) {
            throw new RuntimeException("Error scanning for resources named " + resourcePathname, e);
        }
        return resultUrlSet;
    }

    static List<String> getPackagePrefixes(SabotConfig config) {
        return config.getStringList(IMPLEMENTATIONS_SCAN_PACKAGES);
    }

    static List<String> getScannedBaseClasses(SabotConfig config) {
        return config.getStringList(IMPLEMENTATIONS_SCAN_CLASSES);
    }

    static List<String> getScannedAnnotations(SabotConfig config) {
        if (config.hasPath(IMPLEMENTATIONS_SCAN_ANNOTATIONS)) {
            return config.getStringList(IMPLEMENTATIONS_SCAN_ANNOTATIONS);
        }
        return Collections.emptyList();
    }

    static boolean isScanBuildTimeCacheEnabled(SabotConfig config) {
        if (config.hasPath(IMPLEMENTATIONS_SCAN_CACHE)) {
            return config.getBoolean(IMPLEMENTATIONS_SCAN_CACHE);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static ScanResult scan(Collection<URL> pathsToScan, Collection<String> packagePrefixes, Collection<String> scannedClasses, Collection<String> scannedAnnotations, ScanResult parentResult) {
        ScanResult scanResult;
        Stopwatch watch = Stopwatch.createStarted();
        try {
            AnnotationScanner annotationScanner = new AnnotationScanner(scannedAnnotations);
            SubTypesScanner subTypesScanner = new SubTypesScanner(parentResult.getImplementations());
            if (packagePrefixes.size() > 0) {
                FilterBuilder filter = new FilterBuilder();
                for (String prefix : packagePrefixes) {
                    filter.includePackage(prefix);
                }
                ConfigurationBuilder conf = new ConfigurationBuilder().setParallel(false).setUrls(pathsToScan).filterInputsBy(filter).setScanners(annotationScanner, subTypesScanner);
                new Reflections(conf);
            }
            ArrayList<ParentClassDescriptor> implementations = new ArrayList<ParentClassDescriptor>();
            for (String baseTypeName : scannedClasses) {
                implementations.add(new ParentClassDescriptor(baseTypeName, new ArrayList<ChildClassDescriptor>(subTypesScanner.getChildrenOf(baseTypeName))));
            }
            List<AnnotatedClassDescriptor> annotated = annotationScanner.getAnnotatedClasses();
            ClassPathScanner.verifyClassUnicity(annotated, pathsToScan);
            logger.debug("Scanned Result: {}, {}, {}, {}", packagePrefixes, scannedClasses, scannedAnnotations, annotated);
            scanResult = new ScanResult(packagePrefixes, scannedClasses, scannedAnnotations, annotated, implementations);
        }
        catch (Throwable throwable) {
            logger.info(String.format("Scanning packages %s in locations %s took %dms", packagePrefixes, pathsToScan, watch.elapsed(TimeUnit.MILLISECONDS)));
            throw throwable;
        }
        logger.info(String.format("Scanning packages %s in locations %s took %dms", packagePrefixes, pathsToScan, watch.elapsed(TimeUnit.MILLISECONDS)));
        return scanResult;
    }

    private static void verifyClassUnicity(List<AnnotatedClassDescriptor> annotatedClasses, Collection<URL> pathsScanned) {
        HashSet<String> scanned = new HashSet<String>();
        for (AnnotatedClassDescriptor annotated : annotatedClasses) {
            if (scanned.add(annotated.getClassName())) continue;
            throw UserException.functionError().message("function %s scanned twice in the following locations:\n%s\nDo you have conflicting jars on the classpath?", annotated.getClassName(), pathsScanned).build(logger);
        }
    }

    static ScanResult emptyResult() {
        return new ScanResult(Collections.emptyList(), Collections.emptyList(), Collections.emptyList(), Collections.emptyList(), Collections.emptyList());
    }

    public static ScanResult fromPrescan(SabotConfig config) {
        return RunTimeScan.fromPrescan(config);
    }

    @SuppressForbidden
    public static final class AnnotationScanner
    implements Scanner {
        private final List<AnnotatedClassDescriptor> functions = new ArrayList<AnnotatedClassDescriptor>();
        private final Set<String> annotationsToScan;

        public AnnotationScanner(Collection<String> annotationsToScan) {
            this.annotationsToScan = Collections.unmodifiableSet(new HashSet<String>(annotationsToScan));
        }

        public List<AnnotatedClassDescriptor> getAnnotatedClasses() {
            return Collections.unmodifiableList(this.functions);
        }

        @Override
        public List<Map.Entry<String, String>> scan(ClassFile classFile) {
            AnnotationsAttribute annotations = (AnnotationsAttribute)classFile.getAttribute("RuntimeVisibleAnnotations");
            if (annotations != null) {
                boolean isAnnotated = false;
                for (Annotation a : annotations.getAnnotations()) {
                    if (!this.annotationsToScan.contains(a.getTypeName())) continue;
                    isAnnotated = true;
                }
                if (isAnnotated) {
                    List<AnnotationDescriptor> classAnnotations = this.getAnnotationDescriptors(annotations);
                    List<FieldInfo> classFields = classFile.getFields();
                    ArrayList<FieldDescriptor> fieldDescriptors = new ArrayList<FieldDescriptor>(classFields.size());
                    for (FieldInfo field : classFields) {
                        String fieldName = field.getName();
                        AnnotationsAttribute fieldAnnotations = (AnnotationsAttribute)field.getAttribute("RuntimeVisibleAnnotations");
                        List<AnnotationDescriptor> annotationDescriptors = fieldAnnotations != null ? this.getAnnotationDescriptors(fieldAnnotations) : Collections.emptyList();
                        fieldDescriptors.add(new FieldDescriptor(fieldName, field.getDescriptor(), annotationDescriptors));
                    }
                    this.functions.add(new AnnotatedClassDescriptor(classFile.getName(), classAnnotations, fieldDescriptors));
                }
            }
            return Collections.emptyList();
        }

        private List<AnnotationDescriptor> getAnnotationDescriptors(AnnotationsAttribute annotationsAttr) {
            ArrayList<AnnotationDescriptor> annotationDescriptors = new ArrayList<AnnotationDescriptor>(annotationsAttr.numAnnotations());
            for (Annotation annotation : annotationsAttr.getAnnotations()) {
                Set<String> memberNames = annotation.getMemberNames();
                ArrayList<AttributeDescriptor> attributes = new ArrayList<AttributeDescriptor>();
                if (memberNames != null) {
                    for (String name : memberNames) {
                        MemberValue memberValue = annotation.getMemberValue(name);
                        ArrayList<String> values = new ArrayList<String>();
                        memberValue.accept(new ListingMemberValueVisitor(values));
                        attributes.add(new AttributeDescriptor(name, values));
                    }
                }
                annotationDescriptors.add(new AnnotationDescriptor(annotation.getTypeName(), attributes));
            }
            return annotationDescriptors;
        }
    }

    @SuppressForbidden
    private static class SubTypesScanner
    implements Scanner {
        private Multimap<String, ChildClassDescriptor> parentsChildren = HashMultimap.create();
        private Multimap<String, ChildClassDescriptor> children = HashMultimap.create();

        public SubTypesScanner(List<ParentClassDescriptor> parentImplementations) {
            for (ParentClassDescriptor parentClassDescriptor : parentImplementations) {
                this.parentsChildren.putAll(parentClassDescriptor.getName(), parentClassDescriptor.getChildren());
            }
        }

        @Override
        public List<Map.Entry<String, String>> scan(ClassFile classFile) {
            String className = classFile.getName();
            String superclass = classFile.getSuperclass();
            boolean isAbstract = (classFile.getAccessFlags() & 0x600) != 0;
            ChildClassDescriptor scannedClass = new ChildClassDescriptor(className, isAbstract);
            if (!superclass.equals(Object.class.getName())) {
                this.children.put(superclass, scannedClass);
            }
            for (String anInterface : classFile.getInterfaces()) {
                this.children.put(anInterface, scannedClass);
            }
            return Collections.emptyList();
        }

        public Set<ChildClassDescriptor> getChildrenOf(String name) {
            HashSet<ChildClassDescriptor> result = new HashSet<ChildClassDescriptor>();
            Collection<ChildClassDescriptor> scannedChildren = this.children.get(name);
            for (ChildClassDescriptor child : scannedChildren) {
                result.add(child);
            }
            ArrayList<ChildClassDescriptor> allChildren = new ArrayList<ChildClassDescriptor>();
            allChildren.addAll(scannedChildren);
            allChildren.addAll(this.parentsChildren.get(name));
            for (ChildClassDescriptor child : allChildren) {
                result.addAll(this.getChildrenOf(child.getName()));
            }
            return result;
        }
    }

    @SuppressForbidden
    private static final class ListingInnerMemberValueVisitor
    extends ListingMemberValueVisitor {
        private ListingInnerMemberValueVisitor(List<String> values) {
            super(values);
        }

        @Override
        public void visitArrayMemberValue(ArrayMemberValue node) {
            this.values.add(Arrays.toString(node.getValue()));
        }
    }

    @SuppressForbidden
    private static class ListingMemberValueVisitor
    implements MemberValueVisitor {
        protected final List<String> values;

        private ListingMemberValueVisitor(List<String> values) {
            this.values = values;
        }

        @Override
        public void visitStringMemberValue(StringMemberValue node) {
            this.values.add(node.getValue());
        }

        @Override
        public void visitShortMemberValue(ShortMemberValue node) {
            this.values.add(String.valueOf(node.getValue()));
        }

        @Override
        public void visitLongMemberValue(LongMemberValue node) {
            this.values.add(String.valueOf(node.getValue()));
        }

        @Override
        public void visitIntegerMemberValue(IntegerMemberValue node) {
            this.values.add(String.valueOf(node.getValue()));
        }

        @Override
        public void visitFloatMemberValue(FloatMemberValue node) {
            this.values.add(String.valueOf(node.getValue()));
        }

        @Override
        public void visitEnumMemberValue(EnumMemberValue node) {
            this.values.add(node.getValue());
        }

        @Override
        public void visitDoubleMemberValue(DoubleMemberValue node) {
            this.values.add(String.valueOf(node.getValue()));
        }

        @Override
        public void visitClassMemberValue(ClassMemberValue node) {
            this.values.add(node.getValue());
        }

        @Override
        public void visitCharMemberValue(CharMemberValue node) {
            this.values.add(String.valueOf(node.getValue()));
        }

        @Override
        public void visitByteMemberValue(ByteMemberValue node) {
            this.values.add(String.valueOf(node.getValue()));
        }

        @Override
        public void visitBooleanMemberValue(BooleanMemberValue node) {
            this.values.add(String.valueOf(node.getValue()));
        }

        @Override
        public void visitArrayMemberValue(ArrayMemberValue node) {
            MemberValue[] nestedValues;
            for (MemberValue v : nestedValues = node.getValue()) {
                v.accept(new ListingInnerMemberValueVisitor(this.values));
            }
        }

        @Override
        public void visitAnnotationMemberValue(AnnotationMemberValue node) {
            this.values.add(String.valueOf(node.getValue()));
        }
    }
}

