/*
 * Decompiled with CFR 0.152.
 */
package com.dremio.jdbc.shaded.com.dremio.common.scanner;

import com.dremio.jdbc.shaded.com.dremio.common.config.SabotConfig;
import com.dremio.jdbc.shaded.com.dremio.common.scanner.BuildTimeScan;
import com.dremio.jdbc.shaded.com.dremio.common.scanner.ClassPathScanner;
import com.dremio.jdbc.shaded.com.dremio.common.scanner.persistence.ScanResult;
import com.dremio.jdbc.shaded.com.fasterxml.jackson.databind.ObjectMapper;
import com.dremio.jdbc.shaded.org.slf4j.Logger;
import com.dremio.jdbc.shaded.org.slf4j.LoggerFactory;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.Collection;
import java.util.List;

public class RunTimeScan {
    private static final Logger logger = LoggerFactory.getLogger(RunTimeScan.class);
    private static final ScanResult PRESCANNED = BuildTimeScan.load();
    private static final Collection<URL> NON_PRESCANNED_MARKED_PATHS = RunTimeScan.getNonPrescannedMarkedPaths();

    static Collection<URL> getNonPrescannedMarkedPaths() {
        Collection<URL> markedPaths = ClassPathScanner.getMarkedPaths();
        markedPaths.removeAll(BuildTimeScan.getPrescannedPaths());
        return markedPaths;
    }

    private static ScanResult createFromSavedScanResults() {
        String savedScanResults = System.getProperty("com.dremio.jdbc.shaded.com.dremio.savedScanResults");
        if (savedScanResults == null) {
            return null;
        }
        File scanResultsFile = new File(savedScanResults);
        if (scanResultsFile.exists()) {
            try {
                return new ObjectMapper().readValue(scanResultsFile, ScanResult.class);
            }
            catch (IOException e) {
                logger.warn("Unable to read scan result from {} (proceeding to slow path): {}", (Object)scanResultsFile.getName(), (Object)e.toString());
            }
        }
        return null;
    }

    public static ScanResult fromPrescan(SabotConfig config) {
        ScanResult preCreated = RunTimeScan.createFromSavedScanResults();
        if (preCreated != null) {
            return preCreated;
        }
        List<String> packagePrefixes = ClassPathScanner.getPackagePrefixes(config);
        List<String> scannedBaseClasses = ClassPathScanner.getScannedBaseClasses(config);
        List<String> scannedAnnotations = ClassPathScanner.getScannedAnnotations(config);
        if (ClassPathScanner.isScanBuildTimeCacheEnabled(config)) {
            ScanResult runtimeScan = ClassPathScanner.scan(NON_PRESCANNED_MARKED_PATHS, packagePrefixes, scannedBaseClasses, scannedAnnotations, PRESCANNED);
            return runtimeScan.merge(PRESCANNED);
        }
        return ClassPathScanner.scan(ClassPathScanner.getMarkedPaths(), packagePrefixes, scannedBaseClasses, scannedAnnotations, ClassPathScanner.emptyResult());
    }
}

