/*
 * Decompiled with CFR 0.152.
 */
package com.dremio.jdbc.shaded.com.dremio.common.scanner.persistence;

import com.dremio.jdbc.shaded.com.dremio.common.scanner.persistence.AnnotatedClassDescriptor;
import com.dremio.jdbc.shaded.com.dremio.common.scanner.persistence.AnnotationDescriptor;
import com.dremio.jdbc.shaded.com.dremio.common.scanner.persistence.ChildClassDescriptor;
import com.dremio.jdbc.shaded.com.dremio.common.scanner.persistence.ParentClassDescriptor;
import com.dremio.jdbc.shaded.com.fasterxml.jackson.annotation.JsonCreator;
import com.dremio.jdbc.shaded.com.fasterxml.jackson.annotation.JsonProperty;
import com.dremio.jdbc.shaded.com.google.common.base.Preconditions;
import com.dremio.jdbc.shaded.com.google.common.collect.HashMultimap;
import com.dremio.jdbc.shaded.com.google.common.collect.ImmutableList;
import com.dremio.jdbc.shaded.com.google.common.collect.Multimap;
import com.dremio.jdbc.shaded.org.slf4j.Logger;
import com.dremio.jdbc.shaded.org.slf4j.LoggerFactory;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class ScanResult {
    private static final Logger logger = LoggerFactory.getLogger(ScanResult.class);
    private final List<String> scannedPackages;
    private final Set<String> scannedClasses;
    private final Set<String> scannedAnnotations;
    private final List<AnnotatedClassDescriptor> annotatedClasses;
    private final List<ParentClassDescriptor> implementations;
    private final Map<String, ParentClassDescriptor> parentClassByName;
    private final Multimap<String, AnnotatedClassDescriptor> annotationsByName;

    @JsonCreator
    public ScanResult(@JsonProperty(value="scannedPackages") Collection<String> scannedPackages, @JsonProperty(value="scannedClasses") Collection<String> scannedClasses, @JsonProperty(value="scannedAnnotations") Collection<String> scannedAnnotations, @JsonProperty(value="annotatedClasses") Collection<AnnotatedClassDescriptor> annotatedClasses, @JsonProperty(value="implementations") Collection<ParentClassDescriptor> implementations) {
        this.scannedPackages = Collections.unmodifiableList(new ArrayList<String>(Preconditions.checkNotNull(scannedPackages)));
        this.scannedClasses = Collections.unmodifiableSet(new HashSet<String>(Preconditions.checkNotNull(scannedClasses)));
        this.scannedAnnotations = Collections.unmodifiableSet(new HashSet<String>(Preconditions.checkNotNull(scannedAnnotations)));
        this.annotatedClasses = Collections.unmodifiableList(new ArrayList<AnnotatedClassDescriptor>(Preconditions.checkNotNull(annotatedClasses)));
        this.implementations = Collections.unmodifiableList(new ArrayList<ParentClassDescriptor>(Preconditions.checkNotNull(implementations)));
        this.parentClassByName = new HashMap<String, ParentClassDescriptor>();
        for (ParentClassDescriptor parentClassDescriptor : implementations) {
            this.parentClassByName.put(parentClassDescriptor.getName(), parentClassDescriptor);
        }
        this.annotationsByName = HashMultimap.create();
        for (AnnotatedClassDescriptor annotated : annotatedClasses) {
            for (AnnotationDescriptor annotationDescriptor : annotated.getAnnotations()) {
                if (!scannedAnnotations.contains(annotationDescriptor.getAnnotationType())) continue;
                this.annotationsByName.put(annotationDescriptor.getAnnotationType(), annotated);
            }
        }
    }

    public List<String> getScannedPackages() {
        return this.scannedPackages;
    }

    public List<AnnotatedClassDescriptor> getAnnotatedClasses() {
        return this.annotatedClasses;
    }

    public List<ParentClassDescriptor> getImplementations() {
        return this.implementations;
    }

    public Set<String> getScannedClasses() {
        return this.scannedClasses;
    }

    public Set<String> getScannedAnnotations() {
        return this.scannedAnnotations;
    }

    public ParentClassDescriptor getImplementations(String c) {
        if (!this.scannedClasses.contains(c)) {
            throw new IllegalArgumentException(c + " is not scanned. Only implementations for the following classes are scanned: " + String.valueOf(this.scannedClasses));
        }
        return this.parentClassByName.get(c);
    }

    public <T> Set<Class<? extends T>> getImplementations(Class<T> c) {
        ParentClassDescriptor p = this.getImplementations(c.getName());
        HashSet<Class<T>> result = new HashSet<Class<T>>();
        if (p != null) {
            ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
            for (ChildClassDescriptor child : p.getChildren()) {
                if (child.isAbstract()) continue;
                try {
                    result.add(classLoader.loadClass(child.getName()).asSubclass(c));
                }
                catch (ClassNotFoundException e) {
                    throw new RuntimeException("scanned class could not be found: " + child.getName(), e);
                }
            }
        }
        return result;
    }

    public List<AnnotatedClassDescriptor> getAnnotatedClasses(String c) {
        if (!this.scannedAnnotations.contains(c)) {
            throw new IllegalArgumentException(c + " is not scanned. Only the following Annotations are scanned: " + String.valueOf(this.scannedAnnotations));
        }
        return new ArrayList<AnnotatedClassDescriptor>(this.annotationsByName.get(c));
    }

    public List<Class<?>> getAnnotatedClasses(Class<? extends Annotation> clazz) {
        ImmutableList.Builder classes = ImmutableList.builder();
        for (AnnotatedClassDescriptor descriptor : this.getAnnotatedClasses(clazz.getName())) {
            try {
                classes.add(Class.forName(descriptor.getClassName()));
            }
            catch (ClassNotFoundException e) {
                throw new RuntimeException("scanned class could not be found: " + descriptor.getClassName(), e);
            }
        }
        return classes.build();
    }

    public String toString() {
        return "ScanResult [scannedPackages=" + String.valueOf(this.scannedPackages) + ", scannedClasses=" + String.valueOf(this.scannedClasses) + ", scannedAnnotations=" + String.valueOf(this.scannedAnnotations) + ", annotatedClasses=" + String.valueOf(this.annotatedClasses) + ", implementations=" + String.valueOf(this.implementations) + "]";
    }

    private <T> List<T> merge(Collection<T> a, Collection<T> b) {
        ArrayList<T> newList = new ArrayList<T>(a);
        newList.addAll(b);
        return newList;
    }

    public ScanResult merge(ScanResult other) {
        HashMultimap<String, ChildClassDescriptor> newImpls = HashMultimap.create();
        for (Collection collection : Arrays.asList(this.implementations, other.implementations)) {
            for (ParentClassDescriptor c : collection) {
                newImpls.putAll(c.getName(), c.getChildren());
            }
        }
        ArrayList<ParentClassDescriptor> newImplementations = new ArrayList<ParentClassDescriptor>();
        for (Map.Entry entry : newImpls.asMap().entrySet()) {
            newImplementations.add(new ParentClassDescriptor((String)entry.getKey(), new ArrayList<ChildClassDescriptor>(entry.getValue())));
        }
        return new ScanResult(this.merge(this.scannedPackages, other.scannedPackages), this.merge(this.scannedClasses, other.scannedClasses), this.merge(this.scannedAnnotations, other.scannedAnnotations), this.merge(this.annotatedClasses, other.annotatedClasses), newImplementations);
    }
}

