/*
 * Decompiled with CFR 0.152.
 */
package com.dremio.jdbc.shaded.com.dremio.common.scanner.persistence;

public abstract class TypeDescriptor {
    private final boolean primitive;
    private final int arrayDim;

    TypeDescriptor(boolean primitive, int arrayDim) {
        this.primitive = primitive;
        this.arrayDim = arrayDim;
    }

    public boolean isPrimitive() {
        return this.primitive;
    }

    public boolean isArray() {
        return this.arrayDim > 0;
    }

    public int getArrayDim() {
        return this.arrayDim;
    }

    public abstract Class<?> getType();

    public static TypeDescriptor forClass(String className, int arrayDim) {
        return new ClassTypeDescriptor(className, arrayDim);
    }

    public static TypeDescriptor forPrimitive(char c, int arrayDim) {
        return new PrimitiveTypeDescriptor(c, arrayDim);
    }

    private static final class ClassTypeDescriptor
    extends TypeDescriptor {
        private String className;

        private ClassTypeDescriptor(String className, int arrayDim) {
            super(false, arrayDim);
            this.className = className;
        }

        @Override
        public Class<?> getType() {
            try {
                return Class.forName(this.className);
            }
            catch (ClassNotFoundException e) {
                throw new RuntimeException(String.format("Unexpected class load failure while attempting to load Function Registry (%s)", this.className), e);
            }
        }
    }

    private static final class PrimitiveTypeDescriptor
    extends TypeDescriptor {
        private final Class<?> type;

        private static Class<?> getPrimitiveType(char descriptor) {
            switch (descriptor) {
                case 'V': {
                    return Void.TYPE;
                }
                case 'I': {
                    return Integer.TYPE;
                }
                case 'B': {
                    return Byte.TYPE;
                }
                case 'J': {
                    return Long.TYPE;
                }
                case 'D': {
                    return Double.TYPE;
                }
                case 'F': {
                    return Float.TYPE;
                }
                case 'C': {
                    return Character.TYPE;
                }
                case 'S': {
                    return Short.TYPE;
                }
                case 'Z': {
                    return Boolean.TYPE;
                }
            }
            throw new AssertionError((Object)("bad descriptor: " + descriptor));
        }

        private PrimitiveTypeDescriptor(char typeDescriptor, int arrayDepth) {
            super(true, arrayDepth);
            this.type = PrimitiveTypeDescriptor.getPrimitiveType(typeDescriptor);
        }

        @Override
        public Class<?> getType() {
            return this.type;
        }
    }
}

