/*
 * Decompiled with CFR 0.152.
 */
package com.dremio.jdbc.shaded.com.dremio.common.types;

import com.dremio.jdbc.shaded.com.dremio.common.expression.CompleteType;
import com.dremio.jdbc.shaded.org.apache.arrow.vector.types.pojo.ArrowType;
import com.dremio.jdbc.shaded.org.apache.arrow.vector.types.pojo.Field;
import java.util.Optional;

public class SchemaUpPromotionRules {
    public Optional<CompleteType> getResultantType(CompleteType fileType, CompleteType tableType) {
        if (tableType.equals(CompleteType.NULL)) {
            return Optional.of(fileType);
        }
        if (fileType.equals(CompleteType.BIGINT)) {
            return this.getResultantTypeForBigIntFileType(tableType);
        }
        if (fileType.equals(CompleteType.FLOAT)) {
            return this.getResultantTypeForFloatFileType(tableType);
        }
        if (fileType.equals(CompleteType.DOUBLE)) {
            return this.getResultantTypeForDoubleFileType(tableType);
        }
        if (fileType.equals(CompleteType.VARCHAR)) {
            return this.getResultantTypeForVarcharFileType(tableType);
        }
        if (fileType.isValidDecimal()) {
            return this.getResultantTypeForDecimalFileType(fileType, tableType);
        }
        return Optional.empty();
    }

    private Optional<CompleteType> getResultantTypeForDecimalFileType(CompleteType fileType, CompleteType tableType) {
        if (tableType.equals(CompleteType.INT) || tableType.equals(CompleteType.BIGINT) || tableType.equals(CompleteType.FLOAT)) {
            ArrowType.Decimal decimal = ArrowType.Decimal.createDecimal(fileType.getPrecision(), fileType.getScale(), null);
            return Optional.of(new CompleteType((ArrowType)decimal, new Field[0]));
        }
        if (tableType.isValidDecimal()) {
            int outputScale = this.computeFractional(fileType, tableType);
            int outputPrecision = this.computeIntegral(fileType, tableType) + outputScale;
            if (outputPrecision > 38) {
                return this.handlePrecisionOverflow(fileType, tableType);
            }
            return Optional.of(new CompleteType((ArrowType)ArrowType.Decimal.createDecimal(outputPrecision, outputScale, null), new Field[0]));
        }
        return Optional.empty();
    }

    private Optional<CompleteType> getResultantTypeForVarcharFileType(CompleteType tableType) {
        if (tableType.equals(CompleteType.BIT) || tableType.equals(CompleteType.INT) || tableType.equals(CompleteType.BIGINT) || tableType.equals(CompleteType.FLOAT) || tableType.equals(CompleteType.DOUBLE) || tableType.isValidDecimal() || tableType.isTemporal()) {
            return Optional.of(CompleteType.VARCHAR);
        }
        return Optional.empty();
    }

    private Optional<CompleteType> getResultantTypeForDoubleFileType(CompleteType tableType) {
        if (tableType.equals(CompleteType.INT) || tableType.equals(CompleteType.BIGINT) || tableType.equals(CompleteType.FLOAT) || tableType.isValidDecimal()) {
            return Optional.of(CompleteType.DOUBLE);
        }
        return Optional.empty();
    }

    private Optional<CompleteType> getResultantTypeForFloatFileType(CompleteType tableType) {
        if (tableType.equals(CompleteType.INT) || tableType.equals(CompleteType.BIGINT)) {
            return Optional.of(CompleteType.DOUBLE);
        }
        return Optional.empty();
    }

    private Optional<CompleteType> getResultantTypeForBigIntFileType(CompleteType tableType) {
        if (tableType.equals(CompleteType.INT)) {
            return Optional.of(CompleteType.BIGINT);
        }
        return Optional.empty();
    }

    private Optional<CompleteType> handlePrecisionOverflow(CompleteType fileType, CompleteType tableType) {
        int outputPrecision = 38;
        int outputScale = outputPrecision - this.computeIntegral(fileType, tableType);
        return Optional.of(new CompleteType((ArrowType)ArrowType.Decimal.createDecimal(outputPrecision, outputScale, null), new Field[0]));
    }

    private int computeIntegral(CompleteType fileType, CompleteType tableType) {
        return Math.max(fileType.getPrecision() - fileType.getScale(), tableType.getPrecision() - tableType.getScale());
    }

    private int computeFractional(CompleteType fileType, CompleteType tableType) {
        return Math.max(fileType.getScale(), tableType.getScale());
    }
}

