/*
 * Decompiled with CFR 0.152.
 */
package com.dremio.jdbc.shaded.com.dremio.common.types;

import com.dremio.jdbc.shaded.com.dremio.common.expression.CompleteType;
import com.dremio.jdbc.shaded.org.apache.arrow.vector.types.pojo.ArrowType;
import java.util.Optional;

public class TypeCoercionRules {
    public Optional<CompleteType> getResultantType(CompleteType fileType, CompleteType tableType) {
        if (fileType.equals(CompleteType.NULL)) {
            return Optional.of(tableType);
        }
        if (fileType.equals(CompleteType.INT)) {
            return this.getResultantTypeForIntFileType(tableType);
        }
        if (fileType.equals(CompleteType.BIGINT)) {
            return this.getResultantTypeForBigIntFileType(tableType);
        }
        if (fileType.equals(CompleteType.FLOAT)) {
            return this.getResultantTypeForFloatFileType(tableType);
        }
        if (fileType.equals(CompleteType.DOUBLE)) {
            return this.getResultantTypeForDoubleFileType(tableType);
        }
        if (fileType.equals(CompleteType.BIT)) {
            return this.getResultantTypeForBooleanFileType(tableType);
        }
        if (fileType.isValidDecimal()) {
            return this.getResultantTypeForDecimalFileType(tableType);
        }
        if (fileType.isTemporal()) {
            return this.getResultantTypeForTemporalFileType(tableType);
        }
        return Optional.empty();
    }

    private Optional<CompleteType> getResultantTypeForIntFileType(CompleteType tableType) {
        if (tableType.getType().getTypeID().equals((Object)ArrowType.ArrowTypeID.FloatingPoint)) {
            return Optional.of(CompleteType.DOUBLE);
        }
        if (tableType.isValidDecimal() || tableType.equals(CompleteType.BIGINT) || tableType.isText()) {
            return Optional.of(tableType);
        }
        return Optional.empty();
    }

    private Optional<CompleteType> getResultantTypeForBigIntFileType(CompleteType tableType) {
        if (tableType.getType().getTypeID().equals((Object)ArrowType.ArrowTypeID.FloatingPoint)) {
            return Optional.of(CompleteType.DOUBLE);
        }
        if (tableType.isValidDecimal() || tableType.isText()) {
            return Optional.of(tableType);
        }
        return Optional.empty();
    }

    private Optional<CompleteType> getResultantTypeForFloatFileType(CompleteType tableType) {
        if (tableType.isValidDecimal() || tableType.isText() || tableType.equals(CompleteType.DOUBLE)) {
            return Optional.of(tableType);
        }
        return Optional.empty();
    }

    private Optional<CompleteType> getResultantTypeForDoubleFileType(CompleteType tableType) {
        if (tableType.isText()) {
            return Optional.of(tableType);
        }
        return Optional.empty();
    }

    private Optional<CompleteType> getResultantTypeForBooleanFileType(CompleteType tableType) {
        if (tableType.isText()) {
            return Optional.of(tableType);
        }
        return Optional.empty();
    }

    private Optional<CompleteType> getResultantTypeForDecimalFileType(CompleteType tableType) {
        if (tableType.isValidDecimal() || tableType.isText() || tableType.equals(CompleteType.DOUBLE)) {
            return Optional.of(tableType);
        }
        return Optional.empty();
    }

    private Optional<CompleteType> getResultantTypeForTemporalFileType(CompleteType tableType) {
        if (tableType.isText()) {
            return Optional.of(tableType);
        }
        return Optional.empty();
    }
}

