/*
 * Decompiled with CFR 0.152.
 */
package com.dremio.jdbc.shaded.com.dremio.common.types;

import com.dremio.jdbc.shaded.com.dremio.common.types.TypeProtos;
import com.dremio.jdbc.shaded.com.google.protobuf.TextFormat;

public final class Types {
    public static final TypeProtos.MajorType NULL = Types.required(TypeProtos.MinorType.NULL);
    public static final TypeProtos.MajorType LATE_BIND_TYPE = Types.optional(TypeProtos.MinorType.LATE);
    public static final TypeProtos.MajorType REQUIRED_BIT = Types.required(TypeProtos.MinorType.BIT);
    public static final TypeProtos.MajorType OPTIONAL_BIT = Types.optional(TypeProtos.MinorType.BIT);

    public static boolean isUnion(TypeProtos.MajorType toType) {
        return toType.getMinorType() == TypeProtos.MinorType.UNION;
    }

    public static boolean isComplex(TypeProtos.MajorType type) {
        switch (type.getMinorType()) {
            case LIST: 
            case STRUCT: 
            case MAP: {
                return true;
            }
        }
        return false;
    }

    public static boolean isRepeated(TypeProtos.MajorType type) {
        return type.getMode() == TypeProtos.DataMode.REPEATED;
    }

    public static boolean isNumericType(TypeProtos.MajorType type) {
        if (type.getMode() == TypeProtos.DataMode.REPEATED) {
            return false;
        }
        switch (type.getMinorType()) {
            case BIGINT: 
            case DECIMAL38SPARSE: 
            case DECIMAL38DENSE: 
            case DECIMAL28SPARSE: 
            case DECIMAL28DENSE: 
            case DECIMAL18: 
            case DECIMAL9: 
            case DECIMAL: 
            case FLOAT4: 
            case FLOAT8: 
            case INT: 
            case MONEY: 
            case SMALLINT: 
            case TINYINT: 
            case UINT1: 
            case UINT2: 
            case UINT4: 
            case UINT8: {
                return true;
            }
        }
        return false;
    }

    public static String getSqlTypeName(TypeProtos.MajorType type) {
        if (type.getMode() == TypeProtos.DataMode.REPEATED || type.getMinorType() == TypeProtos.MinorType.LIST) {
            return "ARRAY";
        }
        switch (type.getMinorType()) {
            case BIT: {
                return "BOOLEAN";
            }
            case SMALLINT: {
                return "SMALLINT";
            }
            case INT: {
                return "INTEGER";
            }
            case BIGINT: {
                return "BIGINT";
            }
            case FLOAT4: {
                return "FLOAT";
            }
            case FLOAT8: {
                return "DOUBLE";
            }
            case DECIMAL38SPARSE: 
            case DECIMAL38DENSE: 
            case DECIMAL28SPARSE: 
            case DECIMAL28DENSE: 
            case DECIMAL18: 
            case DECIMAL9: 
            case DECIMAL: {
                return "DECIMAL";
            }
            case VARCHAR: {
                return "CHARACTER VARYING";
            }
            case FIXEDCHAR: {
                return "CHARACTER";
            }
            case VAR16CHAR: {
                return "NATIONAL CHARACTER VARYING";
            }
            case FIXED16CHAR: {
                return "NATIONAL CHARACTER";
            }
            case VARBINARY: {
                return "BINARY VARYING";
            }
            case FIXEDSIZEBINARY: {
                return "BINARY";
            }
            case DATE: {
                return "DATE";
            }
            case TIME: {
                return "TIME";
            }
            case TIMETZ: {
                return "TIME WITH TIME ZONE";
            }
            case TIMESTAMPMILLI: {
                return "TIMESTAMP";
            }
            case TIMESTAMPTZ: {
                return "TIMESTAMP WITH TIME ZONE";
            }
            case INTERVALYEAR: {
                return "INTERVAL YEAR TO MONTH";
            }
            case INTERVALDAY: {
                return "INTERVAL DAY TO SECOND";
            }
            case INTERVAL: {
                return "INTERVAL";
            }
            case MONEY: {
                return "DECIMAL";
            }
            case TINYINT: {
                return "TINYINT";
            }
            case MAP: {
                return "MAP";
            }
            case STRUCT: {
                return "STRUCT";
            }
            case LATE: {
                return "ANY";
            }
            case NULL: {
                return "NULL";
            }
            case UNION: {
                return "UNION";
            }
            case GENERIC_OBJECT: {
                return "JAVA_OBJECT";
            }
            case UINT1: {
                return "TINYINT";
            }
            case UINT2: {
                return "SMALLINT";
            }
            case UINT4: {
                return "INTEGER";
            }
            case UINT8: {
                return "BIGINT";
            }
        }
        throw new AssertionError((Object)("Unexpected/unhandled MinorType value " + String.valueOf(type.getMinorType())));
    }

    public static int getJdbcTypeCode(String sqlTypeName) {
        switch (sqlTypeName) {
            case "ANY": {
                return 1111;
            }
            case "ARRAY": {
                return 1111;
            }
            case "BIGINT": {
                return -5;
            }
            case "BINARY VARYING": {
                return -3;
            }
            case "BINARY": {
                return -2;
            }
            case "BOOLEAN": {
                return 16;
            }
            case "CHARACTER VARYING": {
                return 12;
            }
            case "CHARACTER": {
                return -15;
            }
            case "DATE": {
                return 91;
            }
            case "DECIMAL": {
                return 3;
            }
            case "DOUBLE": {
                return 8;
            }
            case "FLOAT": {
                return 6;
            }
            case "INTEGER": {
                return 4;
            }
            case "INTERVAL": {
                return 1111;
            }
            case "INTERVAL YEAR TO MONTH": {
                return 1111;
            }
            case "INTERVAL DAY TO SECOND": {
                return 1111;
            }
            case "ROW": 
            case "STRUCT": 
            case "MAP": {
                return 1111;
            }
            case "NATIONAL CHARACTER VARYING": {
                return -9;
            }
            case "NATIONAL CHARACTER": {
                return -15;
            }
            case "NULL": {
                return 0;
            }
            case "SMALLINT": {
                return 5;
            }
            case "TIME WITH TIME ZONE": 
            case "TIME": {
                return 92;
            }
            case "TIMESTAMP WITH TIME ZONE": 
            case "TIMESTAMP": {
                return 93;
            }
            case "TINYINT": {
                return -6;
            }
            case "UNION": {
                return 1111;
            }
            case "JAVA_OBJECT": {
                return 2000;
            }
        }
        throw new UnsupportedOperationException("Unexpected/unhandled SqlType value " + sqlTypeName);
    }

    public static boolean isJdbcSignedType(TypeProtos.MajorType type) {
        boolean isSigned;
        block0 : switch (type.getMode()) {
            case REPEATED: {
                isSigned = false;
                break;
            }
            case REQUIRED: 
            case OPTIONAL: {
                switch (type.getMinorType()) {
                    case BIGINT: 
                    case DECIMAL38SPARSE: 
                    case DECIMAL38DENSE: 
                    case DECIMAL28SPARSE: 
                    case DECIMAL28DENSE: 
                    case DECIMAL18: 
                    case DECIMAL9: 
                    case DECIMAL: 
                    case FLOAT4: 
                    case FLOAT8: 
                    case INT: 
                    case MONEY: 
                    case SMALLINT: 
                    case TINYINT: 
                    case INTERVALYEAR: 
                    case INTERVALDAY: 
                    case INTERVAL: {
                        isSigned = true;
                        break block0;
                    }
                    case LIST: 
                    case STRUCT: 
                    case MAP: 
                    case UINT1: 
                    case UINT2: 
                    case UINT4: 
                    case UINT8: 
                    case BIT: 
                    case VARCHAR: 
                    case FIXEDCHAR: 
                    case VAR16CHAR: 
                    case FIXED16CHAR: 
                    case VARBINARY: 
                    case FIXEDSIZEBINARY: 
                    case DATE: 
                    case TIME: 
                    case TIMETZ: 
                    case TIMESTAMPMILLI: 
                    case TIMESTAMPTZ: 
                    case LATE: 
                    case NULL: 
                    case UNION: 
                    case GENERIC_OBJECT: {
                        isSigned = false;
                        break block0;
                    }
                }
                throw new UnsupportedOperationException("Unexpected/unhandled MinorType value " + String.valueOf(type.getMinorType()));
            }
            default: {
                throw new UnsupportedOperationException("Unexpected/unhandled DataMode value " + String.valueOf(type.getMode()));
            }
        }
        return isSigned;
    }

    public static int getJdbcDisplaySize(TypeProtos.MajorType type) {
        if (type.getMode() == TypeProtos.DataMode.REPEATED || type.getMinorType() == TypeProtos.MinorType.LIST) {
            return 0;
        }
        int precision = Types.getPrecision(type);
        switch (type.getMinorType()) {
            case BIT: {
                return 1;
            }
            case TINYINT: {
                return 4;
            }
            case SMALLINT: {
                return 6;
            }
            case INT: {
                return 11;
            }
            case BIGINT: {
                return 20;
            }
            case UINT1: {
                return 3;
            }
            case UINT2: {
                return 5;
            }
            case UINT4: {
                return 10;
            }
            case UINT8: {
                return 19;
            }
            case FLOAT4: {
                return 14;
            }
            case FLOAT8: {
                return 24;
            }
            case DECIMAL38SPARSE: 
            case DECIMAL38DENSE: 
            case DECIMAL28SPARSE: 
            case DECIMAL28DENSE: 
            case DECIMAL18: 
            case DECIMAL9: 
            case DECIMAL: 
            case MONEY: {
                return 2 + precision;
            }
            case VARCHAR: 
            case FIXEDCHAR: 
            case VAR16CHAR: 
            case FIXED16CHAR: {
                return precision;
            }
            case VARBINARY: 
            case FIXEDSIZEBINARY: {
                return 2 * precision;
            }
            case DATE: {
                return 10;
            }
            case TIME: {
                return precision > 0 ? 9 + precision : 8;
            }
            case TIMETZ: {
                return precision > 0 ? 15 + precision : 14;
            }
            case TIMESTAMPMILLI: {
                return precision > 0 ? 20 + precision : 19;
            }
            case TIMESTAMPTZ: {
                return precision > 0 ? 26 + precision : 25;
            }
            case INTERVALYEAR: {
                return precision > 0 ? 5 + precision : 0;
            }
            case INTERVALDAY: {
                return precision > 0 ? 12 + precision : 0;
            }
            case STRUCT: 
            case MAP: 
            case INTERVAL: 
            case LATE: 
            case NULL: 
            case UNION: {
                return 0;
            }
        }
        throw new UnsupportedOperationException("Unexpected/unhandled minor type " + String.valueOf(type.getMinorType()));
    }

    public static boolean usesHolderForGet(TypeProtos.MajorType type) {
        if (type.getMode() == TypeProtos.DataMode.REPEATED) {
            return true;
        }
        switch (type.getMinorType()) {
            case BIGINT: 
            case FLOAT4: 
            case FLOAT8: 
            case INT: 
            case MONEY: 
            case SMALLINT: 
            case TINYINT: 
            case UINT1: 
            case UINT2: 
            case UINT4: 
            case UINT8: 
            case DATE: 
            case TIME: 
            case TIMESTAMPMILLI: 
            case INTERVALYEAR: {
                return false;
            }
        }
        return true;
    }

    public static boolean usesHolderForGet(TypeProtos.MinorType type) {
        switch (type) {
            case BIGINT: 
            case FLOAT4: 
            case FLOAT8: 
            case INT: 
            case MONEY: 
            case SMALLINT: 
            case TINYINT: 
            case UINT1: 
            case UINT2: 
            case UINT4: 
            case UINT8: 
            case DATE: 
            case TIME: 
            case TIMESTAMPMILLI: 
            case INTERVALYEAR: {
                return false;
            }
        }
        return true;
    }

    public static boolean isFixedWidthType(TypeProtos.MinorType type) {
        switch (type) {
            case VARCHAR: 
            case VAR16CHAR: 
            case VARBINARY: 
            case UNION: {
                return false;
            }
        }
        return true;
    }

    public static boolean isFixedWidthType(TypeProtos.MajorType type) {
        return Types.isFixedWidthType(type.getMinorType());
    }

    public static boolean isStringScalarType(TypeProtos.MajorType type) {
        if (type.getMode() == TypeProtos.DataMode.REPEATED) {
            return false;
        }
        switch (type.getMinorType()) {
            case VARCHAR: 
            case FIXEDCHAR: 
            case VAR16CHAR: 
            case FIXED16CHAR: {
                return true;
            }
        }
        return false;
    }

    public static boolean isBytesScalarType(TypeProtos.MajorType type) {
        if (type.getMode() == TypeProtos.DataMode.REPEATED) {
            return false;
        }
        switch (type.getMinorType()) {
            case VARBINARY: 
            case FIXEDSIZEBINARY: {
                return true;
            }
        }
        return false;
    }

    public static Comparability getComparability(TypeProtos.MajorType type) {
        if (type.getMode() == TypeProtos.DataMode.REPEATED) {
            return Comparability.NONE;
        }
        if (type.getMinorType() == TypeProtos.MinorType.LATE) {
            return Comparability.UNKNOWN;
        }
        switch (type.getMinorType()) {
            case LATE: {
                return Comparability.UNKNOWN;
            }
            case STRUCT: {
                return Comparability.NONE;
            }
            case BIT: {
                return Comparability.EQUAL;
            }
        }
        return Comparability.ORDERED;
    }

    public static boolean softEquals(TypeProtos.MajorType a, TypeProtos.MajorType b, boolean allowNullSwap) {
        if (a.getMinorType() != b.getMinorType()) {
            return false;
        }
        if (allowNullSwap) {
            switch (a.getMode()) {
                case REQUIRED: 
                case OPTIONAL: {
                    switch (b.getMode()) {
                        case REQUIRED: 
                        case OPTIONAL: {
                            return true;
                        }
                    }
                }
            }
        }
        return a.getMode() == b.getMode();
    }

    public static boolean isLateBind(TypeProtos.MajorType type) {
        return type.getMinorType() == TypeProtos.MinorType.LATE;
    }

    public static TypeProtos.MajorType withMode(TypeProtos.MinorType type, TypeProtos.DataMode mode) {
        return TypeProtos.MajorType.newBuilder().setMode(mode).setMinorType(type).build();
    }

    public static TypeProtos.MajorType withScaleAndPrecision(TypeProtos.MinorType type, TypeProtos.DataMode mode, int scale, int precision) {
        return TypeProtos.MajorType.newBuilder().setMinorType(type).setMode(mode).setScale(scale).setPrecision(precision).build();
    }

    public static TypeProtos.MajorType required(TypeProtos.MinorType type) {
        return TypeProtos.MajorType.newBuilder().setMode(TypeProtos.DataMode.REQUIRED).setMinorType(type).build();
    }

    public static TypeProtos.MajorType repeated(TypeProtos.MinorType type) {
        return TypeProtos.MajorType.newBuilder().setMode(TypeProtos.DataMode.REPEATED).setMinorType(type).build();
    }

    public static TypeProtos.MajorType optional(TypeProtos.MinorType type) {
        return TypeProtos.MajorType.newBuilder().setMode(TypeProtos.DataMode.OPTIONAL).setMinorType(type).build();
    }

    public static TypeProtos.MajorType overrideMinorType(TypeProtos.MajorType originalMajorType, TypeProtos.MinorType overrideMinorType) {
        switch (originalMajorType.getMode()) {
            case REPEATED: {
                return Types.repeated(overrideMinorType);
            }
            case OPTIONAL: {
                return Types.optional(overrideMinorType);
            }
            case REQUIRED: {
                return Types.required(overrideMinorType);
            }
        }
        throw new UnsupportedOperationException();
    }

    public static TypeProtos.MajorType overrideMode(TypeProtos.MajorType originalMajorType, TypeProtos.DataMode overrideMode) {
        return Types.withScaleAndPrecision(originalMajorType.getMinorType(), overrideMode, originalMajorType.getScale(), originalMajorType.getPrecision());
    }

    public static TypeProtos.MajorType getMajorTypeFromName(String typeName) {
        return Types.getMajorTypeFromName(typeName, TypeProtos.DataMode.REQUIRED);
    }

    public static TypeProtos.MinorType getMinorTypeFromName(String typeName) {
        switch (typeName = typeName.toLowerCase()) {
            case "bool": 
            case "boolean": {
                return TypeProtos.MinorType.BIT;
            }
            case "tinyint": {
                return TypeProtos.MinorType.TINYINT;
            }
            case "uint1": {
                return TypeProtos.MinorType.UINT1;
            }
            case "smallint": {
                return TypeProtos.MinorType.SMALLINT;
            }
            case "uint2": {
                return TypeProtos.MinorType.UINT2;
            }
            case "integer": 
            case "int": {
                return TypeProtos.MinorType.INT;
            }
            case "uint4": {
                return TypeProtos.MinorType.UINT4;
            }
            case "bigint": {
                return TypeProtos.MinorType.BIGINT;
            }
            case "uint8": {
                return TypeProtos.MinorType.UINT8;
            }
            case "float": {
                return TypeProtos.MinorType.FLOAT4;
            }
            case "double": {
                return TypeProtos.MinorType.FLOAT8;
            }
            case "decimal": {
                return TypeProtos.MinorType.DECIMAL;
            }
            case "symbol": 
            case "char": 
            case "utf8": 
            case "varchar": {
                return TypeProtos.MinorType.VARCHAR;
            }
            case "utf16": 
            case "string": 
            case "var16char": {
                return TypeProtos.MinorType.VAR16CHAR;
            }
            case "timestamp": {
                return TypeProtos.MinorType.TIMESTAMPMILLI;
            }
            case "interval_year_month": {
                return TypeProtos.MinorType.INTERVALYEAR;
            }
            case "interval_day_time": {
                return TypeProtos.MinorType.INTERVALDAY;
            }
            case "date": {
                return TypeProtos.MinorType.DATE;
            }
            case "time": {
                return TypeProtos.MinorType.TIME;
            }
            case "binary": {
                return TypeProtos.MinorType.VARBINARY;
            }
            case "json": 
            case "simplejson": 
            case "extendedjson": 
            case "compactjson": {
                return TypeProtos.MinorType.LATE;
            }
            case "array": {
                return TypeProtos.MinorType.LIST;
            }
            case "row": {
                return TypeProtos.MinorType.STRUCT;
            }
            case "null": 
            case "any": {
                return TypeProtos.MinorType.NULL;
            }
            case "map": {
                return TypeProtos.MinorType.MAP;
            }
        }
        throw new UnsupportedOperationException("Could not determine type: " + typeName);
    }

    public static TypeProtos.MajorType getMajorTypeFromName(String typeName, TypeProtos.DataMode mode) {
        return Types.withMode(Types.getMinorTypeFromName(typeName), mode);
    }

    public static String getNameOfMinorType(TypeProtos.MinorType type) {
        switch (type) {
            case BIT: {
                return "bool";
            }
            case TINYINT: {
                return "tinyint";
            }
            case UINT1: {
                return "uint1";
            }
            case SMALLINT: {
                return "smallint";
            }
            case UINT2: {
                return "uint2";
            }
            case INT: {
                return "int";
            }
            case UINT4: {
                return "uint4";
            }
            case BIGINT: {
                return "bigint";
            }
            case UINT8: {
                return "uint8";
            }
            case FLOAT4: {
                return "float";
            }
            case FLOAT8: {
                return "double";
            }
            case DECIMAL9: 
            case DECIMAL: {
                return "decimal";
            }
            case DECIMAL18: {
                return "decimal";
            }
            case DECIMAL28SPARSE: {
                return "decimal";
            }
            case DECIMAL38SPARSE: {
                return "decimal";
            }
            case VARCHAR: {
                return "varchar";
            }
            case VAR16CHAR: {
                return "utf16";
            }
            case DATE: {
                return "date";
            }
            case TIME: {
                return "time";
            }
            case TIMESTAMPMILLI: {
                return "timestamp";
            }
            case VARBINARY: {
                return "binary";
            }
            case LATE: {
                throw new IllegalStateException("The late type should never appear in execution or an SQL query, so it does not have a name to refer to it.");
            }
        }
        throw new IllegalStateException("Unrecognized type " + String.valueOf(type));
    }

    public static String toString(TypeProtos.MajorType type) {
        return type != null ? "MajorType[" + TextFormat.shortDebugString(type) + "]" : "null";
    }

    public static int getPrecision(TypeProtos.MajorType majorType) {
        TypeProtos.MinorType type = majorType.getMinorType();
        if (majorType.hasPrecision()) {
            return majorType.getPrecision();
        }
        if (type == TypeProtos.MinorType.VARBINARY || type == TypeProtos.MinorType.VARCHAR) {
            return 65536;
        }
        return 0;
    }

    public static int getScale(TypeProtos.MajorType majorType) {
        if (majorType.hasScale()) {
            return majorType.getScale();
        }
        return 0;
    }

    public static boolean isSortable(TypeProtos.MinorType type) {
        return type != TypeProtos.MinorType.STRUCT && type != TypeProtos.MinorType.LIST && type != TypeProtos.MinorType.MAP;
    }

    private Types() {
    }

    public static enum Comparability {
        UNKNOWN,
        NONE,
        EQUAL,
        ORDERED;

    }
}

