/*
 * Decompiled with CFR 0.152.
 */
package com.dremio.jdbc.shaded.com.dremio.common.util;

import com.dremio.jdbc.shaded.org.apache.commons.lang3.exception.ExceptionUtils;
import java.io.DataInput;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;

public final class DataInputInputStream
extends InputStream {
    private final DataInput in;
    private boolean closed = false;

    public static InputStream constructInputStream(DataInput in) {
        if (in instanceof InputStream) {
            return (InputStream)((Object)in);
        }
        return new DataInputInputStream(in);
    }

    private DataInputInputStream(DataInput in) {
        this.in = in;
    }

    @Override
    public void close() {
        this.closed = true;
    }

    @Override
    public int available() {
        return this.closed ? 0 : 1;
    }

    @Override
    public int read() throws IOException {
        return this.in.readByte();
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        for (int i = off; i < off + len; ++i) {
            try {
                b[i] = this.in.readByte();
                continue;
            }
            catch (Exception e) {
                if (ExceptionUtils.getRootCause(e) instanceof EOFException) {
                    return i - off;
                }
                throw e;
            }
        }
        return len;
    }

    @Override
    public int read(byte[] b) throws IOException {
        for (int i = 0; i < b.length; ++i) {
            try {
                b[i] = this.in.readByte();
                continue;
            }
            catch (EOFException e) {
                this.close();
                return i;
            }
        }
        return b.length;
    }
}

