/*
 * Decompiled with CFR 0.152.
 */
package com.dremio.jdbc.shaded.com.dremio.common.util;

import com.dremio.jdbc.shaded.com.google.protobuf.Timestamp;
import com.dremio.jdbc.shaded.org.apache.commons.lang3.StringUtils;
import java.time.Instant;
import java.time.OffsetDateTime;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeFormatterBuilder;
import java.time.format.SignStyle;
import java.time.temporal.ChronoField;
import javax.annotation.Nullable;

public final class DateTimeConversionUtils {
    public static final DateTimeFormatter RFC_3339_FORMATTER = new DateTimeFormatterBuilder().appendValue(ChronoField.YEAR, 4, 5, SignStyle.EXCEEDS_PAD).appendLiteral('-').appendValue(ChronoField.MONTH_OF_YEAR, 2).appendLiteral('-').appendValue(ChronoField.DAY_OF_MONTH, 2).appendLiteral('T').appendValue(ChronoField.HOUR_OF_DAY, 2).appendLiteral(':').appendValue(ChronoField.MINUTE_OF_HOUR, 2).appendLiteral(':').appendValue(ChronoField.SECOND_OF_MINUTE, 2).appendOffset("+HH:MM", "Z").toFormatter();

    public static String toRfc3339FormattedStr(Timestamp protoTime) {
        Instant checkStartTime = Instant.ofEpochSecond(protoTime.getSeconds());
        return RFC_3339_FORMATTER.format(ZonedDateTime.ofInstant(checkStartTime, ZoneId.of("UTC")));
    }

    @Nullable
    public static OffsetDateTime toOffsetDateTime(Timestamp protoTime) {
        if (protoTime == null) {
            return null;
        }
        Instant instant = Instant.ofEpochSecond(protoTime.getSeconds());
        return OffsetDateTime.ofInstant(instant, ZoneOffset.UTC);
    }

    @Nullable
    public static OffsetDateTime toOffsetDateTime(String inputDateTime) {
        if (StringUtils.isEmpty(inputDateTime)) {
            return null;
        }
        return OffsetDateTime.parse(inputDateTime, DateTimeFormatter.ISO_OFFSET_DATE_TIME);
    }

    public static OffsetDateTime toOffsetDateTime(long inputTimeStampAsMilli) {
        Instant instant = Instant.ofEpochMilli(inputTimeStampAsMilli);
        return OffsetDateTime.ofInstant(instant, ZoneOffset.UTC);
    }

    @Nullable
    public static Timestamp toProtoTime(OffsetDateTime time) {
        if (time == null) {
            return null;
        }
        long epochSeconds = time.toEpochSecond();
        return Timestamp.newBuilder().setSeconds(epochSeconds).build();
    }

    public static long toTimestampAsMilliseconds(OffsetDateTime time) {
        return time.toInstant().toEpochMilli();
    }

    private DateTimeConversionUtils() {
    }
}

