/*
 * Decompiled with CFR 0.152.
 */
package com.dremio.jdbc.shaded.com.dremio.common.util;

import com.dremio.jdbc.shaded.org.joda.time.DateTime;
import com.dremio.jdbc.shaded.org.joda.time.DateTimeZone;
import com.dremio.jdbc.shaded.org.joda.time.LocalDateTimes;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeFormatterBuilder;
import java.time.temporal.ChronoField;

public final class DateTimes {
    public static final long MILLIS_PER_SECOND = 1000L;
    public static final long MILLIS_PER_DAY = 86400000L;
    public static final long NANOS_PER_MILLISECOND = 1000000L;
    public static final long MICROS_PER_MILLISECOND = 1000L;
    public static final DateTimeFormatter CALCITE_LOCAL_DATE_FORMATTER = DateTimeFormatter.ISO_LOCAL_DATE;
    public static final DateTimeFormatter CALCITE_LOCAL_TIME_FORMATTER = new DateTimeFormatterBuilder().appendValue(ChronoField.HOUR_OF_DAY, 2).appendLiteral(':').appendValue(ChronoField.MINUTE_OF_HOUR, 2).appendLiteral(':').appendValue(ChronoField.SECOND_OF_MINUTE, 2).optionalStart().appendFraction(ChronoField.NANO_OF_SECOND, 0, 9, true).toFormatter();
    public static final DateTimeFormatter CALCITE_LOCAL_DATETIME_FORMATTER;
    public static final DateTimeFormatter ISO_LOCAL_DATE_TIME_WITH_SPACE_FORMATTER;
    public static final DateTimeFormatter TIMESTAMP_TO_CHAR_FORMATTER;

    private DateTimes() {
    }

    public static long toMillis(LocalDateTime localDateTime) {
        return localDateTime.toInstant(ZoneOffset.UTC).toEpochMilli();
    }

    public static long toMillis(LocalDate localDate) {
        return localDate.atStartOfDay(ZoneOffset.UTC).toInstant().toEpochMilli();
    }

    public static long toMillis(LocalTime localTime) {
        return localTime.atDate(LocalDate.EPOCH).toInstant(ZoneOffset.UTC).toEpochMilli();
    }

    public static long toMillis(com.dremio.jdbc.shaded.org.joda.time.LocalDateTime localDateTime) {
        return LocalDateTimes.getLocalMillis(localDateTime);
    }

    public static long toMillis(DateTime dateTime) {
        return dateTime.toDateTime(DateTimeZone.UTC).getMillis();
    }

    public static int toMillisOfDay(DateTime dateTime) {
        return dateTime.toDateTime(DateTimeZone.UTC).millisOfDay().get();
    }

    public static int toMillisOfDay(LocalTime localTime) {
        return localTime.toSecondOfDay() * 1000 + localTime.getNano() / 1000000;
    }

    public static ZoneId jodaTimeZoneToJavaZoneId(DateTimeZone jodaTimeZone) {
        return ZoneId.of(jodaTimeZone.getID());
    }

    public static long isoFormattedLocalDateToMillis(String isoFormattedLocalDate) {
        return LocalDate.parse(isoFormattedLocalDate, DateTimeFormatter.ISO_LOCAL_DATE).atStartOfDay().toInstant(ZoneOffset.UTC).toEpochMilli();
    }

    public static long isoFormattedLocalTimestampToMillis(String isoFormattedLocalTimestamp) {
        return DateTimes.parseIsoLocalTimestampWithSpaces(isoFormattedLocalTimestamp).toInstant(ZoneOffset.UTC).toEpochMilli();
    }

    public static long isoFormattedLocalDateToJavaTimeMillis(String isoFormattedLocalDate) {
        LocalDate localDate = LocalDate.parse(isoFormattedLocalDate, CALCITE_LOCAL_DATE_FORMATTER);
        return localDate.atTime(LocalTime.MIDNIGHT).toInstant(ZoneOffset.UTC).toEpochMilli();
    }

    public static long isoFormattedLocalTimestampToJavaTimeMillis(String isoFormattedLocalTimestamp) {
        LocalDateTime localDateTime = DateTimes.parseIsoLocalTimestampWithSpaces(isoFormattedLocalTimestamp);
        return localDateTime.toInstant(ZoneOffset.UTC).toEpochMilli();
    }

    public static String millisToIsoFormattedLocalDateString(long millis) {
        LocalDateTime localDateTime = DateTimes.parseMillis(millis);
        return localDateTime.toLocalDate().format(CALCITE_LOCAL_DATE_FORMATTER);
    }

    public static String millisToIsoFormattedLocalTimestampString(long millis) {
        LocalDateTime localDateTime = DateTimes.parseMillis(millis);
        return localDateTime.format(CALCITE_LOCAL_DATETIME_FORMATTER);
    }

    public static DateTime toDateTime(com.dremio.jdbc.shaded.org.joda.time.LocalDateTime localDateTime) {
        return localDateTime.toDateTime(DateTimeZone.UTC);
    }

    public static com.dremio.jdbc.shaded.org.joda.time.LocalDateTime javaDateTimeToJoda(LocalDateTime localDateTime) {
        return new com.dremio.jdbc.shaded.org.joda.time.LocalDateTime(localDateTime.getYear(), localDateTime.getMonthValue(), localDateTime.getDayOfMonth(), localDateTime.getHour(), localDateTime.getMinute(), localDateTime.getSecond(), (int)((long)localDateTime.getNano() / 1000000L));
    }

    public static ZonedDateTime parseMillisZoned(long millis, ZoneId zoneId) {
        return ZonedDateTime.ofInstant(Instant.ofEpochMilli(millis), zoneId);
    }

    public static ZonedDateTime parseMillisZoned(long millis, ZoneOffset zoneOffset) {
        return ZonedDateTime.ofInstant(Instant.ofEpochMilli(millis), zoneOffset);
    }

    public static OffsetDateTime parseMillisOffset(long millis, ZoneId zoneId) {
        return OffsetDateTime.ofInstant(Instant.ofEpochMilli(millis), zoneId);
    }

    public static LocalDateTime parseMillis(long millis, ZoneId zoneId) {
        return LocalDateTime.ofInstant(Instant.ofEpochMilli(millis), zoneId);
    }

    public static LocalDateTime parseMillis(long millis) {
        return DateTimes.parseMillis(millis, ZoneOffset.UTC);
    }

    public static LocalDateTime parseLocalDateTime(String str, DateTimeFormatter formatter) {
        return LocalDateTime.parse(str, formatter);
    }

    public static LocalDateTime parseIsoLocalTimestamp(String str) {
        return DateTimes.parseLocalDateTime(str, DateTimeFormatter.ISO_LOCAL_DATE_TIME);
    }

    public static LocalDateTime parseIsoLocalTimestampWithSpaces(String str) {
        return DateTimes.parseLocalDateTime(str, ISO_LOCAL_DATE_TIME_WITH_SPACE_FORMATTER);
    }

    public static LocalDateTime parseIsoLocalTime(String str) {
        return LocalTime.parse(str, DateTimeFormatter.ISO_LOCAL_TIME).atDate(LocalDate.now());
    }

    public static LocalDateTime parseIsoLocalDate(String str) {
        return LocalDate.parse(str, DateTimeFormatter.ISO_LOCAL_DATE).atStartOfDay();
    }

    public static LocalDateTime parseStartOfDay(String str) {
        return DateTimes.parseIsoLocalDate(str);
    }

    public static LocalDate parseLocalDateFromMillis(long millis) {
        return LocalDate.ofInstant(Instant.ofEpochMilli(millis), ZoneOffset.UTC);
    }

    public static LocalTime parseLocalTimeFromMillis(long millis) {
        return LocalTime.ofInstant(Instant.ofEpochMilli(millis), ZoneOffset.UTC);
    }

    public static LocalDateTime parseLocalDateTimeFromMillis(long millis) {
        return DateTimes.parseLocalDateTimeFromMillis(millis, ZoneOffset.UTC);
    }

    public static LocalDateTime parseLocalDateTimeFromMillis(long millis, ZoneId zoneId) {
        return LocalDateTime.ofInstant(Instant.ofEpochMilli(millis), zoneId);
    }

    public static boolean compareDateTimeLikeObjects(com.dremio.jdbc.shaded.org.joda.time.LocalDateTime expected, Object actual) {
        if (actual instanceof LocalDateTime) {
            return DateTimes.compareLocalDateTime(expected, (LocalDateTime)actual);
        }
        if (actual instanceof LocalDate) {
            return DateTimes.compareLocalDate(expected, (LocalDate)actual);
        }
        if (actual instanceof LocalTime) {
            return DateTimes.compareLocalTime(expected, (LocalTime)actual);
        }
        if (actual instanceof com.dremio.jdbc.shaded.org.joda.time.LocalDateTime) {
            return expected.equals(actual);
        }
        return false;
    }

    private static boolean compareLocalDateTime(com.dremio.jdbc.shaded.org.joda.time.LocalDateTime expected, LocalDateTime actual) {
        return expected.equals(DateTimes.javaDateTimeToJoda(actual));
    }

    private static boolean compareLocalDate(com.dremio.jdbc.shaded.org.joda.time.LocalDateTime expected, LocalDate actual) {
        return expected.equals(DateTimes.javaDateTimeToJoda(LocalDateTime.of(actual, LocalTime.MIDNIGHT)));
    }

    private static boolean compareLocalTime(com.dremio.jdbc.shaded.org.joda.time.LocalDateTime expected, LocalTime actual) {
        return expected.equals(DateTimes.javaDateTimeToJoda(LocalDateTime.of(LocalDate.EPOCH, actual)));
    }

    static {
        ISO_LOCAL_DATE_TIME_WITH_SPACE_FORMATTER = CALCITE_LOCAL_DATETIME_FORMATTER = new DateTimeFormatterBuilder().parseCaseInsensitive().append(CALCITE_LOCAL_DATE_FORMATTER).appendLiteral(' ').append(CALCITE_LOCAL_TIME_FORMATTER).toFormatter();
        TIMESTAMP_TO_CHAR_FORMATTER = DateTimeFormatter.ofPattern("yyyy MMM dd HH:mm:ss");
    }
}

