/*
 * Decompiled with CFR 0.152.
 */
package com.dremio.jdbc.shaded.com.dremio.common.util;

import com.dremio.jdbc.shaded.com.dremio.common.util.DateTimes;
import com.dremio.jdbc.shaded.org.apache.arrow.vector.DateMilliVector;
import com.dremio.jdbc.shaded.org.apache.arrow.vector.IntervalDayVector;
import com.dremio.jdbc.shaded.org.apache.arrow.vector.IntervalYearVector;
import com.dremio.jdbc.shaded.org.apache.arrow.vector.TimeMilliVector;
import com.dremio.jdbc.shaded.org.apache.arrow.vector.TimeStampMilliVector;
import com.dremio.jdbc.shaded.org.apache.arrow.vector.ValueVector;
import com.dremio.jdbc.shaded.org.apache.arrow.vector.holders.NullableDateMilliHolder;
import com.dremio.jdbc.shaded.org.apache.arrow.vector.holders.NullableIntervalDayHolder;
import com.dremio.jdbc.shaded.org.apache.arrow.vector.holders.NullableIntervalYearHolder;
import com.dremio.jdbc.shaded.org.apache.arrow.vector.holders.NullableTimeMilliHolder;
import com.dremio.jdbc.shaded.org.apache.arrow.vector.holders.NullableTimeStampMilliHolder;
import com.dremio.jdbc.shaded.org.apache.arrow.vector.types.Types;
import com.dremio.jdbc.shaded.org.joda.time.Period;

public class DremioGetObject {
    public static Period getPeriodObject(IntervalDayVector vector, int index) {
        return (Period)DremioGetObject.getObject(vector, index);
    }

    public static Period getPeriodObject(IntervalYearVector vector, int index) {
        return (Period)DremioGetObject.getObject(vector, index);
    }

    public static Object getObject(ValueVector vector, int index) {
        Types.MinorType minorType = vector.getMinorType();
        switch (minorType) {
            case DATEMILLI: {
                NullableDateMilliHolder holder = new NullableDateMilliHolder();
                ((DateMilliVector)vector).get(index, holder);
                if (holder.isSet == 0) {
                    return null;
                }
                return DateTimes.parseLocalDateFromMillis(holder.value);
            }
            case TIMEMILLI: {
                NullableTimeMilliHolder holder = new NullableTimeMilliHolder();
                ((TimeMilliVector)vector).get(index, holder);
                if (holder.isSet == 0) {
                    return null;
                }
                return DateTimes.parseLocalTimeFromMillis(holder.value);
            }
            case TIMESTAMPMILLI: {
                NullableTimeStampMilliHolder holder = new NullableTimeStampMilliHolder();
                ((TimeStampMilliVector)vector).get(index, holder);
                if (holder.isSet == 0) {
                    return null;
                }
                return DateTimes.parseLocalDateTimeFromMillis(holder.value);
            }
            case INTERVALDAY: {
                NullableIntervalDayHolder holder = new NullableIntervalDayHolder();
                ((IntervalDayVector)vector).get(index, holder);
                if (holder.isSet == 0) {
                    return null;
                }
                int days = holder.days;
                int milliseconds = holder.milliseconds;
                Period p = new Period();
                return p.plusDays(days).plusMillis(milliseconds);
            }
            case INTERVALYEAR: {
                NullableIntervalYearHolder holder = new NullableIntervalYearHolder();
                ((IntervalYearVector)vector).get(index, holder);
                if (holder.isSet == 0) {
                    return null;
                }
                int interval = holder.value;
                int years = interval / 12;
                int months = interval % 12;
                Period p = new Period();
                return p.plusYears(years).plusMonths(months);
            }
        }
        return vector.getObject(index);
    }
}

