/*
 * Decompiled with CFR 0.152.
 */
package com.dremio.jdbc.shaded.com.dremio.common.util;

import com.dremio.jdbc.shaded.com.dremio.common.util.DremioVersionInfo;
import com.dremio.jdbc.shaded.com.dremio.exec.proto.CoordinationProtos;
import com.dremio.jdbc.shaded.org.slf4j.Logger;
import com.dremio.jdbc.shaded.org.slf4j.LoggerFactory;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;

public class DremioVersionUtils {
    private static final Logger logger = LoggerFactory.getLogger(DremioVersionUtils.class);

    public static boolean isCompatibleVersion(CoordinationProtos.NodeEndpoint endpoint) {
        boolean isCompatible = DremioVersionUtils.isCompatibleVersion(endpoint.getDremioVersion());
        logger.debug("NodeEndpoint address:" + endpoint.getAddress() + ", NodeEndpoint version:" + endpoint.getDremioVersion() + ", Coordinator version:" + DremioVersionInfo.getVersion() + ", is NodeEndpoint compatible ?: " + isCompatible);
        return isCompatible;
    }

    public static boolean isCompatibleVersion(String version) {
        return DremioVersionInfo.getVersion().equals(version);
    }

    public static Collection<CoordinationProtos.NodeEndpoint> getCompatibleNodeEndpoints(Collection<CoordinationProtos.NodeEndpoint> nodeEndpoints) {
        List<Object> compatibleNodeEndpoints = new ArrayList();
        if (nodeEndpoints != null && !nodeEndpoints.isEmpty()) {
            compatibleNodeEndpoints = nodeEndpoints.stream().filter(nep -> DremioVersionUtils.isCompatibleVersion(nep)).collect(Collectors.toList());
        }
        return Collections.unmodifiableCollection(compatibleNodeEndpoints);
    }
}

