/*
 * Decompiled with CFR 0.152.
 */
package com.dremio.jdbc.shaded.com.dremio.common.util;

public enum FileSizeUnit {
    BYTE(1L),
    KB(BYTE.getSizeInBytes() << 10),
    MB(KB.getSizeInBytes() << 10),
    GB(MB.getSizeInBytes() << 10),
    TB(GB.getSizeInBytes() << 10),
    PB(TB.getSizeInBytes() << 10);

    private final long sizeInBytes;

    private FileSizeUnit(long valueInBytes) {
        this.sizeInBytes = valueInBytes;
    }

    public long getSizeInBytes() {
        return this.sizeInBytes;
    }

    public static long toUnit(long sizeInBytes, FileSizeUnit unit) {
        return FileSizeUnit.toUnit(sizeInBytes, BYTE, unit);
    }

    public static long toUnit(long size, FileSizeUnit fromUnit, FileSizeUnit toUnit) {
        long sizeInBytes = size * fromUnit.getSizeInBytes();
        return Math.round((double)sizeInBytes / (double)toUnit.getSizeInBytes());
    }
}

