/*
 * Decompiled with CFR 0.152.
 */
package com.dremio.jdbc.shaded.com.dremio.common.util;

import java.text.DecimalFormat;

public final class FormattingUtils {
    private static final DecimalFormat decimalFormat = new DecimalFormat("0.00");
    private static final DecimalFormat intFormat = new DecimalFormat("#,###");

    private FormattingUtils() {
    }

    private static String bytePrint(long bytes) {
        double t2 = (double)bytes / Math.pow(1024.0, 4.0);
        if (Math.abs(t2) > 1.0) {
            return decimalFormat.format(t2).concat(" TiB");
        }
        double g2 = (double)bytes / Math.pow(1024.0, 3.0);
        if (Math.abs(g2) > 1.0) {
            return decimalFormat.format(g2).concat(" GiB");
        }
        double m4 = (double)bytes / Math.pow(1024.0, 2.0);
        if (Math.abs(m4) > 1.0) {
            return intFormat.format(m4).concat(" MiB");
        }
        double k = (double)bytes / 1024.0;
        if (Math.abs(k) >= 1.0) {
            return intFormat.format(k).concat(" KiB");
        }
        return intFormat.format(k).concat(" bytes");
    }

    public static String formatBytes(long bytes) {
        if (Math.abs(bytes) == 1L) {
            return String.format("%d byte", bytes);
        }
        if (Math.abs(bytes) < 1024L) {
            return String.format("%d bytes", bytes);
        }
        return String.format("%d bytes (%s)", bytes, FormattingUtils.bytePrint(bytes));
    }
}

