/*
 * Decompiled with CFR 0.152.
 */
package com.dremio.jdbc.shaded.com.dremio.common.util;

import com.dremio.jdbc.shaded.com.dremio.common.AutoCloseables;
import com.dremio.jdbc.shaded.com.dremio.common.concurrent.CloseableSchedulerThreadPool;
import com.dremio.jdbc.shaded.com.dremio.common.util.MayExpire;
import com.dremio.jdbc.shaded.com.google.common.cache.CacheBuilder;
import com.dremio.jdbc.shaded.com.google.common.cache.CacheLoader;
import com.dremio.jdbc.shaded.com.google.common.cache.ForwardingLoadingCache;
import com.dremio.jdbc.shaded.com.google.common.cache.LoadingCache;
import com.dremio.jdbc.shaded.com.google.common.cache.RemovalListener;
import com.dremio.jdbc.shaded.org.slf4j.Logger;
import com.dremio.jdbc.shaded.org.slf4j.LoggerFactory;
import java.util.Map;
import java.util.concurrent.TimeUnit;

public class LoadingCacheWithExpiry<K, V extends MayExpire>
extends ForwardingLoadingCache<K, V>
implements AutoCloseable {
    private static final Logger logger = LoggerFactory.getLogger(LoadingCacheWithExpiry.class);
    private final LoadingCache<K, V> inner;
    private final CloseableSchedulerThreadPool scheduler;

    public LoadingCacheWithExpiry(String name, CacheLoader<K, V> loader, RemovalListener removalListener, long refreshDelayMs) {
        this.inner = removalListener != null ? CacheBuilder.newBuilder().removalListener(removalListener).build(loader) : CacheBuilder.newBuilder().build(loader);
        this.scheduler = new CloseableSchedulerThreadPool("cache-cleaner-" + name, 1);
        this.initEvictionAction(refreshDelayMs);
    }

    private void initEvictionAction(long refreshDelayMs) {
        this.scheduler.scheduleWithFixedDelay(this.getEvictionAction(), refreshDelayMs, refreshDelayMs, TimeUnit.MILLISECONDS);
    }

    public void checkAndEvict() {
        this.getEvictionAction().run();
    }

    private Runnable getEvictionAction() {
        return () -> {
            for (Map.Entry entry : this.inner.asMap().entrySet()) {
                try {
                    if (!((MayExpire)entry.getValue()).isExpired()) continue;
                    this.inner.invalidate(entry.getKey());
                }
                catch (Throwable e) {
                    logger.warn("Failed to evict entry");
                }
            }
        };
    }

    @Override
    protected LoadingCache<K, V> delegate() {
        return this.inner;
    }

    @Override
    public void close() throws Exception {
        this.inner.invalidateAll();
        AutoCloseables.close(this.scheduler);
    }
}

