/*
 * Decompiled with CFR 0.152.
 */
package com.dremio.jdbc.shaded.com.dremio.common.util;

import com.dremio.jdbc.shaded.org.slf4j.Logger;
import com.dremio.jdbc.shaded.org.slf4j.LoggerFactory;
import java.time.Instant;
import java.time.LocalTime;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;

public class LocalTimeUtility {
    private static final Logger logger = LoggerFactory.getLogger(LocalTimeUtility.class);
    private static final String TIME_MILLI_FORMAT = "HH:mm:ss.SSS";
    private static final String UTC_ZONE = "UTC";

    public static DateTimeFormatter getFormaterForTime() {
        return DateTimeFormatter.ofPattern(TIME_MILLI_FORMAT);
    }

    public static LocalTime getTimeFromMillis(long value) {
        return LocalTimeUtility.getTimeFromMillis(value, ZoneId.of(UTC_ZONE));
    }

    public static ZoneId getTimeZoneId() {
        String timezone = System.getProperty("user.timezone");
        try {
            return ZoneId.of(timezone);
        }
        catch (Exception e) {
            logger.error("'" + timezone + "' is an unregistered timezone. Using UTC");
            return ZoneId.of(UTC_ZONE);
        }
    }

    public static LocalTime getTimeFromMillis(long value, ZoneId zone) {
        return Instant.ofEpochMilli(value).atZone(zone).toLocalTime();
    }

    public static int getMillisFromTime(LocalTime time) {
        return (int)(time.toNanoOfDay() / 1000000L);
    }

    public static int getMillis(LocalTime time) {
        return time.getNano() / 1000000;
    }
}

