/*
 * Decompiled with CFR 0.152.
 */
package com.dremio.jdbc.shaded.com.dremio.common.util;

import com.dremio.jdbc.shaded.com.dremio.common.types.TypeProtos;
import com.dremio.jdbc.shaded.com.dremio.common.types.Types;
import com.dremio.jdbc.shaded.com.dremio.common.util.ObjectType;
import com.dremio.jdbc.shaded.org.apache.arrow.vector.types.TimeUnit;
import com.dremio.jdbc.shaded.org.apache.arrow.vector.types.Types;
import com.dremio.jdbc.shaded.org.apache.arrow.vector.types.pojo.ArrowType;
import com.dremio.jdbc.shaded.org.apache.arrow.vector.types.pojo.Field;
import com.dremio.jdbc.shaded.org.apache.arrow.vector.types.pojo.FieldType;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public final class MajorTypeHelper {
    public static Types.MinorType getArrowMinorType(TypeProtos.MinorType minorType) {
        switch (minorType) {
            case LATE: {
                return Types.MinorType.NULL;
            }
            case TIMESTAMPMILLI: {
                return Types.MinorType.TIMESTAMPMILLI;
            }
            case TIME: {
                return Types.MinorType.TIMEMILLI;
            }
            case DATE: {
                return Types.MinorType.DATEMILLI;
            }
        }
        return Types.MinorType.valueOf(minorType.name());
    }

    public static TypeProtos.MajorType getMajorTypeForField(Field field) {
        if (field.getType() instanceof ObjectType) {
            return Types.required(TypeProtos.MinorType.GENERIC_OBJECT);
        }
        return MajorTypeHelper.getMajorTypeForArrowType(field.getType(), field.isNullable(), field.getChildren());
    }

    public static TypeProtos.MajorType getMajorTypeForArrowType(ArrowType arrowType, boolean isNullable, List<Field> children) {
        TypeProtos.MajorType.Builder builder = TypeProtos.MajorType.newBuilder().setMinorType(MajorTypeHelper.getMinorTypeFromArrowMinorType(com.dremio.jdbc.shaded.org.apache.arrow.vector.types.Types.getMinorTypeForArrowType(arrowType))).setMode(isNullable ? TypeProtos.DataMode.OPTIONAL : TypeProtos.DataMode.REQUIRED);
        ArrowType.ArrowTypeID fieldType = arrowType.getTypeID();
        switch (fieldType) {
            case Decimal: {
                builder.setPrecision(((ArrowType.Decimal)arrowType).getPrecision()).setScale(((ArrowType.Decimal)arrowType).getScale());
                break;
            }
            case Utf8: 
            case Binary: {
                builder.setPrecision(65536);
                break;
            }
            case Timestamp: {
                builder.setPrecision(MajorTypeHelper.getPrecisionFromTimeUnit(((ArrowType.Timestamp)arrowType).getUnit()));
                break;
            }
            case Time: {
                builder.setPrecision(MajorTypeHelper.getPrecisionFromTimeUnit(((ArrowType.Time)arrowType).getUnit()));
                break;
            }
            case Union: {
                for (Field child : children) {
                    builder.addSubType(MajorTypeHelper.getMinorTypeFromArrowMinorType(com.dremio.jdbc.shaded.org.apache.arrow.vector.types.Types.getMinorTypeForArrowType(child.getType())));
                }
                break;
            }
        }
        return builder.build();
    }

    public static ArrowType getArrowTypeForMajorType(TypeProtos.MajorType majorType) {
        if (majorType.getMinorType() == TypeProtos.MinorType.DECIMAL) {
            return new ArrowType.Decimal(majorType.getPrecision(), majorType.getScale(), 128);
        }
        return MajorTypeHelper.getArrowMinorType(majorType.getMinorType()).getType();
    }

    public static Field getFieldForNameAndMajorType(String name, TypeProtos.MajorType majorType) {
        try {
            return new Field(name, new FieldType(majorType.getMode() == TypeProtos.DataMode.OPTIONAL, MajorTypeHelper.getArrowTypeForMajorType(majorType), null), MajorTypeHelper.getChildrenForMajorType(majorType));
        }
        catch (IllegalArgumentException e) {
            throw new IllegalArgumentException(String.format("Could not get field for name: %s, majorType:%s", name, majorType), e);
        }
    }

    public static List<Field> getChildrenForMajorType(TypeProtos.MajorType majorType) {
        ArrayList<Field> children = new ArrayList<Field>();
        switch (majorType.getMinorType()) {
            case UNION: {
                for (TypeProtos.MinorType minorType : majorType.getSubTypeList()) {
                    children.add(Field.nullable("", MajorTypeHelper.getArrowMinorType(minorType).getType()));
                }
                return children;
            }
        }
        return Collections.emptyList();
    }

    public static List<Types.MinorType> getArrowSubtypes(List<TypeProtos.MinorType> subTypes) {
        if (subTypes == null) {
            return null;
        }
        ArrayList<Types.MinorType> arrowMinorTypes = new ArrayList<Types.MinorType>();
        for (TypeProtos.MinorType minorType : subTypes) {
            arrowMinorTypes.add(MajorTypeHelper.getArrowMinorType(minorType));
        }
        return arrowMinorTypes;
    }

    public static TypeProtos.MinorType getMinorTypeFromArrowMinorType(Types.MinorType arrowMinorType) {
        switch (arrowMinorType) {
            case TIMESTAMPMILLI: {
                return TypeProtos.MinorType.TIMESTAMPMILLI;
            }
            case TIMESTAMPMILLITZ: {
                return TypeProtos.MinorType.TIMESTAMPTZ;
            }
            case TIMEMILLI: {
                return TypeProtos.MinorType.TIME;
            }
            case DATEMILLI: {
                return TypeProtos.MinorType.DATE;
            }
        }
        return TypeProtos.MinorType.valueOf(arrowMinorType.name());
    }

    public static Integer getPrecisionFromTimeUnit(TimeUnit unit) {
        switch (unit) {
            case SECOND: {
                return 0;
            }
            case MILLISECOND: {
                return 3;
            }
            case MICROSECOND: {
                return 6;
            }
            case NANOSECOND: {
                return 9;
            }
        }
        throw new AssertionError((Object)("Arrow TimeUnit " + String.valueOf((Object)unit) + "not supported"));
    }

    private MajorTypeHelper() {
    }
}

