/*
 * Decompiled with CFR 0.152.
 */
package com.dremio.jdbc.shaded.com.dremio.common.util;

import com.dremio.jdbc.shaded.org.junit.rules.TestRule;
import com.dremio.jdbc.shaded.org.junit.runner.Description;
import com.dremio.jdbc.shaded.org.junit.runners.model.Statement;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;

public class RepeatTestRule
implements TestRule {
    public Statement apply(Statement base, Description description) {
        Repeat repeat = (Repeat)description.getAnnotation(Repeat.class);
        return repeat != null ? new RepeatStatement(base, repeat.count()) : base;
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.METHOD, ElementType.TYPE})
    public static @interface Repeat {
        public int count();
    }

    private static final class RepeatStatement
    extends Statement {
        private final Statement statement;
        private final int count;

        private RepeatStatement(Statement statement, int count) {
            this.statement = statement;
            this.count = count;
        }

        public void evaluate() throws Throwable {
            for (int i = 0; i < this.count; ++i) {
                this.statement.evaluate();
            }
        }
    }
}

