/*
 * Decompiled with CFR 0.152.
 */
package com.dremio.jdbc.shaded.com.dremio.common.util;

import com.dremio.jdbc.shaded.com.google.common.primitives.Ints;
import java.util.Base64;

public final class RequestUtil {
    public static final int BASE64_DIGITS_FOR_INTEGER = 6;
    private static final Base64.Decoder DECODER = Base64.getUrlDecoder();

    private RequestUtil() {
    }

    public static int decodePageToken(String pageToken, RuntimeException exception) {
        try {
            String padded = RequestUtil.prependLeadingA(pageToken);
            byte[] rawBytes = DECODER.decode(padded);
            return Ints.fromByteArray(rawBytes);
        }
        catch (IllegalArgumentException e) {
            throw exception;
        }
    }

    private static String prependLeadingA(String incomingToken) {
        if (6 == incomingToken.length()) {
            return incomingToken;
        }
        if (6 < incomingToken.length()) {
            throw new IllegalArgumentException("Invalid page token: " + incomingToken);
        }
        StringBuilder sb = new StringBuilder(incomingToken);
        while (sb.length() < 6) {
            sb.insert(0, "A");
        }
        return sb.toString();
    }
}

