/*
 * Decompiled with CFR 0.152.
 */
package com.dremio.jdbc.shaded.com.dremio.common.util;

import com.dremio.jdbc.shaded.com.dremio.io.ExponentialBackoff;
import com.dremio.jdbc.shaded.com.google.common.annotations.VisibleForTesting;
import com.dremio.jdbc.shaded.com.google.common.base.Preconditions;
import com.dremio.jdbc.shaded.com.google.errorprone.annotations.CheckReturnValue;
import com.dremio.jdbc.shaded.org.slf4j.Logger;
import com.dremio.jdbc.shaded.org.slf4j.LoggerFactory;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.function.Function;

public class Retryer
implements ExponentialBackoff {
    private static final Logger logger = LoggerFactory.getLogger(Retryer.class);
    private final Set<Class<? extends Exception>> retryableExceptionClasses = new HashSet<Class<? extends Exception>>();
    private WaitStrategy waitStrategy = WaitStrategy.EXPONENTIAL;
    private int maxRetries = 4;
    private int baseMillis = 250;
    private int maxMillis = 2500;
    private boolean infiniteRetries;
    private final Function<Exception, Boolean> isExceptionClassRetriable = ex -> this.retryableExceptionClasses.stream().anyMatch(clz -> clz.isInstance(ex));
    private Function<Exception, Boolean> isRetriable = this.isExceptionClassRetriable;

    private Retryer() {
    }

    public <T> T call(Callable<T> callable) {
        for (int attemptNo = 1; this.infiniteRetries || attemptNo <= this.maxRetries; ++attemptNo) {
            try {
                return callable.call();
            }
            catch (Exception e) {
                this.checkRetriableException(attemptNo, e);
                continue;
            }
        }
        throw new OperationFailedAfterRetriesException();
    }

    public void run(Runnable runnable) {
        for (int attemptNo = 1; this.infiniteRetries || attemptNo <= this.maxRetries; ++attemptNo) {
            try {
                runnable.run();
                return;
            }
            catch (Exception e) {
                this.checkRetriableException(attemptNo, e);
                continue;
            }
        }
        throw new OperationFailedAfterRetriesException();
    }

    private void checkRetriableException(int attemptNo, Exception e) {
        boolean retryable = this.isRetriable.apply(e);
        if (!retryable || !this.infiniteRetries && attemptNo == this.maxRetries) {
            throw new OperationFailedAfterRetriesException(e);
        }
        StackTraceElement caller = Thread.currentThread().getStackTrace()[3];
        logger.warn(String.format("Retry attempt %s for the failure at %s:%s:%s", attemptNo, caller.getClassName(), caller.getMethodName(), caller.getLineNumber()), e);
        switch (this.waitStrategy.ordinal()) {
            case 0: {
                this.backoffWait(attemptNo);
                break;
            }
            case 1: {
                this.flatWait();
                break;
            }
            default: {
                throw new UnsupportedOperationException("Strategy not implemented: " + this.waitStrategy.name());
            }
        }
    }

    @Override
    public int getBaseMillis() {
        return this.baseMillis;
    }

    @Override
    public int getMaxMillis() {
        return this.maxMillis;
    }

    private void flatWait() {
        this.sleep(this.baseMillis);
    }

    @VisibleForTesting
    void sleep(long millis) {
        try {
            Thread.sleep(millis);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
    }

    @VisibleForTesting
    public int getMaxRetries() {
        return this.maxRetries;
    }

    @CheckReturnValue
    public static Builder newBuilder() {
        return new Builder();
    }

    public Retryer copy() {
        Retryer copy = new Retryer();
        copy.waitStrategy = this.waitStrategy;
        copy.baseMillis = this.baseMillis;
        copy.maxMillis = this.maxMillis;
        copy.maxRetries = this.maxRetries;
        copy.retryableExceptionClasses.addAll(this.retryableExceptionClasses);
        copy.isRetriable = this.isRetriable;
        return copy;
    }

    public static enum WaitStrategy {
        EXPONENTIAL,
        FLAT;

    }

    public static class OperationFailedAfterRetriesException
    extends RuntimeException {
        OperationFailedAfterRetriesException() {
        }

        OperationFailedAfterRetriesException(Exception e) {
            super(e);
        }

        public <T extends Exception> T getWrappedCause(Class<T> clazz, Function<Throwable, T> conversionFunc) {
            Throwable cause = this.getCause();
            return (T)(clazz.isInstance(cause) ? (Exception)clazz.cast(cause) : (Exception)conversionFunc.apply(cause));
        }
    }

    public static final class Builder {
        private final Retryer retryer = new Retryer();

        private Builder() {
        }

        public Builder retryIfExceptionOfType(Class<? extends Exception> clazz) {
            Preconditions.checkState(this.retryer.isRetriable == this.retryer.isExceptionClassRetriable, "Retryer does not support mix of exception class and exception function");
            this.retryer.retryableExceptionClasses.add(clazz);
            return this;
        }

        public Builder retryOnExceptionFunc(Function<Exception, Boolean> function) {
            Preconditions.checkState(this.retryer.retryableExceptionClasses.isEmpty(), "Retryer does not support mix of exception class and exception function");
            this.retryer.isRetriable = function;
            return this;
        }

        public Builder setWaitStrategy(WaitStrategy waitStrategy, int baseMillis, int maxMillis) {
            this.retryer.waitStrategy = waitStrategy;
            this.retryer.baseMillis = baseMillis;
            this.retryer.maxMillis = maxMillis;
            return this;
        }

        public Builder setMaxRetries(int maxRetries) {
            this.retryer.maxRetries = maxRetries;
            return this;
        }

        public Builder setInfiniteRetries(boolean infiniteRetries) {
            this.retryer.infiniteRetries = infiniteRetries;
            return this;
        }

        public Retryer build() {
            return this.retryer;
        }
    }
}

