/*
 * Decompiled with CFR 0.152.
 */
package com.dremio.jdbc.shaded.com.dremio.common.util;

import com.dremio.jdbc.shaded.com.dremio.common.VM;
import com.dremio.jdbc.shaded.com.dremio.common.util.RepeatTestRule;
import com.dremio.jdbc.shaded.org.junit.rules.TestRule;
import com.dremio.jdbc.shaded.org.junit.rules.Timeout;
import java.nio.file.Paths;
import java.time.Duration;
import java.util.concurrent.TimeUnit;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class TestTools {
    private static final TestRule NOP_RULE = (statement, description) -> statement;
    static final String WORKING_PATH = Paths.get("", new String[0]).toAbsolutePath().toString();
    private static final String PATH_SEPARATOR = System.getProperty("file.separator");
    private static final String[] STRUCTURE = new String[]{"dremio", "exec", "java-exec", "src", "test", "resources"};

    public static TestRule getTimeoutRule() {
        return TestTools.getTimeoutRule(Duration.ofSeconds(10L));
    }

    public static TestRule getTimeoutRule(Duration duration) {
        return TestTools.getTimeoutRule(duration.getSeconds(), TimeUnit.SECONDS);
    }

    public static TestRule getTimeoutRule(long timeout, TimeUnit unit) {
        if (VM.isDebugEnabled()) {
            return NOP_RULE;
        }
        return Timeout.builder().withTimeout(timeout, unit).withLookingForStuckThread(true).build();
    }

    public static TestRule getRepeatRule(boolean enforce) {
        return enforce || !VM.isDebugEnabled() ? new RepeatTestRule() : NOP_RULE;
    }

    public static String getWorkingPath() {
        return WORKING_PATH;
    }

    public static String replaceWorkingPathPlaceholders(String input) {
        if (input.contains("${WORKING_PATH}")) {
            return input.replaceAll(Pattern.quote("${WORKING_PATH}"), Matcher.quoteReplacement(WORKING_PATH));
        }
        if (input.contains("[WORKING_PATH]")) {
            return input.replaceAll(Pattern.quote("[WORKING_PATH]"), Matcher.quoteReplacement(WORKING_PATH));
        }
        return input;
    }

    public static String getTestResourcesPath() {
        StringBuilder builder = new StringBuilder(WORKING_PATH);
        for (int i = 0; i < STRUCTURE.length; ++i) {
            if (!WORKING_PATH.endsWith(STRUCTURE[i])) continue;
            for (int j = i + 1; j < STRUCTURE.length; ++j) {
                builder.append(PATH_SEPARATOR).append(STRUCTURE[j]);
            }
            return builder.toString();
        }
        String msg = String.format("Unable to recognize working directory[%s]. The workspace must be root or exec module.", WORKING_PATH);
        throw new IllegalStateException(msg);
    }
}

