/*
 * Decompiled with CFR 0.152.
 */
package com.dremio.jdbc.shaded.com.dremio.common.util.concurrent;

import com.dremio.jdbc.shaded.com.dremio.common.util.Closeable;
import com.dremio.jdbc.shaded.org.slf4j.Logger;
import com.dremio.jdbc.shaded.org.slf4j.LoggerFactory;

public final class ContextClassLoaderSwapper
implements Closeable {
    private final ClassLoader originalClassLoader = Thread.currentThread().getContextClassLoader();
    private static final Logger logger = LoggerFactory.getLogger(ContextClassLoaderSwapper.class);

    private ContextClassLoaderSwapper(ClassLoader classLoader) {
        Thread.currentThread().setContextClassLoader(classLoader);
    }

    @Override
    public void close() {
        logger.debug("Loading original class loader {}", (Object)this.originalClassLoader);
        Thread.currentThread().setContextClassLoader(this.originalClassLoader);
    }

    public static Closeable swapClassLoader(Class<?> classObj) {
        logger.debug("Current class loader swapped with {} class loader", (Object)classObj.getClassLoader());
        return new ContextClassLoaderSwapper(classObj.getClassLoader());
    }
}

