/*
 * Decompiled with CFR 0.152.
 */
package com.dremio.jdbc.shaded.com.dremio.common.util.concurrent;

import com.dremio.jdbc.shaded.com.google.common.util.concurrent.Futures;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.function.Function;

public final class DremioFutures {
    private DremioFutures() {
    }

    public static <T, X extends Exception> T getChecked(Future<T> future, Class<X> exceptionClass, Function<? super Throwable, ? extends X> mapper) throws X {
        try {
            return Futures.getChecked(future, ExecutionException.class);
        }
        catch (ExecutionException e) {
            try {
                DremioFutures.handleException(e, exceptionClass, mapper);
                throw new AssertionError();
            }
            catch (TimeoutException ex) {
                throw new AssertionError();
            }
        }
    }

    public static <T, X extends Exception> T getChecked(Future<T> future, Class<X> exceptionClass, long timeout, TimeUnit unit, Function<? super Throwable, ? extends X> mapper) throws TimeoutException, X {
        try {
            return Futures.getChecked(future, ExecutionException.class, timeout, unit);
        }
        catch (ExecutionException e) {
            DremioFutures.handleException(e, exceptionClass, mapper);
            throw new AssertionError();
        }
    }

    private static <X extends Exception> void handleException(ExecutionException e, Class<X> exceptionClass, Function<? super Throwable, ? extends X> mapper) throws TimeoutException, X {
        Throwable cause = e.getCause();
        if (exceptionClass.isInstance(cause) || cause instanceof RuntimeException || cause instanceof Error) {
            throw (Exception)mapper.apply(cause);
        }
        if (cause instanceof TimeoutException) {
            throw (TimeoutException)cause;
        }
        throw (Exception)mapper.apply(e);
    }
}

