/*
 * Decompiled with CFR 0.152.
 */
package com.dremio.jdbc.shaded.com.dremio.common.utils;

import com.dremio.jdbc.shaded.com.google.common.base.Preconditions;
import com.dremio.jdbc.shaded.com.google.protobuf.ByteOutput;
import java.nio.ByteBuffer;

public class OptimisticByteOutput
extends ByteOutput {
    private static final byte[] EMPTY = new byte[0];
    private final int payloadSize;
    private byte[] arrayReference;
    private int arrayOffset;

    public OptimisticByteOutput(int payloadSize) {
        this.payloadSize = payloadSize;
    }

    @Override
    public void write(byte value) {
        this.checkArray();
        this.arrayReference[this.arrayOffset++] = value;
    }

    @Override
    public void write(byte[] value, int offset, int length) {
        if (length == 0) {
            return;
        }
        this.checkArray();
        System.arraycopy(value, offset, this.arrayReference, this.arrayOffset, length);
        this.arrayOffset += length;
    }

    @Override
    public void writeLazy(byte[] value, int offset, int length) {
        if (this.arrayReference == null && this.payloadSize == length && offset == 0) {
            this.arrayReference = value;
            this.arrayOffset += this.payloadSize;
            return;
        }
        this.write(value, offset, length);
    }

    @Override
    public void write(ByteBuffer value) {
        if (!value.hasRemaining()) {
            return;
        }
        this.checkArray();
        int length = value.remaining();
        value.get(this.arrayReference, this.arrayOffset, length);
        this.arrayOffset += length;
    }

    @Override
    public void writeLazy(ByteBuffer value) {
        if (this.arrayReference == null && value.hasArray() && value.arrayOffset() == 0 && value.array().length == this.payloadSize && value.position() == 0 && value.remaining() == this.payloadSize) {
            this.arrayReference = value.array();
            this.arrayOffset += this.payloadSize;
            value.position(this.payloadSize);
            return;
        }
        this.write(value);
    }

    public byte[] toByteArray() {
        if (this.payloadSize == 0) {
            return this.arrayReference != null ? this.arrayReference : EMPTY;
        }
        Preconditions.checkState(this.arrayOffset == this.payloadSize, "Byte payload not fully received.");
        return this.arrayReference;
    }

    private void checkArray() {
        if (this.arrayReference == null) {
            this.arrayReference = new byte[this.payloadSize];
        }
    }
}

