/*
 * Decompiled with CFR 0.152.
 */
package com.dremio.jdbc.shaded.com.dremio.common.utils;

import com.dremio.jdbc.shaded.com.dremio.common.nodes.EndpointHelper;
import com.dremio.jdbc.shaded.com.dremio.common.utils.protos.QueryIdHelper;
import com.dremio.jdbc.shaded.com.dremio.exec.proto.CoordinationProtos;
import com.dremio.jdbc.shaded.com.dremio.exec.proto.UserBitShared;

public class ProfilesPathUtils {
    private static final String SEPARATOR = "/";
    private static final String INTERMEDIATE = "intermediate";
    private static final String FINAL = "final";
    private static final String PLANNING = "planning";
    private static final String TAIL = "tail";
    private static final String EXECUTOR = "executor";
    private static final String FULL = "Full";
    public static final String FINAL_EXECUTOR_PROFILE_SUFFIX = "_final";

    public static String buildProfilePrefix(UserBitShared.QueryId queryId) {
        return QueryIdHelper.getQueryId(queryId) + SEPARATOR;
    }

    public static String buildIntermediatePrefix(UserBitShared.QueryId queryId) {
        return ProfilesPathUtils.buildProfilePrefix(queryId) + "intermediate/";
    }

    public static String buildPlanningProfilePath(UserBitShared.QueryId queryId) {
        return ProfilesPathUtils.buildIntermediatePrefix(queryId) + PLANNING;
    }

    public static String buildTailProfilePath(UserBitShared.QueryId queryId) {
        return ProfilesPathUtils.buildIntermediatePrefix(queryId) + TAIL;
    }

    public static String buildExecutorProfilePrefix(UserBitShared.QueryId queryId) {
        return ProfilesPathUtils.buildIntermediatePrefix(queryId) + "executor/";
    }

    public static String buildExecutorProfilePath(UserBitShared.QueryId queryId, CoordinationProtos.NodeEndpoint endpoint, boolean isFinal) {
        String suffix = isFinal ? FINAL_EXECUTOR_PROFILE_SUFFIX : "";
        return ProfilesPathUtils.buildExecutorProfilePrefix(queryId) + EndpointHelper.getMinimalString(endpoint) + suffix;
    }

    public static String buildExecutorProfilePathWithEndpointAddress(UserBitShared.QueryId queryId, CoordinationProtos.NodeEndpoint endpoint, boolean isFinal) {
        String suffix = isFinal ? FINAL_EXECUTOR_PROFILE_SUFFIX : "";
        return ProfilesPathUtils.buildExecutorProfilePrefix(queryId) + endpoint.getAddress() + suffix;
    }

    public static String buildFullProfilePath(UserBitShared.QueryId queryId) {
        return ProfilesPathUtils.buildFinalPrefix(queryId) + FULL;
    }

    private static String buildFinalPrefix(UserBitShared.QueryId queryId) {
        return ProfilesPathUtils.buildProfilePrefix(queryId) + "final/";
    }
}

