/*
 * Decompiled with CFR 0.152.
 */
package com.dremio.jdbc.shaded.com.dremio.common.utils.protos;

import com.dremio.jdbc.shaded.com.google.common.hash.Hasher;
import com.dremio.jdbc.shaded.com.google.common.hash.Hashing;
import com.dremio.jdbc.shaded.io.protostuff.ByteString;
import com.dremio.jdbc.shaded.io.protostuff.Output;
import com.dremio.jdbc.shaded.io.protostuff.Schema;
import java.io.IOException;
import java.nio.ByteBuffer;

public class HasherOutput
implements Output {
    private final Hasher hasher;

    public HasherOutput(Hasher hasher) {
        this.hasher = hasher;
    }

    public HasherOutput() {
        this.hasher = Hashing.sha256().newHasher();
    }

    public void writeInt32(int fieldNumber, int value, boolean repeated) {
        this.hasher.putInt(fieldNumber);
        this.hasher.putInt(value);
    }

    public void writeUInt32(int fieldNumber, int value, boolean repeated) {
        this.hasher.putInt(fieldNumber);
        this.hasher.putInt(value);
    }

    public void writeSInt32(int fieldNumber, int value, boolean repeated) {
        this.hasher.putInt(fieldNumber);
        this.hasher.putInt(value);
    }

    public void writeFixed32(int fieldNumber, int value, boolean repeated) {
        this.hasher.putInt(fieldNumber);
        this.hasher.putInt(value);
    }

    public void writeSFixed32(int fieldNumber, int value, boolean repeated) {
        this.hasher.putInt(fieldNumber);
        this.hasher.putInt(value);
    }

    public void writeInt64(int fieldNumber, long value, boolean repeated) {
        this.hasher.putInt(fieldNumber);
        this.hasher.putLong(value);
    }

    public void writeUInt64(int fieldNumber, long value, boolean repeated) {
        this.hasher.putInt(fieldNumber);
        this.hasher.putLong(value);
    }

    public void writeSInt64(int fieldNumber, long value, boolean repeated) {
        this.hasher.putInt(fieldNumber);
        this.hasher.putLong(value);
    }

    public void writeFixed64(int fieldNumber, long value, boolean repeated) {
        this.hasher.putInt(fieldNumber);
        this.hasher.putLong(value);
    }

    public void writeSFixed64(int fieldNumber, long value, boolean repeated) {
        this.hasher.putInt(fieldNumber);
        this.hasher.putLong(value);
    }

    public void writeFloat(int fieldNumber, float value, boolean repeated) {
        this.hasher.putInt(fieldNumber);
        this.hasher.putFloat(value);
    }

    public void writeDouble(int fieldNumber, double value, boolean repeated) {
        this.hasher.putInt(fieldNumber);
        this.hasher.putDouble(value);
    }

    public void writeBool(int fieldNumber, boolean value, boolean repeated) {
        this.hasher.putInt(fieldNumber);
        this.hasher.putBoolean(value);
    }

    public void writeEnum(int fieldNumber, int value, boolean repeated) {
        this.hasher.putInt(fieldNumber);
        this.hasher.putInt(value);
    }

    public void writeString(int fieldNumber, String value, boolean repeated) {
        this.hasher.putInt(fieldNumber);
        this.hasher.putUnencodedChars(value);
    }

    public void writeBytes(int fieldNumber, ByteString value, boolean repeated) {
        this.hasher.putInt(fieldNumber);
        this.hasher.putBytes(value.asReadOnlyByteBuffer());
    }

    public void writeByteArray(int fieldNumber, byte[] value, boolean repeated) {
        this.hasher.putInt(fieldNumber);
        this.hasher.putBytes(value);
    }

    public void writeByteRange(boolean utf8String, int fieldNumber, byte[] value, int offset, int length, boolean repeated) {
        this.hasher.putInt(fieldNumber);
        this.hasher.putBytes(value, offset, length);
    }

    public <T> void writeObject(int fieldNumber, T value, Schema<T> schema, boolean repeated) throws IOException {
        this.hasher.putInt(fieldNumber);
        this.hasher.putUnencodedChars(schema.messageFullName());
        schema.writeTo((Output)this, value);
    }

    public void writeBytes(int fieldNumber, ByteBuffer value, boolean repeated) {
        this.hasher.putInt(fieldNumber);
        this.hasher.putBytes(value);
    }

    public Hasher getHasher() {
        return this.hasher;
    }
}

