/*
 * Decompiled with CFR 0.152.
 */
package com.dremio.jdbc.shaded.com.dremio.common.utils.protos;

import com.dremio.jdbc.shaded.com.dremio.common.utils.protos.AttemptId;
import com.dremio.jdbc.shaded.com.dremio.common.utils.protos.ExternalIdHelper;
import com.dremio.jdbc.shaded.com.dremio.exec.proto.ExecProtos;
import com.dremio.jdbc.shaded.com.dremio.exec.proto.UserBitShared;
import java.util.List;
import java.util.UUID;

public class QueryIdHelper {
    public static String getQueryId(UserBitShared.QueryId queryId) {
        return new UUID(queryId.getPart1(), queryId.getPart2()).toString();
    }

    public static String getJobId(UserBitShared.QueryId queryId) {
        return ExternalIdHelper.toString(AttemptId.of(queryId).getExternalId());
    }

    public static UserBitShared.QueryId getQueryIdFromString(String queryId) {
        UUID uuid = UUID.fromString(queryId);
        return UserBitShared.QueryId.newBuilder().setPart1(uuid.getMostSignificantBits()).setPart2(uuid.getLeastSignificantBits()).build();
    }

    public static String getQueryIdentifier(ExecProtos.FragmentHandle h2) {
        return QueryIdHelper.getQueryId(h2.getQueryId()) + ":" + h2.getMajorFragmentId() + ":" + h2.getMinorFragmentId();
    }

    public static String getExecutorThreadName(ExecProtos.FragmentHandle fragmentHandle) {
        return String.format("%s:frag:%s:%s", QueryIdHelper.getQueryId(fragmentHandle.getQueryId()), fragmentHandle.getMajorFragmentId(), fragmentHandle.getMinorFragmentId());
    }

    public static String getQueryIdentifiers(UserBitShared.QueryId queryId, int majorFragmentId, List<Integer> minorFragmentIds) {
        String fragmentIds = minorFragmentIds.size() == 1 ? minorFragmentIds.get(0).toString() : minorFragmentIds.toString();
        return QueryIdHelper.getQueryId(queryId) + ":" + majorFragmentId + ":" + fragmentIds;
    }

    public static String getFragmentId(ExecProtos.FragmentHandle fragmentHandle) {
        return fragmentHandle.getMajorFragmentId() + ":" + fragmentHandle.getMinorFragmentId();
    }
}

