/*
 * Decompiled with CFR 0.152.
 */
package com.dremio.jdbc.shaded.com.dremio.common.utils.protos;

import com.dremio.jdbc.shaded.com.dremio.exec.proto.UserBitShared;
import com.dremio.jdbc.shaded.com.google.common.base.Preconditions;
import com.dremio.jdbc.shaded.io.netty.buffer.ByteBuf;
import java.util.Arrays;

public class QueryWritableBatch {
    private final UserBitShared.QueryData header;
    private final ByteBuf[] buffers;

    public QueryWritableBatch(UserBitShared.QueryData header, ByteBuf ... buffers) {
        this.header = header;
        this.buffers = buffers;
        for (ByteBuf b : buffers) {
            Preconditions.checkNotNull(b);
        }
    }

    public ByteBuf[] getBuffers() {
        return this.buffers;
    }

    public long getByteCount() {
        long n = 0L;
        for (ByteBuf buf : this.buffers) {
            n += (long)buf.readableBytes();
        }
        return n;
    }

    public UserBitShared.QueryData getHeader() {
        return this.header;
    }

    public String toString() {
        return "QueryWritableBatch [header=" + String.valueOf(this.header) + ", buffers=" + Arrays.toString(this.buffers) + "]";
    }
}

