/*
 * Decompiled with CFR 0.152.
 */
package com.dremio.jdbc.shaded.com.dremio.config;

import com.dremio.jdbc.shaded.com.dremio.common.config.NestedConfig;
import com.dremio.jdbc.shaded.com.dremio.common.config.SabotConfig;
import com.dremio.jdbc.shaded.com.dremio.common.perf.Timer;
import com.dremio.jdbc.shaded.com.google.common.base.Preconditions;
import com.dremio.jdbc.shaded.com.google.common.base.Throwables;
import com.dremio.jdbc.shaded.com.google.common.collect.ImmutableSet;
import com.dremio.jdbc.shaded.com.typesafe.config.Config;
import com.dremio.jdbc.shaded.com.typesafe.config.ConfigFactory;
import com.dremio.jdbc.shaded.com.typesafe.config.ConfigParseOptions;
import com.dremio.jdbc.shaded.com.typesafe.config.ConfigValue;
import com.dremio.jdbc.shaded.com.typesafe.config.ConfigValueFactory;
import com.dremio.jdbc.shaded.org.reflections.util.ClasspathHelper;
import com.dremio.jdbc.shaded.org.slf4j.Logger;
import com.dremio.jdbc.shaded.org.slf4j.LoggerFactory;
import java.net.InetAddress;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.UnknownHostException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Map;
import java.util.Optional;
import java.util.Set;

public class DremioConfig
extends NestedConfig {
    private static final Logger logger = LoggerFactory.getLogger(DremioConfig.class);
    private static final String REFERENCE_CONFIG = "dremio-reference.conf";
    private static final String DEFAULT_USER_CONFIG = "dremio.conf";
    public static final String LOCAL_WRITE_PATH_STRING = "paths.local";
    public static final String DIST_WRITE_PATH_STRING = "paths.dist";
    public static final String CREDENTIALS_KEYSTORE_PASSWORD = "security.keystore-password";
    public static final String NODE_TAG = "services.node-tag";
    public static final String ENABLE_COORDINATOR_BOOL = "services.coordinator.enabled";
    public static final String ENABLE_MASTER_BOOL = "services.coordinator.master.enabled";
    public static final String ENABLE_EXECUTOR_BOOL = "services.executor.enabled";
    public static final String EMBEDDED_MASTER_ZK_ENABLED_BOOL = "services.coordinator.master.embedded-zookeeper.enabled";
    public static final String EMBEDDED_MASTER_ZK_ENABLED_PORT_INT = "services.coordinator.master.embedded-zookeeper.port";
    public static final String EMBEDDED_MASTER_ZK_ENABLED_PATH_STRING = "services.coordinator.master.embedded-zookeeper.path";
    public static final String EMBEDDED_MASTER_ZK_WATCHDOG_FAILURE_COUNT_THRESHOLD = "services.executor.embedded-zookeeper.watchdog.failure_count_threshold";
    public static final String EMBEDDED_MASTER_ZK_WATCHDOG_FAILURE_DURATION_THRESHOLD = "services.executor.embedded-zookeeper.watchdog.failure_duration_threshold";
    public static final String WEB_ENABLED_BOOL = "services.coordinator.web.enabled";
    public static final String WEB_AUTH_TYPE = "services.coordinator.web.auth.type";
    public static final String WEB_PORT_INT = "services.coordinator.web.port";
    public static final String WEB_TOKEN_CACHE_SIZE = "services.coordinator.web.tokens.cache.size";
    public static final String SCHEDULER_SERVICE_THREAD_COUNT = "services.coordinator.scheduler.threads";
    public static final String SCHEDULER_HALT_ON_ZK_LOST = "services.coordinator.scheduler.halt_on_zk_lost";
    public static final String SCHEDULER_LEADERLESS_CLUSTERED_SINGLETON = "services.coordinator.scheduler.leaderless.enabled";
    public static final String WEB_TOKEN_CACHE_EXPIRATION = "services.coordinator.web.tokens.cache.expiration_minutes";
    public static final String TASK_ON_IDLE_LOAD_SHED = "debug.task.on_idle_load_shed";
    public static final String TASK_RESCHEDULE_ON_UNBLOCK = "debug.task.reschedule_on_unblock";
    public static final String TASK_EAGER_LOAD_SHED = "debug.task.eager_load_shed";
    public static final String KERBEROS_PRINCIPAL = "services.kerberos.principal";
    public static final String KERBEROS_KEYTAB_PATH = "services.kerberos.keytab.file.path";
    public static final String CACHE_DB_PATH = "services.executor.cache.path.db";
    public static final String CACHE_FS_PATH_LIST = "services.executor.cache.path.fs";
    public static final String CACHE_ENABLED = "services.executor.cache.enabled";
    public static final String CACHE_DB_QUOTA = "services.executor.cache.pctquota.db";
    public static final String CACHE_FS_QUOTA_LIST = "services.executor.cache.pctquota.fs";
    public static final String CACHE_FS_ENSURE_FREE_SPACE_LIST = "services.executor.cache.ensurefreespace.fs";
    public static final String JOBS_ENABLED_BOOL = "services.jobs.enabled";
    public static final String NO_OP_CLUSTER_COORDINATOR_ENABLED = "debug.noop.cluster.coordinator.enabled";
    public static final String PLAN_CACHE_TIMEOUT_MINUTES = "dremio.plan.cache.timeout_minutes";
    public static final String PLAN_CACHE_MAX_ENTRIES = "dremio.plan.cache.max_entries";
    public static final String PLAN_CACHE_MAX_SIZE_BYTES = "dremio.plan.cache.max_bytes";
    public static final String PARTITION_STATS_CACHE_TTL = "dremio.partition.stats.cache.timeout_seconds";
    public static final String STATISTICS_CACHE_TIMEOUT_MINUTES = "dremio.statistics.cache.timeout_minutes";
    public static final String STATISTICS_CACHE_MAX_ENTRIES = "dremio.statistics.cache.max_entries";
    public static final String WEB_UI_SERVICE_CONFIG = "services.coordinator.web.ui";
    public static final String PLUGINS_ROOT_PATH_PROPERTY = "dremio.plugins.path";
    public static final String LEGACY_STORE_VIEWS_ENABLED = "legacy.dremio.store.views.enabled";
    public static final String CLIENT_PORT_INT = "services.coordinator.client-endpoint.port";
    public static final String SERVER_PORT_INT = "services.fabric.port";
    public static final String CONDUIT_PORT_INT = "services.conduit.port";
    public static final String FLIGHT_SERVICE_ENABLED_BOOLEAN = "services.flight.enabled";
    public static final String FLIGHT_SERVICE_PORT_INT = "services.flight.port";
    public static final String FLIGHT_SERVICE_AUTHENTICATION_MODE = "services.flight.auth.mode";
    public static final String FLIGHT_USE_SESSION_SERVICE = "services.flight.use_session_service";
    public static final String NESSIE_SERVICE_ENABLED_BOOLEAN = "services.nessie.enabled";
    public static final String NESSIE_SERVICE_IN_MEMORY_BOOLEAN = "services.nessie.backend.in-memory";
    public static final String NESSIE_SERVICE_REMOTE_URI = "services.nessie.remote-uri";
    public static final String NESSIE_SERVICE_LAKEHOUSE_CATALOG_URI = "services.lakehouse.catalog.nessie-uri";
    public static final String NESSIE_SERVICE_LAKEHOUSE_CATALOG_PORT = "services.lakehouse.catalog.nessie-port";
    public static final String AUTOUPGRADE = "services.coordinator.auto-upgrade";
    public static final String REGISTRATION_ADDRESS = "registration.publish-host";
    public static final String DB_PATH_STRING = "paths.db";
    public static final String ACCELERATOR_PATH_STRING = "paths.accelerator";
    public static final String DOWNLOADS_PATH_STRING = "paths.downloads";
    public static final String UPLOADS_PATH_STRING = "paths.uploads";
    public static final String RESULTS_PATH_STRING = "paths.results";
    public static final String SCRATCH_PATH_STRING = "paths.scratch";
    public static final String PROFILE_PATH_STRING = "paths.profile";
    public static final String SPILLING_PATH_STRING = "paths.spilling";
    public static final String METADATA_PATH_STRING = "paths.metadata";
    public static final String GANDIVA_CACHE_PATH_STRING = "paths.gandiva";
    public static final String SYSTEM_ICEBERG_TABLES_PATH_STRING = "paths.system_iceberg_tables";
    public static final String NODE_HISTORY_PATH_STRING = "paths.node_history";
    public static final Set<String> DEPRECATED_PATHS = ImmutableSet.of("paths.copyintoerrors");
    public static final String ZOOKEEPER_QUORUM = "zookeeper";
    public static final String ZK_CLIENT_SESSION_TIMEOUT = "zk.client.session.timeout";
    public static final String ZK_CLIENT_RETRY_UNLIMITED = "zk.client.retry.unlimited";
    public static final String ZK_CONNECTION_HANDLE_ENABLED = "zk.client.connection_handle.enabled";
    public static final String ZK_CLIENT_RETRY_LIMIT = "zk.client.retry.limit";
    public static final String ZK_CLIENT_INITIAL_TIMEOUT_MS = "zk.client.retry.initial_timeout_ms";
    public static final String ZK_SUPERVISOR_INTERVAL_MS = "zk.client.supervisor.interval_ms";
    public static final String ZK_SUPERVISOR_READ_TIMEOUT_MS = "zk.client.supervisor.read_timeout_ms";
    public static final String ZK_SUPERVISOR_MAX_FAILURES = "zk.client.supervisor.max_failures";
    public static final String YARN_ENABLED_BOOL = "provisioning.yarn.enabled";
    public static final String YARN_JVM_OPTIONS = "provisioning.yarn.jvmoptions";
    public static final String YARN_CLASSPATH = "provisioning.yarn.classpath";
    public static final String YARN_APP_CLASSPATH = "provisioning.yarn.app.classpath";
    public static final String YARN_APP_CLASSPATH_PREFIX = "provisioning.yarn.app.classpath-prefix";
    public static final String EC2_EFS_MOUNT_TARGET_IP_ADDRESS = "provisioning.ec2.efs.mountTargetIpAddress";
    public static final String MIGRATION_ENABLED = "provisioning.migration.enabled";
    public static final String NETTY_REFLECTIONS_ACCESSIBLE = "com.dremio.jdbc.shaded.io.netty.tryReflectionSetAccessible";
    public static final String DEBUG_OPTIONS = "debug";
    public static final String DEBUG_YARN_ENABLED = "debug.yarnremote.enabled";
    public static final String DEBUG_ENABLED_BOOL = "debug.enabled";
    public static final String DEBUG_PREPOPULATE_BOOL = "debug.prepopulate";
    public static final String DEBUG_AUTOPORT_BOOL = "debug.autoPort";
    public static final String DEBUG_SINGLE_NODE_BOOL = "debug.singleNode";
    public static final String DEBUG_ALLOW_TEST_APIS_BOOL = "debug.allowTestApis";
    public static final String DEBUG_USE_MEMORY_STRORAGE_BOOL = "debug.useMemoryStorage";
    public static final String DEBUG_FORCE_REMOTE_BOOL = "debug.forceRemote";
    public static final String DEBUG_ADD_DEFAULT_USER = "debug.addDefaultUser";
    public static final String DEBUG_ALLOW_NEWER_KVSTORE = "debug.allowNewerKVStore";
    public static final String DEBUG_DISABLE_MASTER_ELECTION_SERVICE_BOOL = "debug.master.election.disabled";
    public static final String DEBUG_DIST_ASYNC_ENABLED = "debug.dist.async.enabled";
    public static final String DEBUG_DIST_CACHING_ENABLED = "debug.dist.caching.enabled";
    public static final String DEBUG_DIST_MAX_CACHE_SPACE_PERCENT = "debug.dist.max.cache.space.percent";
    public static final String DEBUG_UPLOADS_ASYNC_ENABLED = "debug.uploads.async.enabled";
    public static final String DEBUG_SUPPORT_ASYNC_ENABLED = "debug.support.async.enabled";
    public static final String DEBUG_JOBS_ASYNC_ENABLED = "debug.results.async.enabled";
    public static final String DEBUG_SCRATCH_ASYNC_ENABLED = "debug.scratch.async.enabled";
    public static final String DEBUG_PROFILE_ASYNC_ENABLED = "debug.profile.async.enabled";
    public static final String DEBUG_DOWNLOAD_ASYNC_ENABLED = "debug.download.async.enabled";
    public static final String DEBUG_METADATA_ASYNC_ENABLED = "debug.metadata.async.enabled";
    public static final String DEBUG_LOGS_ASYNC_ENABLED = "debug.logs.async.enabled";
    public static final String DEBUG_GANDIVA_CACHE_ASYNC_ENABLED = "debug.gandiva_cache.async.enabled";
    public static final String DEBUG_DIST_S3_FILE_STATUS_CHECK = "debug.dist.s3_file_status_check.enabled";
    public static final String DEBUG_SYSTEM_ICEBERG_TABLES_STORAGE_ASYNC_ENABLED = "debug.system_iceberg_tables.async.enabled";
    public static final String FABRIC_MEMORY_RESERVATION = "services.fabric.memory.reservation";
    public static final String SSL_ENABLED = "enabled";
    public static final String SSL_KEY_STORE_TYPE = "keyStoreType";
    public static final String SSL_KEY_STORE_PATH = "keyStore";
    public static final String SSL_KEY_STORE_PASSWORD = "keyStorePassword";
    public static final String SSL_KEY_PASSWORD = "keyPassword";
    public static final String SSL_TRUST_STORE_TYPE = "trustStoreType";
    public static final String SSL_TRUST_STORE_PATH = "trustStore";
    public static final String SSL_TRUST_STORE_PASSWORD = "trustStorePassword";
    public static final String SSL_DISABLE_HOST_VERIFICATION = "disableHostVerification";
    public static final String SSL_AUTO_GENERATED_CERTIFICATE = "auto-certificate.enabled";
    public static final String WEB_SSL_PREFIX = "services.coordinator.web.ssl.";
    public static final String DATASTORE_TYPE = "services.datastore.type";
    public static final String DATASTORE_CONFIG = "services.datastore.config";
    public static final String LIVENESS_ENABLED = "services.web-admin.enabled";
    public static final String LIVENESS_PORT = "services.web-admin.port";
    public static final String LIVENESS_HOST = "services.web-admin.host";
    public static final String POLL_TIMEOUT_MS = "provisioning.yarn.watchdog.poll.timeout";
    public static final String POLL_INTERVAL_MS = "provisioning.yarn.watchdog.poll.interval";
    public static final String MISSED_POLLS_BEFORE_KILL = "provisioning.yarn.watchdog.missed.polls.before.kill";
    public static final String MAX_KILL_ATTEMPTS = "provisioning.yarn.watchdog.max.kill.attempts";
    public static final String KILL_REATTEMPT_INTERVAL_MS = "provisioning.yarn.watchdog.kill.reattempt.interval";
    public static final String YARN_CERTIFICATE_VALIDATION_ENABLED = "provisioning.yarn.nodemanager.certificate-validation.enabled";
    public static final String REMOTE_DATASTORE_RPC_TIMEOUT_SECS = "debug.remote.datastore.rpc_timeout_seconds";
    public static final String PERMISSION_LOCAL_USERS_CREATE_ENABLED = "services.coordinator.security.permission.local-users.create.enabled";
    public static final String DREMIO_TUNING_GRPC_IDLE_TIMEOUT_SECONDS = "dremio.tuning.grpc.idle-timeout-seconds";
    public static final String DREMIO_TERMINATION_GRACE_PERIOD_SECONDS = "dremio.termination_grace_period_seconds";
    private final Config unresolved;
    private final Config reference;
    private final SabotConfig sabot;
    private final String thisNode;
    private final boolean isMasterlessEnabled;

    private DremioConfig(SabotConfig sabot, Config unresolved, Config reference, String thisNode) {
        super(DremioConfig.inverseMerge(unresolved, reference));
        this.unresolved = unresolved;
        this.reference = reference;
        this.sabot = sabot;
        this.thisNode = thisNode;
        this.isMasterlessEnabled = Boolean.getBoolean("dremio_masterless");
        this.check();
    }

    private void check() {
        Config resolvedReference = this.reference.resolve();
        this.getInnerConfig().checkValid(resolvedReference, new String[0]);
        this.checkForInvalidPaths(resolvedReference);
        this.checkForMisconfiguredDistStore();
    }

    private void checkForInvalidPaths(Config resolvedReference) {
        ArrayList<String> invalidPaths = new ArrayList<String>();
        for (Map.Entry<String, ConfigValue> entry : this.getInnerConfig().entrySet()) {
            if (DEPRECATED_PATHS.contains(entry.getKey())) {
                logger.warn("Property [{}] is deprecated. Please remove it from the conf file [dremio.conf].", (Object)entry.getKey());
                continue;
            }
            if (resolvedReference.hasPath(entry.getKey())) continue;
            invalidPaths.add(entry.getKey());
        }
        if (!invalidPaths.isEmpty()) {
            StringBuilder sb = new StringBuilder();
            sb.append("Failure reading configuration file. The following properties were invalid:\n");
            for (String s2 : invalidPaths) {
                sb.append("\t");
                sb.append(s2);
                sb.append("\n");
            }
            throw new RuntimeException(sb.toString());
        }
    }

    private void checkForMisconfiguredDistStore() {
        String distStorePath = this.getString(DIST_WRITE_PATH_STRING);
        if (distStorePath.startsWith("pdfs://")) {
            logger.warn("PDFS is not supported as a distributed store for Dremio Software.");
            return;
        }
        if (this.getBoolean(ENABLE_COORDINATOR_BOOL) && this.getBoolean(ENABLE_MASTER_BOOL) && this.getBoolean(ENABLE_EXECUTOR_BOOL)) {
            return;
        }
        String localStorePrefix = "file://" + this.getString(LOCAL_WRITE_PATH_STRING);
        if (distStorePath.startsWith(localStorePrefix)) {
            logger.warn("The distributed store cannot be a local path - update the paths.dist property.");
        }
    }

    private static String determineNode() {
        Timer.TimedBlock bh = Timer.time("getCanonicalHostName");
        try {
            String string = InetAddress.getLocalHost().getCanonicalHostName();
            if (bh != null) {
                bh.close();
            }
            return string;
        }
        catch (Throwable throwable) {
            try {
                if (bh != null) {
                    try {
                        bh.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                throw throwable;
            }
            catch (UnknownHostException ex) {
                throw new RuntimeException("Failure retrieving hostname from node. Check hosts file.", ex);
            }
        }
    }

    @Override
    public DremioConfig withValue(String path, ConfigValue value) {
        return new DremioConfig(this.sabot, this.unresolved.withValue(path, value), this.reference, this.thisNode);
    }

    public DremioConfig withSabotValue(String path, ConfigValue value) {
        return new DremioConfig(this.sabot.withValue(path, value), this.unresolved, this.reference, this.thisNode);
    }

    public DremioConfig withSabotValue(String path, Object value) {
        return this.withSabotValue(path, ConfigValueFactory.fromAnyRef(value));
    }

    public SabotConfig getSabotConfig() {
        return this.sabot;
    }

    public boolean isMasterlessEnabled() {
        return this.isMasterlessEnabled;
    }

    private static Config inverseMerge(Config userConfig, Config fallback) {
        return userConfig.withFallback(fallback).resolve();
    }

    public DremioConfig withValue(String path, Object value) {
        return this.withValue(path, ConfigValueFactory.fromAnyRef(value));
    }

    public URI getURI(String path) {
        try {
            return new URI(this.getString(path));
        }
        catch (URISyntaxException e) {
            throw Throwables.propagate(e);
        }
    }

    public static DremioConfig create() {
        return DremioConfig.create(null);
    }

    public static DremioConfig create(URL userConfigPath) {
        return DremioConfig.create(userConfigPath, SabotConfig.create());
    }

    public static DremioConfig create(URL userConfigPath, SabotConfig sabotConfig) {
        ClassLoader[] classLoaders;
        Config reference = null;
        for (ClassLoader classLoader : classLoaders = ClasspathHelper.classLoaders(new ClassLoader[0])) {
            URL configUrl = classLoader.getResource(REFERENCE_CONFIG);
            if (configUrl == null) continue;
            Preconditions.checkArgument(reference == null, "Attempted to load more than one reference configuration.");
            reference = ConfigFactory.parseResources(classLoader, REFERENCE_CONFIG);
        }
        Preconditions.checkNotNull(reference, "Unable to find the reference configuration.");
        Config userConfig = null;
        if (userConfigPath == null) {
            for (ClassLoader classLoader : classLoaders) {
                URL configUrl = classLoader.getResource(DEFAULT_USER_CONFIG);
                if (configUrl == null) continue;
                Preconditions.checkArgument(userConfig == null, "Attempted to load more than one user configuration.");
                userConfig = ConfigFactory.parseResources(classLoader, DEFAULT_USER_CONFIG);
            }
        } else {
            userConfig = ConfigFactory.parseURL(userConfigPath, ConfigParseOptions.defaults().setAllowMissing(false));
        }
        Config effective = userConfig != null ? userConfig : reference;
        Config skinned = DremioConfig.applySystemProperties(DremioConfig.applyLegacySystemProperties(effective), reference);
        return new DremioConfig(sabotConfig, skinned, reference, DremioConfig.determineNode());
    }

    private static Config setSystemProperty(Config config, String sysProp, String configProp) {
        String systemProperty = System.getProperty(sysProp);
        if (systemProperty != null) {
            config = config.withValue(configProp, ConfigValueFactory.fromAnyRef(systemProperty));
            logger.info("Applying provided leagcy system property to config: -D{}={}", (Object)configProp, (Object)systemProperty);
        }
        return config;
    }

    @Deprecated
    private static Config applyLegacySystemProperties(Config config) {
        config = DremioConfig.setSystemProperty(config, "dremd.write", LOCAL_WRITE_PATH_STRING);
        config = DremioConfig.setSystemProperty(config, "dremio_autoPort", DEBUG_AUTOPORT_BOOL);
        config = DremioConfig.setSystemProperty(config, "dac_prepopulate", DEBUG_PREPOPULATE_BOOL);
        config = DremioConfig.setSystemProperty(config, "dremio_allowTestApis", DEBUG_ALLOW_TEST_APIS_BOOL);
        config = DremioConfig.setSystemProperty(config, "dremd.localPort", SERVER_PORT_INT);
        config = DremioConfig.setSystemProperty(config, "dremd.httpPort", WEB_PORT_INT);
        if ("LOCAL".equalsIgnoreCase(System.getProperty("dremd.mode"))) {
            config = config.withValue(DEBUG_SINGLE_NODE_BOOL, ConfigValueFactory.fromAnyRef(true));
            logger.info("Applying provided leagcy system property to config: -Ddremd.mode=LOCAL");
        }
        return config;
    }

    public String getThisNode() {
        return this.thisNode;
    }

    private static Config applySystemProperties(Config config, Config reference) {
        for (Map.Entry<String, ConfigValue> entry : reference.entrySet()) {
            String property = System.getProperty(entry.getKey());
            if (property == null || property.isEmpty()) continue;
            if (property.startsWith("[") && property.endsWith("]")) {
                if ((property = property.substring(1, property.length() - 1)).trim().isEmpty()) continue;
                String[] strings = property.split(",");
                if (strings != null && strings.length > 0) {
                    ArrayList<String> listStrings = new ArrayList<String>();
                    for (String str : strings) {
                        listStrings.add(str.trim());
                    }
                    config = config.withValue(entry.getKey(), ConfigValueFactory.fromAnyRef(listStrings));
                }
            } else {
                config = config.withValue(entry.getKey(), ConfigValueFactory.fromAnyRef(property));
            }
            logger.info("Applying provided system property to config: -D{}={}", (Object)entry.getKey(), (Object)property);
        }
        return config;
    }

    public static Path getPluginsRootPath() {
        String pluginsDir = System.getProperty(PLUGINS_ROOT_PATH_PROPERTY);
        if (pluginsDir != null) {
            return Paths.get(pluginsDir, new String[0]);
        }
        logger.debug("The system property {} is not set", (Object)PLUGINS_ROOT_PATH_PROPERTY);
        return Optional.ofNullable(System.getenv("DREMIO_HOME")).map(v -> Paths.get(v, "plugins")).orElseGet(() -> {
            logger.debug("The environment variable DREMIO_HOME is not set.");
            return Paths.get(".", new String[0]);
        });
    }
}

