/*
 * Decompiled with CFR 0.152.
 */
package com.dremio.jdbc.shaded.com.dremio.context;

import com.dremio.jdbc.shaded.com.dremio.context.LocalValues;
import com.dremio.jdbc.shaded.com.google.common.base.Preconditions;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicInteger;

public class LocalValue<T> {
    private static final ThreadLocal<LocalValuesImpl> VALUES = new ThreadLocal();
    private static final AtomicInteger SIZE = new AtomicInteger();
    private final int index = SIZE.getAndIncrement();

    public Optional<T> get() {
        LocalValuesImpl values = VALUES.get();
        if (values == null || values.size() <= this.index) {
            return Optional.empty();
        }
        return Optional.ofNullable(values.get(this.index));
    }

    public void set(T value) {
        Preconditions.checkNotNull(value, "LocalValue cannot be set to null");
        this.doSet(value);
    }

    private void doSet(T value) {
        LocalValuesImpl values = LocalValue.doSave();
        LocalValuesImpl newValues = values.set(this.index, value);
        VALUES.set(newValues);
    }

    public void clear() {
        this.doSet(null);
    }

    public static LocalValues save() {
        return LocalValue.doSave();
    }

    private static LocalValuesImpl doSave() {
        return Optional.ofNullable(VALUES.get()).orElseGet(() -> new LocalValuesImpl(SIZE.get()));
    }

    public static void restore(LocalValues localValues) {
        Preconditions.checkNotNull(localValues, "Cannot restore a null value");
        VALUES.set((LocalValuesImpl)localValues);
    }

    protected static final class LocalValuesImpl
    implements LocalValues {
        private final Object[] values;

        private LocalValuesImpl(int size) {
            this.values = new Object[size];
        }

        public LocalValuesImpl(Object[] values) {
            this.values = values;
        }

        public Object get(int index) {
            return this.values[index];
        }

        public Object[] get() {
            return this.values;
        }

        public int size() {
            return this.values.length;
        }

        private LocalValuesImpl set(int index, Object value) {
            int size = SIZE.get();
            Preconditions.checkArgument(index < size, "index out of bounds");
            if (index < this.values.length && this.values[index] == value) {
                return this;
            }
            Object[] newValues = new Object[size];
            System.arraycopy(this.values, 0, newValues, 0, this.values.length);
            newValues[index] = value;
            return new LocalValuesImpl(newValues);
        }
    }
}

