/*
 * Decompiled with CFR 0.152.
 */
package com.dremio.jdbc.shaded.com.dremio.context;

import com.dremio.jdbc.shaded.com.dremio.context.RequestContext;
import com.dremio.jdbc.shaded.org.apache.commons.lang3.ClassUtils;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.Collection;
import java.util.stream.Stream;

public final class RequestContextWrapper<T>
implements InvocationHandler {
    private final RequestContext requestContext;
    private final T baseObj;

    private RequestContextWrapper(RequestContext requestContext, T baseObj) {
        this.requestContext = requestContext;
        this.baseObj = baseObj;
    }

    @Override
    public Object invoke(Object proxyObj, Method method, Object[] args) throws Throwable {
        try {
            Object returnedObj;
            Class<?> methodReturnType = method.getReturnType();
            Object object = returnedObj = Stream.class.equals(method.getReturnType()) ? this.requestContext.callStream(() -> (Stream)method.invoke(this.baseObj, args)) : this.requestContext.call(() -> method.invoke(this.baseObj, args));
            if (returnedObj != null) {
                Class<?> returnType = returnedObj.getClass();
                if (Void.class.equals(returnType) || returnType.isPrimitive() || returnType.isArray() || Collection.class.isAssignableFrom(returnType) || proxyObj == returnedObj) {
                    return returnedObj;
                }
                if ((returnType = ClassUtils.getAllInterfaces(returnType).stream().filter(intfc -> methodReturnType.isAssignableFrom((Class<?>)intfc)).findAny().orElse(returnType)).isInterface()) {
                    returnedObj = RequestContextWrapper.wrapWithContext(this.requestContext, returnedObj, returnType);
                }
            }
            return returnedObj;
        }
        catch (InvocationTargetException e) {
            throw e.getCause();
        }
    }

    public static <T> T wrapWithContext(RequestContext context, T baseObject, Class<?> interfaceType) {
        RequestContextWrapper<T> handler = new RequestContextWrapper<T>(context, baseObject);
        return (T)Proxy.newProxyInstance(interfaceType.getClassLoader(), new Class[]{interfaceType}, handler);
    }
}

