/*
 * Decompiled with CFR 0.152.
 */
package com.dremio.jdbc.shaded.com.dremio.context;

import com.dremio.jdbc.shaded.com.dremio.context.RequestContext;
import com.dremio.jdbc.shaded.com.dremio.context.SerializableContext;
import com.dremio.jdbc.shaded.com.dremio.context.SerializableContextTransformer;
import com.dremio.jdbc.shaded.com.dremio.context.UserContext;
import com.dremio.jdbc.shaded.com.google.common.collect.ImmutableMap;
import java.util.Arrays;
import java.util.Map;

public class SupportContext
implements SerializableContext {
    public static final RequestContext.Key<SupportContext> CTX_KEY = RequestContext.newKey("support_ctx_key");
    private static final String ROLES_DELIMITER = ",";
    private static final String SUPPORT_TICKET_HEADER_KEY = "x-dremio-support-ticket-key";
    private static final String SUPPORT_EMAIL_HEADER_KEY = "x-dremio-support-email-key";
    private static final String SUPPORT_ROLES_HEADER_KEY = "x-dremio-support-roles-key";
    public static final String SUPPORT_USER_ID = "$Dremio-Support-Super-Admin-User$";
    public static final String SUPPORT_USER_NAME = "support@dremio.com";
    private final String ticket;
    private final String email;
    private final String[] roles;

    public SupportContext(String ticket, String email, String[] roles) {
        this.ticket = ticket;
        this.email = email;
        this.roles = Arrays.copyOf(roles, roles.length);
    }

    public String getTicket() {
        return this.ticket;
    }

    public String getEmail() {
        return this.email;
    }

    public String[] getRoles() {
        return Arrays.copyOf(this.roles, this.roles.length);
    }

    public static boolean isSupportUserWithBasicSupportRole() {
        return SupportContext.isSupportUser() && SupportContext.isSupportUserHasRole(SupportRole.BASIC_SUPPORT_ROLE);
    }

    public static boolean isSupportUserWithSupportKeyManagementRole() {
        return SupportContext.isSupportUser() && SupportContext.isSupportUserHasRole(SupportRole.SUPPORT_KEY_MANAGEMENT_ROLE);
    }

    public static boolean isSupportUserWithBillingRole() {
        return SupportContext.isSupportUser() && SupportContext.isSupportUserHasRole(SupportRole.BILLING_ROLE);
    }

    public static boolean isSupportUserWithOrgDeleteRole() {
        return SupportContext.isSupportUser() && SupportContext.isSupportUserHasRole(SupportRole.ORG_DELETE_ROLE);
    }

    public static boolean isSupportUserWithConsistencyFixerRole() {
        return SupportContext.isSupportUser() && SupportContext.isSupportUserHasRole(SupportRole.CONSISTENCY_FIXER_ROLE);
    }

    public static boolean isSupportUserWithDebugRole() {
        return SupportContext.isSupportUser() && SupportContext.isSupportUserHasRole(SupportRole.DEBUG_ROLE);
    }

    public static boolean doesSupportUserHaveRole(SupportContext supportContext, SupportRole role) {
        return supportContext.roles.length > 0 && Arrays.stream(supportContext.roles).anyMatch(r -> r.equals(role.value));
    }

    public static boolean isSupportUser() {
        return RequestContext.current().get(CTX_KEY) != null && RequestContext.current().get(UserContext.CTX_KEY) != null && SUPPORT_USER_ID.equals(RequestContext.current().get(UserContext.CTX_KEY).getUserId());
    }

    public static boolean isSupportUserHasRole(SupportRole role) {
        return SupportContext.doesSupportUserHaveRole(RequestContext.current().get(CTX_KEY), role);
    }

    @Override
    public void serialize(ImmutableMap.Builder<String, String> builder) {
        builder.put(SUPPORT_TICKET_HEADER_KEY, this.ticket);
        builder.put(SUPPORT_EMAIL_HEADER_KEY, this.email);
        builder.put(SUPPORT_ROLES_HEADER_KEY, SupportContext.serializeSupportRoles(this.roles));
    }

    private static String serializeSupportRoles(String[] rolesArr) {
        return rolesArr != null ? String.join((CharSequence)ROLES_DELIMITER, rolesArr) : "";
    }

    private static String[] deserializeSupportRoles(String rolesStr) {
        return rolesStr != null ? rolesStr.split(ROLES_DELIMITER) : new String[]{};
    }

    public static enum SupportRole {
        BASIC_SUPPORT_ROLE("basic-support"),
        BILLING_ROLE("billing"),
        ORG_DELETE_ROLE("org-delete"),
        CONSISTENCY_FIXER_ROLE("consistency-fixer"),
        DEBUG_ROLE("debug-role"),
        SUPPORT_KEY_MANAGEMENT_ROLE("support-key-management"),
        SECRET_ROTATION_ROLE("secret-rotation");

        private final String value;

        private SupportRole(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public static SupportRole fromValue(String value) {
            for (SupportRole role : SupportRole.values()) {
                if (!role.value.equals(value)) continue;
                return role;
            }
            return null;
        }
    }

    public static class Transformer
    implements SerializableContextTransformer {
        @Override
        public RequestContext deserialize(Map<String, String> headers, RequestContext builder) {
            if (headers.containsKey(SupportContext.SUPPORT_TICKET_HEADER_KEY) && headers.containsKey(SupportContext.SUPPORT_EMAIL_HEADER_KEY) && headers.containsKey(SupportContext.SUPPORT_ROLES_HEADER_KEY)) {
                return builder.with(CTX_KEY, new SupportContext(headers.get(SupportContext.SUPPORT_TICKET_HEADER_KEY), headers.get(SupportContext.SUPPORT_EMAIL_HEADER_KEY), SupportContext.deserializeSupportRoles(headers.get(SupportContext.SUPPORT_ROLES_HEADER_KEY))));
            }
            return builder;
        }
    }
}

