/*
 * Decompiled with CFR 0.152.
 */
package com.dremio.jdbc.shaded.com.dremio.context;

import com.dremio.jdbc.shaded.com.dremio.context.RequestContext;
import com.dremio.jdbc.shaded.com.dremio.context.SerializableContext;
import com.dremio.jdbc.shaded.com.dremio.context.SerializableContextTransformer;
import com.dremio.jdbc.shaded.com.google.common.base.Preconditions;
import com.dremio.jdbc.shaded.com.google.common.collect.ImmutableMap;
import com.dremio.jdbc.shaded.io.grpc.Metadata;
import com.dremio.jdbc.shaded.org.jetbrains.annotations.NotNull;
import java.util.Map;
import java.util.UUID;

public class TenantContext
implements SerializableContext {
    public static final RequestContext.Key<TenantContext> CTX_KEY = RequestContext.newKey("tenant_ctx_key");
    public static final String DEFAULT_PRODUCT_PROJECT_ID = "77a89f85-c936-4f42-ab21-2ee90e9609b8";
    public static final String DEFAULT_SERVICE_PROJECT_ID = "77a89f85-c936-4f42-ab21-2ee90e9609b9";
    public static final String DEFAULT_SERVICE_ORG_ID = "77a89f85-c936-4f42-ab21-2ee90e96099b";
    public static final TenantContext DEFAULT_SERVICE_CONTEXT = new TenantContext("77a89f85-c936-4f42-ab21-2ee90e9609b9", "77a89f85-c936-4f42-ab21-2ee90e96099b");
    public static final Metadata.Key<String> PROJECT_ID_HEADER_KEY = Metadata.Key.of((String)"x-dremio-project-id-key", (Metadata.AsciiMarshaller)Metadata.ASCII_STRING_MARSHALLER);
    public static final Metadata.Key<String> ORG_ID_HEADER_KEY = Metadata.Key.of((String)"x-dremio-org-id-key", (Metadata.AsciiMarshaller)Metadata.ASCII_STRING_MARSHALLER);
    private final UUID projectId;
    private final UUID orgId;

    public TenantContext(String projectId, String orgId) {
        this.projectId = UUID.fromString(projectId);
        this.orgId = UUID.fromString(orgId);
    }

    public TenantContext(@NotNull UUID projectId, @NotNull UUID orgId) {
        Preconditions.checkNotNull(projectId, "projectId should not be null");
        Preconditions.checkNotNull(orgId, "orgId should not be null");
        this.projectId = projectId;
        this.orgId = orgId;
    }

    public UUID getProjectId() {
        return this.projectId;
    }

    public UUID getOrgId() {
        return this.orgId;
    }

    @Override
    public void serialize(ImmutableMap.Builder<String, String> builder) {
        builder.put(PROJECT_ID_HEADER_KEY.name(), this.projectId.toString());
        builder.put(ORG_ID_HEADER_KEY.name(), this.orgId.toString());
    }

    public static class Transformer
    implements SerializableContextTransformer {
        @Override
        public RequestContext deserialize(Map<String, String> headers, RequestContext builder) {
            if (headers.containsKey(PROJECT_ID_HEADER_KEY.name()) && headers.containsKey(ORG_ID_HEADER_KEY.name())) {
                return builder.with(CTX_KEY, new TenantContext(headers.get(PROJECT_ID_HEADER_KEY.name()), headers.get(ORG_ID_HEADER_KEY.name())));
            }
            return builder;
        }
    }
}

