/*
 * Decompiled with CFR 0.152.
 */
package com.dremio.jdbc.shaded.com.dremio.context;

import com.dremio.jdbc.shaded.com.dremio.context.RequestContext;
import com.dremio.jdbc.shaded.com.dremio.context.SerializableContext;
import com.dremio.jdbc.shaded.com.dremio.context.SerializableContextTransformer;
import com.dremio.jdbc.shaded.com.google.common.collect.ImmutableMap;
import java.util.Map;

public final class UserContext
implements SerializableContext {
    public static final String DEFAULT_SERVICE_CONTEXT_ID = "77a89f85-c936-4f42-ab21-2ee90e9609b8";
    public static final String SYSTEM_USER_CONTEXT_ID = "678cc92c-01ed-4db3-9a28-d1f871042d9f";
    public static final RequestContext.Key<UserContext> CTX_KEY = RequestContext.newKey("user_ctx_key");
    public static final UserContext DEFAULT_SERVICE_CONTEXT = UserContext.of("77a89f85-c936-4f42-ab21-2ee90e9609b8");
    public static final UserContext SYSTEM_USER_CONTEXT = UserContext.of("678cc92c-01ed-4db3-9a28-d1f871042d9f");
    public static final String SYSTEM_USER_NAME = "$dremio$";
    public static final String USER_HEADER_KEY = "x-dremio-user-key";
    private final String userId;

    private UserContext(String userId) {
        this.userId = userId;
    }

    public static UserContext of(String userId) {
        return "1".equals(userId) ? SYSTEM_USER_CONTEXT : new UserContext(userId);
    }

    public String getUserId() {
        return this.userId;
    }

    public static boolean isSystemUser() {
        return RequestContext.current().get(CTX_KEY) != null && SYSTEM_USER_CONTEXT.getUserId().equals(RequestContext.current().get(CTX_KEY).getUserId());
    }

    @Override
    public void serialize(ImmutableMap.Builder<String, String> builder) {
        builder.put(USER_HEADER_KEY, this.userId);
    }

    public static class Transformer
    implements SerializableContextTransformer {
        @Override
        public RequestContext deserialize(Map<String, String> headers, RequestContext builder) {
            if (headers.containsKey(UserContext.USER_HEADER_KEY)) {
                return builder.with(CTX_KEY, UserContext.of(headers.get(UserContext.USER_HEADER_KEY)));
            }
            return builder;
        }
    }
}

