/*
 * Decompiled with CFR 0.152.
 */
package com.dremio.jdbc.shaded.com.dremio.exec.client;

import com.dremio.jdbc.shaded.com.dremio.common.AutoCloseables;
import com.dremio.jdbc.shaded.com.dremio.common.Version;
import com.dremio.jdbc.shaded.com.dremio.common.concurrent.NamedThreadFactory;
import com.dremio.jdbc.shaded.com.dremio.common.config.SabotConfig;
import com.dremio.jdbc.shaded.com.dremio.common.exceptions.UserException;
import com.dremio.jdbc.shaded.com.dremio.common.util.concurrent.DremioFutures;
import com.dremio.jdbc.shaded.com.dremio.common.utils.protos.QueryIdHelper;
import com.dremio.jdbc.shaded.com.dremio.exec.client.ServerMethod;
import com.dremio.jdbc.shaded.com.dremio.exec.proto.CoordExecRPC;
import com.dremio.jdbc.shaded.com.dremio.exec.proto.CoordinationProtos;
import com.dremio.jdbc.shaded.com.dremio.exec.proto.GeneralRPCProtos;
import com.dremio.jdbc.shaded.com.dremio.exec.proto.UserBitShared;
import com.dremio.jdbc.shaded.com.dremio.exec.proto.UserProtos;
import com.dremio.jdbc.shaded.com.dremio.exec.rpc.BasicClientWithConnection;
import com.dremio.jdbc.shaded.com.dremio.exec.rpc.ChannelClosedException;
import com.dremio.jdbc.shaded.com.dremio.exec.rpc.ConnectionFailedException;
import com.dremio.jdbc.shaded.com.dremio.exec.rpc.ConnectionThrottle;
import com.dremio.jdbc.shaded.com.dremio.exec.rpc.RpcConnectionHandler;
import com.dremio.jdbc.shaded.com.dremio.exec.rpc.RpcException;
import com.dremio.jdbc.shaded.com.dremio.exec.rpc.RpcFuture;
import com.dremio.jdbc.shaded.com.dremio.exec.rpc.TransportCheck;
import com.dremio.jdbc.shaded.com.dremio.exec.rpc.proxy.ProxyConfig;
import com.dremio.jdbc.shaded.com.dremio.sabot.rpc.user.QueryDataBatch;
import com.dremio.jdbc.shaded.com.dremio.sabot.rpc.user.UserClient;
import com.dremio.jdbc.shaded.com.dremio.sabot.rpc.user.UserResultsListener;
import com.dremio.jdbc.shaded.com.dremio.sabot.rpc.user.UserRpcUtils;
import com.dremio.jdbc.shaded.com.dremio.service.coordinator.ClusterCoordinator;
import com.dremio.jdbc.shaded.com.dremio.service.coordinator.DistributedSemaphore;
import com.dremio.jdbc.shaded.com.dremio.service.coordinator.ElectionListener;
import com.dremio.jdbc.shaded.com.dremio.service.coordinator.ElectionRegistrationHandle;
import com.dremio.jdbc.shaded.com.dremio.service.coordinator.LinearizableHierarchicalStore;
import com.dremio.jdbc.shaded.com.dremio.service.coordinator.ServiceSet;
import com.dremio.jdbc.shaded.com.dremio.service.coordinator.zk.ZKClusterCoordinator;
import com.dremio.jdbc.shaded.com.dremio.ssl.SSLConfig;
import com.dremio.jdbc.shaded.com.google.common.annotations.VisibleForTesting;
import com.dremio.jdbc.shaded.com.google.common.base.Preconditions;
import com.dremio.jdbc.shaded.com.google.common.collect.ImmutableSet;
import com.dremio.jdbc.shaded.com.google.common.util.concurrent.ForwardingListenableFuture;
import com.dremio.jdbc.shaded.com.google.common.util.concurrent.SettableFuture;
import com.dremio.jdbc.shaded.io.netty.buffer.ByteBuf;
import com.dremio.jdbc.shaded.io.netty.channel.EventLoopGroup;
import com.dremio.jdbc.shaded.org.apache.arrow.memory.BufferAllocator;
import com.dremio.jdbc.shaded.org.apache.arrow.memory.OutOfMemoryException;
import com.dremio.jdbc.shaded.org.apache.arrow.memory.RootAllocatorFactory;
import com.dremio.jdbc.shaded.org.slf4j.Logger;
import com.dremio.jdbc.shaded.org.slf4j.LoggerFactory;
import java.io.Closeable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Properties;
import java.util.Set;
import java.util.Vector;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

public class DremioClient
implements Closeable,
ConnectionThrottle {
    private static final Logger logger = LoggerFactory.getLogger(DremioClient.class);
    public static final String INITIAL_USER_PORT = "dremio.exec.rpc.user.server.port";
    public static final String CLIENT_RPC_THREADS = "dremio.client.threads";
    public static final String BIT_RETRY_TIMES = "dremio.client.retry.count";
    public static final String BIT_RETRY_DELAY = "dremio.client.retry.delay";
    public static final String CLIENT_SUPPORT_COMPLEX_TYPES = "dremio.client.supports-complex-types";
    private static final ImmutableSet<String> CLIENT_ONLY_PROPERTIES = ((ImmutableSet.Builder)((ImmutableSet.Builder)((ImmutableSet.Builder)((ImmutableSet.Builder)((ImmutableSet.Builder)((ImmutableSet.Builder)((ImmutableSet.Builder)((ImmutableSet.Builder)((ImmutableSet.Builder)((ImmutableSet.Builder)((ImmutableSet.Builder)ImmutableSet.builder().add("trustStorePassword".toLowerCase(Locale.ROOT))).add("trustStore".toLowerCase(Locale.ROOT))).add("trustStoreType".toLowerCase(Locale.ROOT))).add("disableCertificateVerification".toLowerCase(Locale.ROOT))).add("disableHostVerification".toLowerCase(Locale.ROOT))).add("ssl".toLowerCase(Locale.ROOT))).add("useSystemTrustStore".toLowerCase(Locale.ROOT))).add("socksProxyHost".toLowerCase(Locale.ROOT))).add(ProxyConfig.SOCKS_PROXY_PORT.toLowerCase(Locale.ROOT))).add(ProxyConfig.SOCKS_PROXY_USERNAME.toLowerCase(Locale.ROOT))).add(ProxyConfig.SOCKS_PROXY_PASSWORD.toLowerCase(Locale.ROOT))).build();
    public static final String DEFAULT_CLIENT_NAME = "Dremio Java client";
    private final SabotConfig config;
    private UserClient client;
    private UserProtos.UserProperties props = null;
    private volatile ClusterCoordinator clusterCoordinator;
    private volatile boolean connected = false;
    private final BufferAllocator rootAllocator;
    private final BufferAllocator connectionAllocator;
    private final BufferAllocator recordAllocator;
    private int reconnectTimes;
    private int reconnectDelay;
    private boolean supportComplexTypes;
    private final boolean ownsAllocator;
    private final boolean isDirectConnection;
    private EventLoopGroup eventLoopGroup;
    private ExecutorService executor;
    private String clientName = "Dremio Java client";

    public DremioClient() throws OutOfMemoryException {
        this(SabotConfig.create(), false);
    }

    public DremioClient(boolean isDirect) throws OutOfMemoryException {
        this(SabotConfig.create(), isDirect);
    }

    public DremioClient(String fileName) throws OutOfMemoryException {
        this(SabotConfig.create(fileName), false);
    }

    public DremioClient(SabotConfig config) throws OutOfMemoryException {
        this(config, null, false);
    }

    public DremioClient(SabotConfig config, boolean isDirect) throws OutOfMemoryException {
        this(config, null, isDirect);
    }

    public DremioClient(SabotConfig config, ClusterCoordinator coordinator) throws OutOfMemoryException {
        this(config, coordinator, null, false);
    }

    public DremioClient(SabotConfig config, ClusterCoordinator coordinator, boolean isDirect) throws OutOfMemoryException {
        this(config, coordinator, null, isDirect);
    }

    public DremioClient(SabotConfig config, ClusterCoordinator coordinator, BufferAllocator allocator) throws OutOfMemoryException {
        this(config, coordinator, allocator, false);
    }

    public DremioClient(SabotConfig config, ClusterCoordinator clusterCoordinator, BufferAllocator allocator, boolean isDirect) {
        this.isDirectConnection = isDirect;
        this.ownsAllocator = allocator == null;
        this.rootAllocator = this.ownsAllocator ? RootAllocatorFactory.newRoot(config) : allocator;
        this.connectionAllocator = this.rootAllocator.newChildAllocator("dremio-client-connections", 0L, this.rootAllocator.getLimit());
        this.recordAllocator = this.rootAllocator.newChildAllocator("dremio-client-records", 0L, this.rootAllocator.getLimit());
        this.config = config;
        this.clusterCoordinator = ClusterCoordinatorWrapper.of(clusterCoordinator);
        this.reconnectTimes = config.getInt(BIT_RETRY_TIMES);
        this.reconnectDelay = config.getInt(BIT_RETRY_DELAY);
        this.supportComplexTypes = config.getBoolean(CLIENT_SUPPORT_COMPLEX_TYPES);
    }

    public SabotConfig getConfig() {
        return this.config;
    }

    @Override
    public void setAutoRead(boolean enableAutoRead) {
        this.client.setAutoRead(enableAutoRead);
    }

    public void setClientName(String name) {
        if (this.connected) {
            throw new IllegalStateException("Attempted to modify client connection property after connection has been established.");
        }
        this.clientName = Preconditions.checkNotNull(name, "client name should not be null");
    }

    public void setSupportComplexTypes(boolean supportComplexTypes) {
        if (this.connected) {
            throw new IllegalStateException("Attempted to modify client connection property after connection has been established.");
        }
        this.supportComplexTypes = supportComplexTypes;
    }

    public void connect() throws RpcException {
        this.connect(null, null);
    }

    public void connect(Properties props) throws RpcException {
        this.connect(null, props);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void connect(String connect, Properties props) throws RpcException {
        if (this.connected) {
            return;
        }
        CoordinationProtos.NodeEndpoint endpoint = this.setUpResources(connect, props);
        try {
            this.connect(endpoint);
            this.connected = true;
        }
        finally {
            if (!this.connected) {
                this.cleanUpResources();
            }
        }
    }

    @VisibleForTesting
    CoordinationProtos.NodeEndpoint setUpResources(String connect, Properties props) throws RpcException {
        CoordinationProtos.NodeEndpoint endpoint;
        if (this.isDirectConnection) {
            String[] connectInfo = props.getProperty("direct").split(":");
            String port = connectInfo.length == 2 ? connectInfo[1] : this.config.getString(INITIAL_USER_PORT);
            endpoint = CoordinationProtos.NodeEndpoint.newBuilder().setAddress(connectInfo[0]).setUserPort(Integer.parseInt(port)).build();
        } else {
            ArrayList<CoordinationProtos.NodeEndpoint> endpoints;
            if (this.clusterCoordinator == null) {
                try {
                    this.clusterCoordinator = new ZKClusterCoordinator(this.config, connect);
                    this.clusterCoordinator.start();
                }
                catch (Exception e) {
                    throw new RpcException("Failure setting up ZK for client.", e);
                }
            }
            Preconditions.checkState(!(endpoints = new ArrayList<CoordinationProtos.NodeEndpoint>(this.clusterCoordinator.getCoordinatorEndpoints())).isEmpty(), "No NodeEndpoint can be found");
            Collections.shuffle(endpoints);
            endpoint = endpoints.iterator().next();
        }
        if (props != null) {
            UserProtos.UserProperties.Builder upBuilder = UserProtos.UserProperties.newBuilder();
            for (String key : props.stringPropertyNames()) {
                if (CLIENT_ONLY_PROPERTIES.contains(key.toLowerCase(Locale.ROOT))) continue;
                upBuilder.addProperties(UserProtos.Property.newBuilder().setKey(key).setValue(props.getProperty(key)));
            }
            this.props = upBuilder.build();
        }
        this.eventLoopGroup = DremioClient.createEventLoop(this.config.getInt(CLIENT_RPC_THREADS), "Client-");
        this.executor = new ThreadPoolExecutor(0, Integer.MAX_VALUE, 60L, TimeUnit.SECONDS, new SynchronousQueue(), new NamedThreadFactory("dremio-client-executor-")){

            @Override
            protected void afterExecute(Runnable r, Throwable t2) {
                if (t2 != null) {
                    logger.error("{}.run() leaked an exception.", (Object)r.getClass().getName(), (Object)t2);
                }
                super.afterExecute(r, t2);
            }
        };
        this.client = new UserClient(this.clientName, this.config, this.supportComplexTypes, this.connectionAllocator, this.eventLoopGroup, this.executor, SSLConfig.of(props), ProxyConfig.of(props));
        logger.debug("Connecting to server {}:{}", (Object)endpoint.getAddress(), (Object)endpoint.getUserPort());
        return endpoint;
    }

    protected static EventLoopGroup createEventLoop(int size, String prefix) {
        return TransportCheck.createEventLoopGroup(size, prefix);
    }

    public synchronized boolean reconnect() {
        if (this.client.isActive()) {
            return true;
        }
        for (int retry = this.reconnectTimes; retry > 0; --retry) {
            try {
                Thread.sleep(this.reconnectDelay);
                ArrayList<CoordinationProtos.NodeEndpoint> endpoints = new ArrayList<CoordinationProtos.NodeEndpoint>(this.clusterCoordinator.getCoordinatorEndpoints());
                if (endpoints.isEmpty()) continue;
                this.client.close();
                Collections.shuffle(endpoints);
                this.connect(endpoints.iterator().next());
                return true;
            }
            catch (Exception exception) {
                continue;
            }
        }
        return false;
    }

    @VisibleForTesting
    void connect(CoordinationProtos.NodeEndpoint endpoint) throws RpcException {
        FutureHandler f = new FutureHandler();
        this.client.connect(f, endpoint, this.props, this.getUserCredentials());
        try {
            DremioFutures.getChecked(f, RpcException.class, 30L, TimeUnit.SECONDS, RpcException::mapException);
        }
        catch (TimeoutException e) {
            throw new RpcException("Timed out after 30s waiting to connect to " + endpoint.getAddress() + ":" + endpoint.getUserPort());
        }
    }

    public BufferAllocator getRecordAllocator() {
        return this.recordAllocator;
    }

    @Override
    public void close() {
        this.cleanUpResources();
        this.connected = false;
    }

    public String getServerName() {
        return this.client != null && this.client.getServerInfos() != null ? this.client.getServerInfos().getName() : null;
    }

    public Version getServerVersion() {
        return this.client != null && this.client.getServerInfos() != null ? UserRpcUtils.getVersion(this.client.getServerInfos()) : null;
    }

    public RpcFuture<UserProtos.GetServerMetaResp> getServerMeta() {
        return this.client.send(UserProtos.RpcType.GET_SERVER_META, UserProtos.GetServerMetaReq.getDefaultInstance(), UserProtos.GetServerMetaResp.class, new ByteBuf[0]);
    }

    public Set<ServerMethod> getSupportedMethods() {
        return this.client != null ? ServerMethod.getSupportedMethods(this.client.getSupportedMethods(), this.client.getServerInfos()) : null;
    }

    public List<QueryDataBatch> runQuery(UserBitShared.QueryType type, String plan) throws RpcException {
        Preconditions.checkArgument(type == UserBitShared.QueryType.LOGICAL || type == UserBitShared.QueryType.PHYSICAL || type == UserBitShared.QueryType.SQL, String.format("Only query types %s, %s and %s are supported in this API", UserBitShared.QueryType.LOGICAL, UserBitShared.QueryType.PHYSICAL, UserBitShared.QueryType.SQL));
        UserProtos.RunQuery query = UserProtos.RunQuery.newBuilder().setResultsMode(UserProtos.QueryResultsMode.STREAM_FULL).setType(type).setPlan(plan).build();
        ListHoldingResultsListener listener = new ListHoldingResultsListener(query);
        this.client.submitQuery(listener, query);
        return listener.getResults();
    }

    public RpcFuture<UserProtos.QueryPlanFragments> planQuery(UserBitShared.QueryType type, String query, boolean isSplitPlan) {
        UserProtos.GetQueryPlanFragments runQuery = UserProtos.GetQueryPlanFragments.newBuilder().setQuery(query).setType(type).setSplitPlan(isSplitPlan).build();
        return this.client.planQuery(runQuery);
    }

    public void runQuery(UserBitShared.QueryType type, CoordExecRPC.PlanFragmentSet planFragments, UserResultsListener resultsListener) throws RpcException {
        Preconditions.checkArgument(UserBitShared.QueryType.EXECUTION == type, "Only EXECUTION type query is supported with PlanFragments");
        UserProtos.RunQuery query = UserProtos.RunQuery.newBuilder().setType(type).setFragmentSet(planFragments).setResultsMode(UserProtos.QueryResultsMode.STREAM_FULL).build();
        this.client.submitQuery(resultsListener, query);
    }

    private UserBitShared.UserCredentials getUserCredentials() {
        String userName = "";
        if (this.props != null) {
            for (UserProtos.Property property : this.props.getPropertiesList()) {
                if (!property.getKey().equalsIgnoreCase("user")) continue;
                userName = property.getValue();
                break;
            }
        }
        return UserBitShared.UserCredentials.newBuilder().setUserName(userName).build();
    }

    public RpcFuture<GeneralRPCProtos.Ack> cancelQuery(UserBitShared.QueryId id) {
        if (logger.isDebugEnabled()) {
            logger.debug("Cancelling query {}", (Object)QueryIdHelper.getQueryId(id));
        }
        return this.client.send(UserProtos.RpcType.CANCEL_QUERY, id, GeneralRPCProtos.Ack.class, new ByteBuf[0]);
    }

    public RpcFuture<GeneralRPCProtos.Ack> resumeQuery(UserBitShared.QueryId queryId) {
        if (logger.isDebugEnabled()) {
            logger.debug("Resuming query {}", (Object)QueryIdHelper.getQueryId(queryId));
        }
        return this.client.send(UserProtos.RpcType.RESUME_PAUSED_QUERY, queryId, GeneralRPCProtos.Ack.class, new ByteBuf[0]);
    }

    public RpcFuture<UserProtos.GetCatalogsResp> getCatalogs(UserProtos.LikeFilter catalogNameFilter) {
        UserProtos.GetCatalogsReq.Builder reqBuilder = UserProtos.GetCatalogsReq.newBuilder();
        if (catalogNameFilter != null) {
            reqBuilder.setCatalogNameFilter(catalogNameFilter);
        }
        return this.client.send(UserProtos.RpcType.GET_CATALOGS, reqBuilder.build(), UserProtos.GetCatalogsResp.class, new ByteBuf[0]);
    }

    public RpcFuture<UserProtos.GetSchemasResp> getSchemas(UserProtos.LikeFilter catalogNameFilter, UserProtos.LikeFilter schemaNameFilter) {
        UserProtos.GetSchemasReq.Builder reqBuilder = UserProtos.GetSchemasReq.newBuilder();
        if (catalogNameFilter != null) {
            reqBuilder.setCatalogNameFilter(catalogNameFilter);
        }
        if (schemaNameFilter != null) {
            reqBuilder.setSchemaNameFilter(schemaNameFilter);
        }
        return this.client.send(UserProtos.RpcType.GET_SCHEMAS, reqBuilder.build(), UserProtos.GetSchemasResp.class, new ByteBuf[0]);
    }

    public RpcFuture<UserProtos.GetTablesResp> getTables(UserProtos.LikeFilter catalogNameFilter, UserProtos.LikeFilter schemaNameFilter, UserProtos.LikeFilter tableNameFilter, List<String> tableTypeFilter) {
        UserProtos.GetTablesReq.Builder reqBuilder = UserProtos.GetTablesReq.newBuilder();
        if (catalogNameFilter != null) {
            reqBuilder.setCatalogNameFilter(catalogNameFilter);
        }
        if (schemaNameFilter != null) {
            reqBuilder.setSchemaNameFilter(schemaNameFilter);
        }
        if (tableNameFilter != null) {
            reqBuilder.setTableNameFilter(tableNameFilter);
        }
        if (tableTypeFilter != null) {
            reqBuilder.addAllTableTypeFilter(tableTypeFilter);
        }
        return this.client.send(UserProtos.RpcType.GET_TABLES, reqBuilder.build(), UserProtos.GetTablesResp.class, new ByteBuf[0]);
    }

    public RpcFuture<UserProtos.GetColumnsResp> getColumns(UserProtos.LikeFilter catalogNameFilter, UserProtos.LikeFilter schemaNameFilter, UserProtos.LikeFilter tableNameFilter, UserProtos.LikeFilter columnNameFilter) {
        UserProtos.GetColumnsReq.Builder reqBuilder = UserProtos.GetColumnsReq.newBuilder();
        if (catalogNameFilter != null) {
            reqBuilder.setCatalogNameFilter(catalogNameFilter);
        }
        if (schemaNameFilter != null) {
            reqBuilder.setSchemaNameFilter(schemaNameFilter);
        }
        if (tableNameFilter != null) {
            reqBuilder.setTableNameFilter(tableNameFilter);
        }
        if (columnNameFilter != null) {
            reqBuilder.setColumnNameFilter(columnNameFilter);
        }
        return this.client.send(UserProtos.RpcType.GET_COLUMNS, reqBuilder.build(), UserProtos.GetColumnsResp.class, new ByteBuf[0]);
    }

    public RpcFuture<UserProtos.CreatePreparedStatementResp> createPreparedStatement(String query) {
        UserProtos.CreatePreparedStatementReq req = UserProtos.CreatePreparedStatementReq.newBuilder().setSqlQuery(query).build();
        return this.client.send(UserProtos.RpcType.CREATE_PREPARED_STATEMENT, req, UserProtos.CreatePreparedStatementResp.class, new ByteBuf[0]);
    }

    public boolean isActive() {
        return this.client.isActive();
    }

    public void executePreparedStatement(UserProtos.PreparedStatementHandle preparedStatementHandle, List<UserProtos.PreparedStatementParameterValue> parameters, UserResultsListener resultsListener) {
        UserProtos.RunQuery runQuery = UserProtos.RunQuery.newBuilder().setResultsMode(UserProtos.QueryResultsMode.STREAM_FULL).setType(UserBitShared.QueryType.PREPARED_STATEMENT).setPreparedStatementHandle(preparedStatementHandle).addAllParameters(parameters).build();
        this.client.submitQuery(resultsListener, runQuery);
    }

    public List<QueryDataBatch> executePreparedStatement(UserProtos.PreparedStatementHandle preparedStatementHandle, List<UserProtos.PreparedStatementParameterValue> parameters) throws RpcException {
        UserProtos.RunQuery runQuery = UserProtos.RunQuery.newBuilder().setResultsMode(UserProtos.QueryResultsMode.STREAM_FULL).setType(UserBitShared.QueryType.PREPARED_STATEMENT).setPreparedStatementHandle(preparedStatementHandle).addAllParameters(parameters).build();
        ListHoldingResultsListener resultsListener = new ListHoldingResultsListener(runQuery);
        this.client.submitQuery(resultsListener, runQuery);
        return resultsListener.getResults();
    }

    public void runQuery(UserBitShared.QueryType type, String plan, UserResultsListener resultsListener) {
        this.client.submitQuery(resultsListener, UserProtos.RunQuery.newBuilder().setResultsMode(UserProtos.QueryResultsMode.STREAM_FULL).setType(type).setPlan(plan).build());
    }

    @VisibleForTesting
    void cleanUpResources() {
        ArrayList<AutoCloseable> resources = new ArrayList<AutoCloseable>();
        resources.add(this.client);
        resources.add(this.recordAllocator);
        resources.add(this.connectionAllocator);
        if (this.ownsAllocator) {
            resources.add(this.rootAllocator);
        }
        resources.add(this.clusterCoordinator);
        resources.add(new AutoCloseable(){

            @Override
            public void close() throws Exception {
                try {
                    DremioClient.this.eventLoopGroup.shutdownGracefully(0L, 0L, TimeUnit.SECONDS).sync();
                }
                catch (InterruptedException e) {
                    logger.warn("Failure while shutting down event loop in dremio client. ", e);
                    Thread.interrupted();
                }
            }
        });
        resources.add(this.executor::shutdownNow);
        try {
            AutoCloseables.close(resources);
        }
        catch (Exception e) {
            logger.warn("Error while cleaning up resources in DremioClient", e);
        }
        finally {
            this.client = null;
            this.clusterCoordinator = null;
            this.eventLoopGroup = null;
            this.executor = null;
        }
    }

    private static class ClusterCoordinatorWrapper
    extends ClusterCoordinator {
        private final ClusterCoordinator clusterCoordinator;

        public ClusterCoordinatorWrapper(ClusterCoordinator clusterCoordinator) {
            this.clusterCoordinator = clusterCoordinator;
        }

        @Override
        public void start() throws Exception {
        }

        @Override
        public ServiceSet getServiceSet(ClusterCoordinator.Role role) {
            return this.clusterCoordinator.getServiceSet(role);
        }

        @Override
        public ServiceSet getOrCreateServiceSet(String serviceName) {
            return this.clusterCoordinator.getOrCreateServiceSet(serviceName);
        }

        @Override
        public void deleteServiceSet(String serviceName) {
            this.clusterCoordinator.deleteServiceSet(serviceName);
        }

        @Override
        public Iterable<String> getServiceNames() throws Exception {
            return this.clusterCoordinator.getServiceNames();
        }

        @Override
        public DistributedSemaphore getSemaphore(String name, int maximumLeases) {
            throw new UnsupportedOperationException("registerService is not supported in client");
        }

        @Override
        public ElectionRegistrationHandle joinElection(String name, ElectionListener listener) {
            throw new UnsupportedOperationException("registerService is not supported in client");
        }

        @Override
        public LinearizableHierarchicalStore getHierarchicalStore() {
            throw new UnsupportedOperationException("Hierarchical Store is not supported in client");
        }

        @Override
        public void close() {
        }

        private static ClusterCoordinator of(ClusterCoordinator coordinator) {
            if (coordinator == null) {
                return null;
            }
            return new ClusterCoordinatorWrapper(coordinator);
        }
    }

    private class FutureHandler
    extends ForwardingListenableFuture.SimpleForwardingListenableFuture<Void>
    implements RpcConnectionHandler<BasicClientWithConnection.ServerConnection>,
    RpcFuture<Void> {
        protected FutureHandler() {
            super(SettableFuture.create());
        }

        @Override
        public void connectionSucceeded(BasicClientWithConnection.ServerConnection connection) {
            this.getInner().set(null);
        }

        @Override
        public void connectionFailed(RpcConnectionHandler.FailureType type, Throwable t2) {
            RpcException rpcEx;
            if (t2 instanceof RpcException) {
                RpcException rpcThrowable = (RpcException)t2;
                rpcEx = new RpcException(String.format("%s : %s", type.name(), t2.getMessage()), rpcThrowable.getStatus(), rpcThrowable.getErrorId(), t2);
            } else {
                rpcEx = new RpcException(String.format("%s : %s", type.name(), t2.getMessage()), t2);
            }
            this.getInner().setException(ConnectionFailedException.mapException(rpcEx, type));
        }

        private SettableFuture<Void> getInner() {
            return (SettableFuture)this.delegate();
        }

        @Override
        public ByteBuf getBuffer() {
            return null;
        }
    }

    private class ListHoldingResultsListener
    implements UserResultsListener {
        private final Vector<QueryDataBatch> results = new Vector();
        private final SettableFuture<List<QueryDataBatch>> future = SettableFuture.create();
        private final UserProtos.RunQuery query;

        public ListHoldingResultsListener(UserProtos.RunQuery query) {
            logger.debug("Listener created for query \"\"\"{}\"\"\"", (Object)query);
            this.query = query;
        }

        @Override
        public void submissionFailed(UserException ex) {
            if (ex.getCause() instanceof ChannelClosedException) {
                if (DremioClient.this.reconnect()) {
                    try {
                        DremioClient.this.client.submitQuery(this, this.query);
                    }
                    catch (Exception e) {
                        this.fail(e);
                    }
                } else {
                    this.fail(ex);
                }
            } else {
                this.fail(ex);
            }
        }

        @Override
        public void queryCompleted(UserBitShared.QueryResult.QueryState state) {
            this.future.set(this.results);
        }

        private void fail(Exception ex) {
            logger.debug("Submission failed.", ex);
            this.future.setException(ex);
            this.future.set(this.results);
        }

        @Override
        public void dataArrived(QueryDataBatch result, ConnectionThrottle throttle) {
            logger.debug("Result arrived:  Result: {}", (Object)result);
            this.results.add(result);
        }

        public List<QueryDataBatch> getResults() throws RpcException {
            try {
                return (List)this.future.get();
            }
            catch (Throwable t2) {
                for (QueryDataBatch queryDataBatch : this.results) {
                    queryDataBatch.release();
                }
                throw RpcException.mapException(t2);
            }
        }

        @Override
        public void queryIdArrived(UserBitShared.QueryId queryId) {
            if (logger.isDebugEnabled()) {
                logger.debug("Query ID arrived: {}", (Object)QueryIdHelper.getQueryId(queryId));
            }
        }
    }
}

