/*
 * Decompiled with CFR 0.152.
 */
package com.dremio.jdbc.shaded.com.dremio.exec.exception;

import com.dremio.jdbc.shaded.com.dremio.common.expression.CompleteType;
import com.dremio.jdbc.shaded.org.apache.arrow.vector.types.pojo.ArrowType;
import com.dremio.jdbc.shaded.org.apache.arrow.vector.types.pojo.Field;
import java.util.ArrayList;
import java.util.List;

public class NoSupportedUpPromotionOrCoercionException
extends RuntimeException {
    private final CompleteType fileType;
    private final CompleteType tableType;
    private final List<String> columns;
    private List<String> datasetPath;
    private String filePath;

    public NoSupportedUpPromotionOrCoercionException(CompleteType fileType, CompleteType tableType) {
        this.fileType = fileType;
        this.tableType = tableType;
        this.columns = new ArrayList<String>();
    }

    @Override
    public String getMessage() {
        int i;
        StringBuilder sb = new StringBuilder();
        if (this.checkForStructNMapCoercion(this.fileType, this.tableType)) {
            sb.append("Map support is OFF. Enable support key \"dremio.data_types.map.enabled\" to use native map type or reformat the dataset to read map columns in the old format.");
            return sb.toString();
        }
        if (this.checkForStructNMapCoercion(this.tableType, this.fileType)) {
            sb.append("Map support is ON. Reformat the dataset to read map columns as native maps or disable support key \"dremio.data_types.map.enabled\" to use the old format.");
            return sb.toString();
        }
        sb.append("Unable to coerce from the file's data type \"");
        sb.append(this.fileType);
        sb.append("\" to the column's data type \"");
        sb.append(this.tableType);
        sb.append("\"");
        if (this.datasetPath != null && this.datasetPath.size() > 0) {
            sb.append(" in table \"");
            for (i = 0; i < this.datasetPath.size() - 1; ++i) {
                sb.append(this.datasetPath.get(i));
                sb.append(".");
            }
            sb.append(this.datasetPath.get(this.datasetPath.size() - 1));
            sb.append("\"");
        }
        if (this.columns != null && this.columns.size() > 0) {
            sb.append(", column \"");
            for (i = this.columns.size() - 1; i > 0; --i) {
                sb.append(this.columns.get(i));
                sb.append(".");
            }
            sb.append(this.columns.get(0));
            sb.append("\"");
        }
        if (this.filePath != null) {
            sb.append(" and file \"");
            sb.append(this.filePath);
            sb.append("\"");
        }
        return sb.toString();
    }

    public void addColumnName(String name) {
        this.columns.add(name);
    }

    public void addFilePath(String path) {
        this.filePath = path;
    }

    public void addDatasetPath(List<String> datasetPath) {
        this.datasetPath = datasetPath;
    }

    public boolean compareFieldsForStructMapEquivalence(Field a, Field b) {
        if (a.getType().getTypeID() == ArrowType.ArrowTypeID.Struct && b.getType().getTypeID() == ArrowType.ArrowTypeID.Map) {
            if (a.getChildren().size() != 1 || a.getChildren().get(0).getType().getTypeID() != ArrowType.ArrowTypeID.List) {
                return false;
            }
            a = a.getChildren().get(0).getChildren().get(0);
            b = b.getChildren().get(0);
            if (a.getType().getTypeID() != b.getType().getTypeID()) {
                return false;
            }
        } else if (!a.getName().equalsIgnoreCase(b.getName()) || a.getType().getTypeID() != b.getType().getTypeID()) {
            return false;
        }
        List<Field> aChildren = a.getChildren();
        List<Field> bChildren = b.getChildren();
        if (aChildren.size() == bChildren.size()) {
            for (int i = 0; i < aChildren.size(); ++i) {
                if (this.compareFieldsForStructMapEquivalence(aChildren.get(i), bChildren.get(i)) || this.compareFieldsForStructMapEquivalence(bChildren.get(i), aChildren.get(i))) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public boolean checkForStructNMapCoercion(CompleteType a, CompleteType b) {
        return this.compareFieldsForStructMapEquivalence(a.toField(""), b.toField(""));
    }
}

