/*
 * Decompiled with CFR 0.152.
 */
package com.dremio.jdbc.shaded.com.dremio.exec.record;

import com.dremio.jdbc.shaded.com.dremio.common.expression.BasePath;
import com.dremio.jdbc.shaded.com.dremio.exec.proto.ExecRPC;
import com.dremio.jdbc.shaded.com.dremio.exec.record.BatchSchema;
import com.dremio.jdbc.shaded.com.dremio.exec.record.TypedFieldId;
import com.dremio.jdbc.shaded.com.dremio.exec.record.VectorAccessible;
import com.dremio.jdbc.shaded.com.dremio.exec.record.VectorContainer;
import com.dremio.jdbc.shaded.com.dremio.exec.record.VectorWrapper;
import com.dremio.jdbc.shaded.com.dremio.exec.record.WritableBatch;
import com.dremio.jdbc.shaded.com.dremio.exec.record.selection.SelectionVector2;
import com.dremio.jdbc.shaded.com.dremio.exec.record.selection.SelectionVector4;
import com.dremio.jdbc.shaded.com.dremio.sabot.op.receiver.RawFragmentBatch;
import com.dremio.jdbc.shaded.com.google.common.base.Function;
import com.dremio.jdbc.shaded.com.google.common.base.Preconditions;
import com.dremio.jdbc.shaded.com.google.common.collect.FluentIterable;
import com.dremio.jdbc.shaded.com.google.common.collect.ImmutableList;
import com.dremio.jdbc.shaded.org.apache.arrow.flatbuf.Buffer;
import com.dremio.jdbc.shaded.org.apache.arrow.flatbuf.FieldNode;
import com.dremio.jdbc.shaded.org.apache.arrow.flatbuf.RecordBatch;
import com.dremio.jdbc.shaded.org.apache.arrow.memory.ArrowBuf;
import com.dremio.jdbc.shaded.org.apache.arrow.memory.BufferAllocator;
import com.dremio.jdbc.shaded.org.apache.arrow.memory.util.LargeMemoryUtil;
import com.dremio.jdbc.shaded.org.apache.arrow.vector.AllocationHelper;
import com.dremio.jdbc.shaded.org.apache.arrow.vector.BufferLayout;
import com.dremio.jdbc.shaded.org.apache.arrow.vector.FieldVector;
import com.dremio.jdbc.shaded.org.apache.arrow.vector.TypeLayout;
import com.dremio.jdbc.shaded.org.apache.arrow.vector.ValueVector;
import com.dremio.jdbc.shaded.org.apache.arrow.vector.compression.NoCompressionCodec;
import com.dremio.jdbc.shaded.org.apache.arrow.vector.ipc.message.ArrowFieldNode;
import com.dremio.jdbc.shaded.org.apache.arrow.vector.ipc.message.ArrowRecordBatch;
import com.dremio.jdbc.shaded.org.apache.arrow.vector.types.pojo.Field;
import com.dremio.jdbc.shaded.org.slf4j.Logger;
import com.dremio.jdbc.shaded.org.slf4j.LoggerFactory;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class ArrowRecordBatchLoader
implements VectorAccessible,
Iterable<VectorWrapper<?>>,
AutoCloseable {
    private static final Logger logger = LoggerFactory.getLogger(ArrowRecordBatchLoader.class);
    private VectorContainer container;
    private int valueCount;
    private BatchSchema schema;

    public ArrowRecordBatchLoader(VectorContainer container) {
        this.container = container;
        this.schema = container.getSchema();
    }

    public ArrowRecordBatchLoader(BufferAllocator allocator, BatchSchema schema) {
        Preconditions.checkNotNull(allocator);
        this.schema = schema;
        this.container = VectorContainer.create(allocator, schema);
    }

    public int load(RawFragmentBatch batch) {
        return this.load(batch.getHeader(), batch.getBody());
    }

    public int load(ExecRPC.FragmentRecordBatch header, ArrowBuf body) {
        this.container.zeroVectors();
        int size = 0;
        try {
            RecordBatch recordBatch = RecordBatch.getRootAsRecordBatch(header.getArrowRecordBatch().asReadOnlyByteBuffer());
            if (body == null) {
                for (VectorWrapper<?> w : this.container) {
                    AllocationHelper.allocate(w.getValueVector(), 0, 0, 0);
                }
                this.container.setRecordCount(0);
            }
            if (recordBatch.length() > Integer.MAX_VALUE) {
                throw new IllegalArgumentException("record batch length too big: " + recordBatch.length());
            }
            this.valueCount = (int)recordBatch.length();
            if (this.valueCount == 0) {
                return 0;
            }
            size = body == null ? 0 : LargeMemoryUtil.checkedCastToInt(body.readableBytes());
            ArrowRecordBatchLoader.load(recordBatch, this.container, body);
        }
        catch (Throwable cause) {
            this.container.zeroVectors();
            throw cause;
        }
        this.container.setRecordCount(this.valueCount);
        return size;
    }

    public static ArrowRecordBatch deserializeRecordBatch(RecordBatch recordBatchFB, ArrowBuf body) throws IOException {
        int nodesLength = recordBatchFB.nodesLength();
        ArrayList<ArrowFieldNode> nodes = new ArrayList<ArrowFieldNode>();
        for (int i = 0; i < nodesLength; ++i) {
            FieldNode node = recordBatchFB.nodes(i);
            if ((long)((int)node.length()) != node.length() || (long)((int)node.nullCount()) != node.nullCount()) {
                throw new IOException("Cannot currently deserialize record batches with node length larger than Int.MAX_VALUE");
            }
            nodes.add(new ArrowFieldNode((int)node.length(), (int)node.nullCount()));
        }
        ArrayList<ArrowBuf> buffers = new ArrayList<ArrowBuf>();
        for (int i = 0; i < recordBatchFB.buffersLength(); ++i) {
            Buffer bufferFB = recordBatchFB.buffers(i);
            ArrowBuf vectorBuffer = body.slice((int)bufferFB.offset(), (int)bufferFB.length());
            buffers.add(vectorBuffer);
        }
        if ((long)((int)recordBatchFB.length()) != recordBatchFB.length()) {
            throw new IOException("Cannot currently deserialize record batches over 2GB");
        }
        ArrowRecordBatch arrowRecordBatch = new ArrowRecordBatch((int)recordBatchFB.length(), nodes, buffers, NoCompressionCodec.DEFAULT_BODY_COMPRESSION, false);
        for (ArrowBuf buf : buffers) {
            buf.close();
        }
        return arrowRecordBatch;
    }

    public static void load(RecordBatch recordBatch, VectorAccessible vectorAccessible, ArrowBuf body) {
        List<Field> fields = vectorAccessible.getSchema().getFields();
        ImmutableList fieldVectors = FluentIterable.from(vectorAccessible).transform(new Function<VectorWrapper<?>, FieldVector>(){

            @Override
            public FieldVector apply(VectorWrapper<?> wrapper) {
                return (FieldVector)wrapper.getValueVector();
            }
        }).toList();
        try {
            ArrowRecordBatch arrowRecordBatch = ArrowRecordBatchLoader.deserializeRecordBatch(recordBatch, body);
            Iterator<ArrowFieldNode> nodes = arrowRecordBatch.getNodes().iterator();
            Iterator<ArrowBuf> buffers = arrowRecordBatch.getBuffers().iterator();
            for (int i = 0; i < fields.size(); ++i) {
                Field field = fields.get(i);
                FieldVector fieldVector = (FieldVector)fieldVectors.get(i);
                ArrowRecordBatchLoader.loadBuffers(fieldVector, field, buffers, nodes);
            }
            if (buffers.hasNext()) {
                throw new IllegalArgumentException("not all buffers were consumed. " + String.valueOf(buffers));
            }
        }
        catch (IOException e) {
            throw new RuntimeException("could not deserialize batch for " + String.valueOf(vectorAccessible.getSchema()), e);
        }
    }

    private static void loadBuffers(FieldVector vector, Field field, Iterator<ArrowBuf> buffers, Iterator<ArrowFieldNode> nodes) {
        Preconditions.checkArgument(nodes.hasNext(), "no more field nodes for for field %s and vector %s", (Object)field, (Object)vector);
        ArrowFieldNode fieldNode = nodes.next();
        List<BufferLayout> bufferLayouts = TypeLayout.getTypeLayout(field.getType()).getBufferLayouts();
        ArrayList<ArrowBuf> ownBuffers = new ArrayList<ArrowBuf>(bufferLayouts.size());
        for (int j = 0; j < bufferLayouts.size(); ++j) {
            ownBuffers.add(buffers.next());
        }
        try {
            vector.loadFieldBuffers(fieldNode, ownBuffers);
        }
        catch (RuntimeException e) {
            throw new IllegalArgumentException("Could not load buffers for field " + String.valueOf(field) + ". error message: " + e.getMessage(), e);
        }
        List<Field> children = field.getChildren();
        if (children.size() > 0) {
            List<FieldVector> childrenFromFields = vector.getChildrenFromFields();
            Preconditions.checkArgument(children.size() == childrenFromFields.size(), "should have as many children as in the schema: found " + childrenFromFields.size() + " expected " + children.size());
            for (int i = 0; i < childrenFromFields.size(); ++i) {
                Field child = children.get(i);
                FieldVector fieldVector = childrenFromFields.get(i);
                ArrowRecordBatchLoader.loadBuffers(fieldVector, child, buffers, nodes);
            }
        }
    }

    @Override
    public TypedFieldId getValueVectorId(BasePath path) {
        return this.container.getValueVectorId(path);
    }

    @Override
    public int getRecordCount() {
        return this.valueCount;
    }

    @Override
    public <T extends ValueVector> VectorWrapper<T> getValueAccessorById(Class<T> clazz, int ... ids) {
        return this.container.getValueAccessorById(clazz, ids);
    }

    public WritableBatch getWritableBatch() {
        boolean isSV2 = this.schema.getSelectionVectorMode() == BatchSchema.SelectionVectorMode.TWO_BYTE;
        return WritableBatch.getBatchNoHVWrap(this.valueCount, this.container, isSV2);
    }

    @Override
    public Iterator<VectorWrapper<?>> iterator() {
        return this.container.iterator();
    }

    @Override
    public SelectionVector2 getSelectionVector2() {
        throw new UnsupportedOperationException();
    }

    @Override
    public SelectionVector4 getSelectionVector4() {
        throw new UnsupportedOperationException();
    }

    @Override
    public BatchSchema getSchema() {
        return this.schema;
    }

    public void resetRecordCount() {
        this.valueCount = 0;
    }

    public void clear() {
        this.close();
    }

    @Override
    public void close() {
        this.container.clear();
        this.resetRecordCount();
    }
}

