/*
 * Decompiled with CFR 0.152.
 */
package com.dremio.jdbc.shaded.com.dremio.exec.record;

import com.dremio.jdbc.shaded.com.dremio.common.exceptions.UserException;
import com.dremio.jdbc.shaded.com.dremio.common.expression.BasePath;
import com.dremio.jdbc.shaded.com.dremio.common.expression.CompleteType;
import com.dremio.jdbc.shaded.com.dremio.common.expression.Describer;
import com.dremio.jdbc.shaded.com.dremio.common.types.SupportsTypeCoercionsAndUpPromotions;
import com.dremio.jdbc.shaded.com.dremio.exec.exception.NoSupportedUpPromotionOrCoercionException;
import com.dremio.jdbc.shaded.com.dremio.exec.record.SchemaBuilder;
import com.dremio.jdbc.shaded.com.dremio.exec.record.TypedFieldId;
import com.dremio.jdbc.shaded.com.dremio.exec.vector.complex.fn.FieldSelection;
import com.dremio.jdbc.shaded.com.dremio.sabot.op.scan.OutputMutator;
import com.dremio.jdbc.shaded.com.fasterxml.jackson.core.JsonFactory;
import com.dremio.jdbc.shaded.com.fasterxml.jackson.core.JsonGenerator;
import com.dremio.jdbc.shaded.com.fasterxml.jackson.core.JsonParser;
import com.dremio.jdbc.shaded.com.fasterxml.jackson.core.JsonProcessingException;
import com.dremio.jdbc.shaded.com.fasterxml.jackson.databind.DeserializationContext;
import com.dremio.jdbc.shaded.com.fasterxml.jackson.databind.JsonDeserializer;
import com.dremio.jdbc.shaded.com.fasterxml.jackson.databind.JsonSerializer;
import com.dremio.jdbc.shaded.com.fasterxml.jackson.databind.SerializerProvider;
import com.dremio.jdbc.shaded.com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.dremio.jdbc.shaded.com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.dremio.jdbc.shaded.com.google.common.base.Function;
import com.dremio.jdbc.shaded.com.google.common.base.Preconditions;
import com.dremio.jdbc.shaded.com.google.common.collect.FluentIterable;
import com.dremio.jdbc.shaded.com.google.common.collect.ImmutableList;
import com.dremio.jdbc.shaded.com.google.common.collect.ImmutableListMultimap;
import com.dremio.jdbc.shaded.com.google.common.collect.ImmutableMap;
import com.dremio.jdbc.shaded.com.google.common.collect.Lists;
import com.dremio.jdbc.shaded.com.google.common.collect.Maps;
import com.dremio.jdbc.shaded.com.google.common.collect.Multimaps;
import com.dremio.jdbc.shaded.com.google.common.collect.Streams;
import com.dremio.jdbc.shaded.com.google.flatbuffers.FlatBufferBuilder;
import com.dremio.jdbc.shaded.io.protostuff.ByteString;
import com.dremio.jdbc.shaded.org.apache.arrow.vector.ValueVector;
import com.dremio.jdbc.shaded.org.apache.arrow.vector.complex.FieldIdUtil2;
import com.dremio.jdbc.shaded.org.apache.arrow.vector.types.FloatingPointPrecision;
import com.dremio.jdbc.shaded.org.apache.arrow.vector.types.pojo.ArrowType;
import com.dremio.jdbc.shaded.org.apache.arrow.vector.types.pojo.Field;
import com.dremio.jdbc.shaded.org.apache.arrow.vector.types.pojo.FieldType;
import com.dremio.jdbc.shaded.org.apache.arrow.vector.types.pojo.Schema;
import com.dremio.jdbc.shaded.org.slf4j.Logger;
import com.dremio.jdbc.shaded.org.slf4j.LoggerFactory;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;

@JsonSerialize(using=Ser.class)
@JsonDeserialize(using=De.class)
public class BatchSchema
extends Schema
implements Iterable<Field> {
    private static final Logger logger = LoggerFactory.getLogger(BatchSchema.class);
    public static final String SCHEMA_UNKNOWN_NO_DATA_COLNAME = "NO_DATA";
    public static final BatchSchema SCHEMA_UNKNOWN_NO_DATA = BatchSchema.newBuilder().addField(new Field("NO_DATA", new FieldType(true, new ArrowType.Utf8(), null), null)).build();
    public static final BatchSchema EMPTY = new BatchSchema(Collections.emptyList());
    public static final String MIXED_TYPES_ERROR = "Mixed types are not supported as returned values over JDBC, ODBC and Flight connections.";
    private final SelectionVectorMode selectionVectorMode;
    private static java.util.function.Function<Field, Field> UPPERCASE_NAME = field -> new Field(field.getName().toUpperCase(), field.getFieldType(), field.getChildren());
    private static final Function<Field, CompleteType> TO_TYPES = new Function<Field, CompleteType>(){

        @Override
        public CompleteType apply(Field input) {
            return CompleteType.fromField(input);
        }
    };

    public BatchSchema(List<Field> fields) {
        super(fields);
        this.selectionVectorMode = SelectionVectorMode.NONE;
    }

    BatchSchema(SelectionVectorMode selectionVector, List<Field> fields) {
        super(fields);
        this.selectionVectorMode = selectionVector;
    }

    public static SchemaBuilder newBuilder() {
        return new SchemaBuilder();
    }

    public int getFieldCount() {
        return this.getFields().size();
    }

    public TypedFieldId getFieldId(BasePath path) {
        return FieldIdUtil2.getFieldId(this, path);
    }

    public Field getColumn(int index) {
        if (index < 0 || index >= this.getFields().size()) {
            return null;
        }
        return this.getFields().get(index);
    }

    public boolean isUnknownSchema() {
        return SCHEMA_UNKNOWN_NO_DATA.equals(this);
    }

    public static void assertNoUnion(List<Field> fields) {
        List<String> errorPath = BatchSchema.doAssertNoUnion(fields, new ArrayList<String>());
        if (errorPath == null) {
            return;
        }
        Object errorMessage = MIXED_TYPES_ERROR;
        errorMessage = (String)errorMessage + String.format(" Cast %s to a primitive data type either in the select statement or the VDS definition.", errorPath.stream().collect(Collectors.joining(".", "\"", "\"")));
        throw UserException.unsupportedError().message((String)errorMessage).buildSilently();
    }

    public static List<String> doAssertNoUnion(List<Field> fields, List<String> errorPath) {
        for (Field f : fields) {
            if (f.getFieldType().getType().getTypeID() == ArrowType.ArrowTypeID.Union) {
                errorPath.add(f.getName());
                return errorPath;
            }
            errorPath.add(f.getName());
            List<String> lowerErrorPath = BatchSchema.doAssertNoUnion(f.getChildren(), errorPath);
            if (lowerErrorPath != null) {
                return lowerErrorPath;
            }
            errorPath.remove(errorPath.size() - 1);
        }
        return null;
    }

    @Override
    public Iterator<Field> iterator() {
        return this.getFields().iterator();
    }

    public SelectionVectorMode getSelectionVectorMode() {
        return this.selectionVectorMode;
    }

    public BatchSchema maskAndReorder(List<? extends BasePath> schemaPaths) {
        return this.mask(schemaPaths, true);
    }

    public BatchSchema mask(List<? extends BasePath> schemaPaths, boolean reorder) {
        FieldSelection selection = FieldSelection.getFieldSelection(schemaPaths);
        List<Field> newFields = BatchSchema.maskFields(this.getFields(), selection);
        if (!reorder) {
            return new BatchSchema(this.selectionVectorMode, newFields);
        }
        ImmutableMap<String, Field> updatedFields = FluentIterable.from(newFields).uniqueIndex(new Function<Field, String>(){

            @Override
            public String apply(Field input) {
                return input.getName().toLowerCase();
            }
        });
        if (selection.isAlwaysValid()) {
            return new BatchSchema(this.selectionVectorMode, newFields);
        }
        HashSet<String> requestedTopLevelFields = new HashSet<String>();
        ArrayList<Field> updatedFieldList = new ArrayList<Field>();
        for (BasePath basePath : schemaPaths) {
            String name = basePath.getRootSegment().getPath().toLowerCase();
            if (!requestedTopLevelFields.add(name)) continue;
            Field f = Preconditions.checkNotNull((Field)updatedFields.get(name), "The projected column %s was not found in the schema to be masked: %s with a mask of %s.", (Object)name, (Object)this, schemaPaths);
            updatedFieldList.add(f);
        }
        Preconditions.checkArgument(updatedFieldList.size() == newFields.size(), "Expected reordered field list to use all %s fields, only used %s.", newFields.size(), updatedFieldList.size());
        return new BatchSchema(this.selectionVectorMode, updatedFieldList);
    }

    public BatchSchema removeNullFields() {
        return new BatchSchema(this.selectionVectorMode, this.removeNullFields(this.getFields()));
    }

    private List<Field> removeNullFields(List<Field> oldFields) {
        return this.removeFieldsOfType(oldFields, ArrowType.ArrowTypeID.Null);
    }

    private List<Field> removeFieldsOfType(List<Field> oldFields, ArrowType.ArrowTypeID typeID) {
        ArrayList<Field> newFields = new ArrayList<Field>();
        for (Field field : oldFields) {
            if (field.getFieldType().getType().getTypeID() == typeID) continue;
            List<Field> children = this.removeFieldsOfType(field.getChildren(), typeID);
            if (field.getType().isComplex() && children.isEmpty()) continue;
            if (children.equals(field.getChildren())) {
                newFields.add(field);
                continue;
            }
            newFields.add(new Field(field.getName(), field.getFieldType(), children));
        }
        return newFields;
    }

    private static List<Field> maskFields(List<Field> fields, FieldSelection selection) {
        ImmutableList.Builder fieldsListBuilder = ImmutableList.builder();
        for (Field field : fields) {
            FieldSelection childSelection = selection.getChild(field.getName());
            if (childSelection.isNeverValid()) continue;
            if (field.getType().getTypeID() == ArrowType.ArrowTypeID.List) {
                Field innerField = field.getChildren().get(0);
                List<Field> childFields = BatchSchema.maskFields(innerField.getChildren(), selection.getChild(field.getName()));
                Field newInnerField = new Field(innerField.getName(), new FieldType(innerField.isNullable(), innerField.getType(), null), childFields);
                fieldsListBuilder.add(new Field(field.getName(), new FieldType(field.isNullable(), field.getType(), null), Collections.singletonList(newInnerField)));
                continue;
            }
            List<Field> childFields = BatchSchema.maskFields(field.getChildren(), selection.getChild(field.getName()));
            fieldsListBuilder.add(new Field(field.getName(), new FieldType(field.isNullable(), field.getType(), null), childFields));
        }
        return fieldsListBuilder.build();
    }

    public BatchSchema clone() {
        return this.cloneWithFields(Collections.emptyList());
    }

    public BatchSchema cloneWithFields(List<Field> fields) {
        ArrayList<Field> newFields = Lists.newArrayList();
        newFields.addAll(this.getFields());
        newFields.addAll(fields);
        return new BatchSchema(this.selectionVectorMode, newFields);
    }

    public BatchSchema clone(SelectionVectorMode mode) {
        ArrayList<Field> newFields = Lists.newArrayList();
        newFields.addAll(this.getFields());
        return new BatchSchema(mode, newFields);
    }

    public String toStringVerbose() {
        return BatchSchema.toString(this.getFields());
    }

    public static String toString(List<Field> fields) {
        StringBuilder b = new StringBuilder();
        for (Field field : fields) {
            BatchSchema.toString(field, 0, b);
        }
        return b.toString();
    }

    public static void toString(Field field, int depth, StringBuilder b) {
        b.append("\n");
        for (int i = 0; i < depth; ++i) {
            b.append(" ");
        }
        b.append(field.getName());
        b.append(";");
        b.append(field.isNullable());
        b.append(";");
        b.append(Describer.describe(field.getType()));
        for (Field child : field.getChildren()) {
            BatchSchema.toString(child, depth + 1, b);
        }
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        boolean first = true;
        sb.append("schema(");
        for (Field f : this.getFields()) {
            if (!first) {
                sb.append(", ");
            } else {
                first = false;
            }
            sb.append(Describer.describe(f));
        }
        if (this.selectionVectorMode != SelectionVectorMode.NONE) {
            sb.append(" SelectionVectorMode::");
            sb.append(this.selectionVectorMode.name());
        }
        sb.append(")");
        return sb.toString();
    }

    public String toJSONString() throws IOException {
        JsonFactory factory = new JsonFactory();
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        JsonGenerator jsonGenerator = factory.createGenerator(outputStream);
        this.toJSONString("root", null, this.getFields(), jsonGenerator);
        jsonGenerator.flush();
        return outputStream.toString();
    }

    private void toJSONString(String name, ArrowType.ArrowTypeID typeID, List<Field> children, JsonGenerator jsonGenerator) throws IOException {
        jsonGenerator.writeStartObject();
        jsonGenerator.writeFieldName("name");
        jsonGenerator.writeString(name);
        if (typeID != null) {
            jsonGenerator.writeFieldName("type");
            jsonGenerator.writeString(typeID.name());
        }
        if (children != null && children.size() > 0) {
            jsonGenerator.writeFieldName("children");
            jsonGenerator.writeStartArray(children.size());
            for (Field child : children) {
                this.toJSONString(child.getName(), child.getType().getTypeID(), child.getChildren(), jsonGenerator);
            }
            jsonGenerator.writeEndArray();
        }
        jsonGenerator.writeEndObject();
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.getFields() == null ? 0 : this.getFields().hashCode());
        result = 31 * result + (this.selectionVectorMode == null ? 0 : this.selectionVectorMode.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (!(obj instanceof BatchSchema)) {
            return false;
        }
        BatchSchema that = (BatchSchema)obj;
        return Objects.equals(this.getFields(), that.getFields()) && Objects.equals((Object)this.selectionVectorMode, (Object)that.selectionVectorMode);
    }

    public boolean equalsIgnoreCase(Object obj) {
        if (!(obj instanceof BatchSchema)) {
            return false;
        }
        BatchSchema that = (BatchSchema)obj;
        BatchSchema thatUpperCaseFields = new BatchSchema(that.getSelectionVectorMode(), that.getFields().stream().map(UPPERCASE_NAME).collect(Collectors.toList()));
        BatchSchema thisUpperCaseFields = new BatchSchema(this.getSelectionVectorMode(), this.getFields().stream().map(UPPERCASE_NAME).collect(Collectors.toList()));
        return thisUpperCaseFields.equals(thatUpperCaseFields);
    }

    private boolean compareFields(List<Field> srcFields, List<Field> tgtFields, boolean ignoreNullability, boolean allowMissingNullableFields) {
        if (srcFields == null && tgtFields == null) {
            return true;
        }
        if (!allowMissingNullableFields) {
            if (srcFields == null || tgtFields == null) {
                return false;
            }
            if (srcFields.size() != tgtFields.size()) {
                return false;
            }
        } else {
            if (null == srcFields) {
                srcFields = Collections.emptyList();
            }
            if (null == tgtFields) {
                tgtFields = Collections.emptyList();
            }
        }
        Preconditions.checkState(null != srcFields, "srcFields cannot be null");
        Preconditions.checkState(null != tgtFields, "tgtFields cannot be null");
        HashMap<String, Field> srcChildrenFields = new HashMap<String, Field>();
        for (Field srcField : srcFields) {
            srcChildrenFields.put(srcField.getName().toLowerCase(), srcField);
        }
        Set fieldsUniqueToSrc = allowMissingNullableFields ? srcChildrenFields.keySet().stream().map(String::toLowerCase).collect(Collectors.toSet()) : null;
        for (Field tgtChildField : tgtFields) {
            String childFieldName = tgtChildField.getName().toLowerCase();
            Field srcChildField = (Field)srcChildrenFields.get(childFieldName);
            if (srcChildField == null) {
                if (allowMissingNullableFields && tgtChildField.isNullable()) continue;
                return false;
            }
            if (null != fieldsUniqueToSrc) {
                fieldsUniqueToSrc.remove(childFieldName);
            }
            if (this.compareField(srcChildField, tgtChildField, ignoreNullability, allowMissingNullableFields)) continue;
            return false;
        }
        return null == fieldsUniqueToSrc || fieldsUniqueToSrc.isEmpty();
    }

    private boolean compareField(Field src, Field tgt, boolean ignoreNullability, boolean allowMissingNullableFields) {
        boolean metadataMismatch;
        Preconditions.checkArgument(src != null && tgt != null, "Unexpected state");
        if (!src.getName().toLowerCase().equalsIgnoreCase(tgt.getName().toLowerCase())) {
            return false;
        }
        CompleteType srcCompleteType = CompleteType.fromField(src);
        CompleteType tgtCompleteType = CompleteType.fromField(tgt);
        if (srcCompleteType.isUnion() && tgtCompleteType.isUnion()) {
            return this.compareFields(srcCompleteType.getChildren(), tgtCompleteType.getChildren(), ignoreNullability, allowMissingNullableFields);
        }
        boolean typesEqual = Objects.equals(src.getType(), tgt.getType());
        boolean bl = metadataMismatch = !typesEqual || !Objects.equals(src.getDictionary(), tgt.getDictionary()) || !Objects.equals(src.getMetadata(), tgt.getMetadata());
        if (!ignoreNullability) {
            metadataMismatch |= !Objects.equals(src.isNullable(), tgt.isNullable());
        }
        if (metadataMismatch) {
            return false;
        }
        return this.compareFields(src.getChildren(), tgt.getChildren(), ignoreNullability, allowMissingNullableFields);
    }

    public boolean insertsInto(BatchSchema that) {
        return this.compareFields(this.getFields(), that.getFields(), true, true) && Objects.equals((Object)this.selectionVectorMode, (Object)that.selectionVectorMode);
    }

    public boolean equalsTypesWithoutPositions(BatchSchema that) {
        return this.compareFields(this.getFields(), that.getFields(), false, false) && Objects.equals((Object)this.selectionVectorMode, (Object)that.selectionVectorMode);
    }

    public String diffTypesAndPositions(BatchSchema left) {
        int i;
        StringBuilder diffOutput = new StringBuilder();
        int size = Math.min(this.getFields().size(), left.getFields().size());
        for (i = 0; i < size; ++i) {
            Field leftField;
            CompleteType leftType;
            Field rightField = this.getFields().get(i);
            CompleteType rightType = TO_TYPES.apply(rightField);
            if (rightType.equals(leftType = TO_TYPES.apply(leftField = left.getFields().get(i)))) continue;
            diffOutput.append("Left side: ").append(leftField.getName()).append("::").append(leftType).append(" Right side: ").append(rightField.getName()).append("::").append(rightType).append("\n");
        }
        for (i = size; i < this.getFields().size(); ++i) {
            diffOutput.append("Right side: ").append(this.getFields().get(i).getName()).append("::").append(TO_TYPES.apply(this.getFields().get(i))).append(", not present in left side\n");
        }
        for (i = size; i < left.getFields().size(); ++i) {
            diffOutput.append("Left side: ").append(left.getFields().get(i).getName()).append("::").append(TO_TYPES.apply(left.getFields().get(i))).append(", not present in right side\n");
        }
        return diffOutput.toString();
    }

    public byte[] serialize() {
        FlatBufferBuilder builder = new FlatBufferBuilder();
        builder.finish(this.serialize(builder));
        return builder.sizedByteArray();
    }

    public ByteString toByteString() {
        return ByteString.copyFrom((byte[])this.serialize());
    }

    public static BatchSchema deserialize(byte[] bytes) {
        com.dremio.jdbc.shaded.org.apache.arrow.flatbuf.Schema schema = com.dremio.jdbc.shaded.org.apache.arrow.flatbuf.Schema.getRootAsSchema(ByteBuffer.wrap(bytes));
        Schema s2 = Schema.convertSchema(schema);
        return new BatchSchema(SelectionVectorMode.NONE, s2.getFields());
    }

    public static BatchSchema deserialize(ByteString bytes) {
        com.dremio.jdbc.shaded.org.apache.arrow.flatbuf.Schema schema = com.dremio.jdbc.shaded.org.apache.arrow.flatbuf.Schema.getRootAsSchema(bytes.asReadOnlyByteBuffer());
        Schema s2 = Schema.convertSchema(schema);
        return new BatchSchema(SelectionVectorMode.NONE, s2.getFields());
    }

    public int serialize(FlatBufferBuilder builder) {
        Preconditions.checkArgument(this.selectionVectorMode == SelectionVectorMode.NONE, "Serialization is only allowed for SelectionVectorMode.NONE. This was in SelectionVectorMode.%s", (Object)this.selectionVectorMode.name());
        Schema schema = new Schema(this.getFields());
        return schema.getSchema(builder);
    }

    public void materializeVectors(List<? extends BasePath> columns, OutputMutator mutator) {
        Preconditions.checkNotNull(columns, "A scan's column selection cannot be null.");
        HashSet<String> selectedColumns = new HashSet<String>();
        for (BasePath basePath : columns) {
            selectedColumns.add(basePath.getRootSegment().getNameSegment().getPath());
        }
        for (Field field : this) {
            if (columns != null && !selectedColumns.contains("*") && !selectedColumns.contains(field.getName())) continue;
            mutator.addField(field, CompleteType.fromField(field).getValueVectorClass());
        }
    }

    public static int estimateRecordSize(Map<String, ValueVector> vectorMap, int listSizeEstimate, int mapSizeEstimate, int varFieldSizeEstimate) {
        int estimatedRecordSize = 0;
        for (ValueVector v : vectorMap.values()) {
            estimatedRecordSize += BatchSchema.estimateFieldSize(v.getField(), listSizeEstimate, mapSizeEstimate, varFieldSizeEstimate);
        }
        return estimatedRecordSize;
    }

    public int estimateRecordSize(int listSizeEstimate, int mapSizeEstimate, int varFieldSizeEstimate) {
        int estimatedRecordSize = 0;
        for (Field column : this) {
            estimatedRecordSize += BatchSchema.estimateFieldSize(column, listSizeEstimate, mapSizeEstimate, varFieldSizeEstimate);
        }
        return estimatedRecordSize;
    }

    private static int estimateFieldSize(Field field, int listSizeEstimate, int mapSizeEstimate, int varFieldSizeEstimate) {
        int estimatedFieldSize;
        ArrowType.ArrowTypeID typeID = field.getType().getTypeID();
        switch (typeID) {
            case Int: {
                estimatedFieldSize = ((ArrowType.Int)field.getType()).getBitWidth() / 8;
                break;
            }
            case FloatingPoint: {
                if (((ArrowType.FloatingPoint)field.getType()).getPrecision() == FloatingPointPrecision.DOUBLE) {
                    estimatedFieldSize = 8;
                    break;
                }
                estimatedFieldSize = 4;
                break;
            }
            case Struct: {
                int childrenSize = 0;
                if (!field.getChildren().isEmpty()) {
                    for (Field child : field.getChildren()) {
                        childrenSize += BatchSchema.estimateFieldSize(child, listSizeEstimate, mapSizeEstimate, varFieldSizeEstimate);
                    }
                    estimatedFieldSize = childrenSize;
                    break;
                }
                estimatedFieldSize = varFieldSizeEstimate;
                break;
            }
            case List: {
                if (!field.getChildren().isEmpty()) {
                    int elemSize = BatchSchema.estimateFieldSize(field.getChildren().get(0), listSizeEstimate, mapSizeEstimate, varFieldSizeEstimate);
                    estimatedFieldSize = elemSize * listSizeEstimate;
                    break;
                }
                estimatedFieldSize = varFieldSizeEstimate;
                break;
            }
            case FixedSizeList: {
                int fixedListSize = ((ArrowType.FixedSizeList)field.getType()).getListSize();
                int elemSize = BatchSchema.estimateFieldSize(field.getChildren().get(0), listSizeEstimate, mapSizeEstimate, varFieldSizeEstimate);
                estimatedFieldSize = elemSize * fixedListSize;
                break;
            }
            case Union: {
                if (!field.getChildren().isEmpty()) {
                    int size = 0;
                    for (Field child : field.getChildren()) {
                        size += BatchSchema.estimateFieldSize(child, listSizeEstimate, mapSizeEstimate, varFieldSizeEstimate);
                    }
                    estimatedFieldSize = size / field.getChildren().size();
                    break;
                }
                estimatedFieldSize = 0;
                break;
            }
            case Map: {
                if (!field.getChildren().isEmpty()) {
                    int elemSize = BatchSchema.estimateFieldSize(field.getChildren().get(0), listSizeEstimate, mapSizeEstimate, varFieldSizeEstimate);
                    estimatedFieldSize = elemSize * mapSizeEstimate;
                    break;
                }
                estimatedFieldSize = varFieldSizeEstimate;
                break;
            }
            case Utf8: 
            case Binary: {
                estimatedFieldSize = varFieldSizeEstimate;
                break;
            }
            case Bool: {
                estimatedFieldSize = 1;
                break;
            }
            case Decimal: {
                estimatedFieldSize = 16;
                break;
            }
            case Date: {
                estimatedFieldSize = 8;
                break;
            }
            case Time: {
                estimatedFieldSize = 4;
                break;
            }
            case Timestamp: {
                estimatedFieldSize = 8;
                break;
            }
            case Interval: {
                estimatedFieldSize = 8;
                break;
            }
            default: {
                estimatedFieldSize = 4;
            }
        }
        return estimatedFieldSize;
    }

    public int getTotalFieldCount() {
        int count = 0;
        for (Field f : this) {
            count = BatchSchema.countFields(f, count);
        }
        return count;
    }

    private static int countFields(Field f, int count) {
        if (f.getChildren().isEmpty()) {
            ++count;
        } else {
            for (Field child : f.getChildren()) {
                count = BatchSchema.countFields(child, count);
            }
        }
        return count;
    }

    public boolean isDeprecatedText() {
        if (this.getFieldCount() != 1) {
            return false;
        }
        Field f = this.getFields().get(0);
        if (!"columns".equals(f.getName())) {
            return false;
        }
        CompleteType type = CompleteType.fromField(f);
        if (!type.isList()) {
            return false;
        }
        CompleteType child = CompleteType.fromField((Field)type.getChildren().get(0));
        return child.isVariableWidthScalar();
    }

    public BatchSchema handleUnions(SupportsTypeCoercionsAndUpPromotions coercionRulesSet) {
        if (this.hasUnions()) {
            return this.mergeWithUpPromotion(this, coercionRulesSet);
        }
        return this;
    }

    public boolean hasUnions() {
        return BatchSchema.hasUnions(this.getFields());
    }

    public static boolean hasUnions(List<Field> fields) {
        for (Field field : fields) {
            if (field.getType().getTypeID() != ArrowType.ArrowTypeID.Union && !BatchSchema.hasUnions(field.getChildren())) continue;
            return true;
        }
        return false;
    }

    public BatchSchema merge(BatchSchema schemaToMergeIntoThis) {
        ImmutableList<Field> original = ImmutableList.copyOf(this);
        ImmutableList<Field> newlyObserved = ImmutableList.copyOf(schemaToMergeIntoThis);
        return new BatchSchema(SelectionVectorMode.NONE, BatchSchema.mergeFieldLists(original, newlyObserved));
    }

    public BatchSchema mergeWithUpPromotion(BatchSchema fileSchema, SupportsTypeCoercionsAndUpPromotions coercionRulesSet) {
        ImmutableList<Field> fileFields = ImmutableList.copyOf(fileSchema);
        return new BatchSchema(SelectionVectorMode.NONE, this.mergeWithUpPromotion(fileFields, coercionRulesSet));
    }

    public BatchSchema mergeWithRetainOld(BatchSchema toMerge) {
        LinkedHashMap<String, Field> alreadyExisting = new LinkedHashMap<String, Field>();
        for (Field field : this.getFields()) {
            String dottedName = field.getName().toLowerCase();
            Field temp = field;
            while (!temp.getChildren().isEmpty()) {
                dottedName = dottedName.concat("." + temp.getChildren().get(0).getName().toLowerCase());
                temp = temp.getChildren().get(0);
            }
            alreadyExisting.put(dottedName, field);
        }
        LinkedHashMap<String, Field> newFields = new LinkedHashMap<String, Field>();
        for (Field field : toMerge.getFields()) {
            String dottedName = field.getName().toLowerCase();
            Field temp = field;
            while (!temp.getChildren().isEmpty()) {
                dottedName = dottedName.concat("." + temp.getChildren().get(0).getName().toLowerCase());
                temp = temp.getChildren().get(0);
            }
            newFields.put(dottedName, field);
        }
        List<Field> list = Maps.difference(newFields, alreadyExisting).entriesOnlyOnLeft().values().stream().collect(Collectors.toList());
        list.addAll(this.getFields());
        return new BatchSchema(list);
    }

    public BatchSchema difference(BatchSchema schema) {
        List<Field> leftOnlyFields = BatchSchema.difference(this.getFields(), schema.getFields());
        return new BatchSchema(leftOnlyFields);
    }

    public static List<Field> difference(List<Field> left, List<Field> right) {
        ArrayList<Field> leftOnly = new ArrayList<Field>();
        ImmutableListMultimap<String, Field> rightMap = Multimaps.index(right, f -> f.getName().toLowerCase());
        for (Field leftField : left) {
            Collection rightFieldsWithSameName = rightMap.get(leftField.getName().toLowerCase());
            if (rightFieldsWithSameName.isEmpty()) {
                leftOnly.add(leftField);
                continue;
            }
            Field firstOnRight = (Field)rightFieldsWithSameName.iterator().next();
            if (!leftField.getType().isComplex() || !firstOnRight.getType().isComplex() || leftField.getType().getTypeID() != firstOnRight.getType().getTypeID()) continue;
            List<Field> rightFieldChildren = rightFieldsWithSameName.stream().flatMap(f -> f.getChildren().stream()).collect(Collectors.toList());
            List<Field> leftOnlyChildren = BatchSchema.difference(leftField.getChildren(), rightFieldChildren);
            if (leftOnlyChildren.isEmpty()) continue;
            leftOnly.add(new Field(leftField.getName(), leftField.getFieldType(), leftOnlyChildren));
        }
        return leftOnly;
    }

    private List<Field> mergeWithUpPromotion(List<Field> fileFields, SupportsTypeCoercionsAndUpPromotions coercionRulesSet) {
        return CompleteType.mergeFieldListsWithUpPromotionOrCoercion(ImmutableList.copyOf(this), fileFields, coercionRulesSet);
    }

    private static List<Field> mergeFieldLists(List<Field> original, List<Field> newlyObserved) {
        LinkedHashMap<String, Field> secondFieldMap = new LinkedHashMap<String, Field>();
        ArrayList<Field> mergedList = new ArrayList<Field>();
        for (Field field : original) {
            secondFieldMap.put(field.getName().toLowerCase(), field);
        }
        for (Field field : newlyObserved) {
            Field matchingField = (Field)secondFieldMap.remove(field.getName().toLowerCase());
            if (matchingField != null) {
                CompleteType mergedType = null;
                CompleteType type1 = CompleteType.fromField(field);
                CompleteType type2 = CompleteType.fromField(matchingField);
                try {
                    mergedType = type1.merge(type2);
                }
                catch (UnsupportedOperationException e) {
                    StringBuilder stringBuilder = new StringBuilder("Mixed types ");
                    stringBuilder.append(type1).append(" , ").append(type2).append(" for field ").append(field.getName()).append(" are not supported.");
                    throw UserException.unsupportedError().message(stringBuilder.toString()).build(logger);
                }
                mergedList.add(mergedType.toField(field.getName()));
                continue;
            }
            mergedList.add(field);
        }
        for (Field field : secondFieldMap.values()) {
            mergedList.add(field);
        }
        return mergedList;
    }

    public static BatchSchema of(Field ... fields) {
        return new BatchSchema(SelectionVectorMode.NONE, ImmutableList.copyOf(fields));
    }

    public Optional<Field> findFieldIgnoreCase(String fieldName) {
        return this.getFields().stream().filter(field -> field.getName().equalsIgnoreCase(fieldName)).findFirst();
    }

    private static void validateUserDefinedFieldTypes(List<Field> srcFields, List<Field> userFields, SupportsTypeCoercionsAndUpPromotions coercionRulesSet) {
        LinkedHashMap<String, Field> userFieldsMap = new LinkedHashMap<String, Field>();
        for (Field userField : userFields) {
            userFieldsMap.put(userField.getName().toLowerCase(), userField);
        }
        for (Field src : srcFields) {
            Field user = (Field)userFieldsMap.get(src.getName().toLowerCase());
            if (user == null) continue;
            try {
                BatchSchema.validateUserDefinedFieldTypes(src, user, coercionRulesSet);
            }
            catch (NoSupportedUpPromotionOrCoercionException ex) {
                ex.addColumnName(user.getName());
                throw ex;
            }
        }
    }

    private static void validateUserDefinedFieldTypes(Field srcField, Field userField, SupportsTypeCoercionsAndUpPromotions coercionRulesSet) {
        boolean incompatibleComplexToComplex;
        CompleteType srcType = CompleteType.fromField(srcField);
        CompleteType userType = CompleteType.fromField(userField);
        if (srcType.isUnion()) {
            srcType = CompleteType.removeUnions(srcType, coercionRulesSet);
        }
        if (userType.isUnion()) {
            userType = CompleteType.removeUnions(userType, coercionRulesSet);
        }
        boolean incompatibleScalarToScalar = srcType.isScalar() && userType.isScalar() && !srcType.equals(userType) && !coercionRulesSet.getUpPromotionRules().getResultantType(srcType, userType).isPresent() && !coercionRulesSet.getTypeCoercionRules().getResultantType(srcType, userType).isPresent();
        boolean incompatibleScalarToComplex = srcType.isScalar() && userType.isComplex();
        boolean incompatibleComplexToScalar = srcType.isComplex() && userType.isScalar() && (userType.getType().getTypeID() != ArrowType.ArrowTypeID.Utf8 || !coercionRulesSet.isComplexToVarcharCoercionSupported());
        boolean bl = incompatibleComplexToComplex = srcType.isComplex() && userType.isComplex() && userType.getType().getTypeID() != srcType.getType().getTypeID();
        if (incompatibleScalarToScalar || incompatibleScalarToComplex || incompatibleComplexToScalar || incompatibleComplexToComplex) {
            throw new NoSupportedUpPromotionOrCoercionException(srcType, userType);
        }
        if (srcType.isStruct()) {
            BatchSchema.validateUserDefinedFieldTypes(srcType.getChildren(), userType.getChildren(), coercionRulesSet);
        } else if (srcType.isList() || srcType.isMap()) {
            BatchSchema.validateUserDefinedFieldTypes(srcType.getOnlyChild(), userType.getOnlyChild(), coercionRulesSet);
        }
    }

    public BatchSchema applyUserDefinedSchemaAfterSchemaLearning(BatchSchema newSchema, List<Field> droppedColumns, List<Field> updatedColumns, boolean isSchemaLearningDisabledByUser, boolean isUserDefinedSchemaEnabled, String filePath, List<String> tableSchemaPath, SupportsTypeCoercionsAndUpPromotions coercionRulesSet) {
        try {
            if (isUserDefinedSchemaEnabled && isSchemaLearningDisabledByUser) {
                BatchSchema.validateUserDefinedFieldTypes(newSchema.getFields(), this.getFields(), coercionRulesSet);
                return this;
            }
            Set updatedFieldNames = Streams.concat(droppedColumns.stream(), updatedColumns.stream()).map(f -> f.getName().toLowerCase()).collect(Collectors.toSet());
            Map<Boolean, List<Field>> partitionedNewFields = newSchema.getFields().stream().collect(Collectors.partitioningBy(f -> updatedFieldNames.contains(f.getName().toLowerCase())));
            List<Field> newFieldsWithUpdates = partitionedNewFields.get(true);
            List<Field> newFieldsWithoutUpdates = partitionedNewFields.get(false);
            BatchSchema finalSchema = this.mergeWithUpPromotion(new BatchSchema(newFieldsWithoutUpdates), coercionRulesSet);
            if (!newFieldsWithUpdates.isEmpty()) {
                BatchSchema.validateUserDefinedFieldTypes(newFieldsWithUpdates, this.getFields(), coercionRulesSet);
            }
            return finalSchema.removeNullFields();
        }
        catch (NoSupportedUpPromotionOrCoercionException e) {
            e.addDatasetPath(tableSchemaPath);
            e.addFilePath(filePath);
            throw UserException.unsupportedError(e).message(e.getMessage()).buildSilently();
        }
    }

    public Optional<BatchSchema> subset(List<String> fieldNames) {
        if (fieldNames.isEmpty()) {
            return Optional.empty();
        }
        HashSet missingColumns = new HashSet();
        SchemaBuilder schemaBuilder = BatchSchema.newBuilder();
        fieldNames.forEach(f -> {
            Optional<Field> fieldInTable = this.findFieldIgnoreCase((String)f);
            if (fieldInTable.isPresent()) {
                schemaBuilder.addField(fieldInTable.get());
            } else {
                missingColumns.add(f);
            }
        });
        if (!missingColumns.isEmpty()) {
            throw UserException.validationError().message("Specified column(s) %s not found in schema.", missingColumns).buildSilently();
        }
        return Optional.of(schemaBuilder.build());
    }

    public BatchSchema dropFields(List<List<String>> pathsToDrop) {
        BatchSchema newSchema = new BatchSchema(this.getFields());
        for (List<String> path : pathsToDrop) {
            newSchema = newSchema.dropField(path);
        }
        return newSchema;
    }

    public BatchSchema addColumns(List<Field> columnsToAdd) {
        LinkedHashMap<String, Field> originalFieldMap = new LinkedHashMap<String, Field>();
        for (Field field : this.getFields()) {
            originalFieldMap.put(field.getName().toLowerCase(), field);
        }
        BatchSchema newSchema = new BatchSchema(this.getFields());
        for (Field fieldToAdd : columnsToAdd) {
            this.addFieldToSchema(originalFieldMap, fieldToAdd);
        }
        return new BatchSchema(originalFieldMap.values().stream().collect(Collectors.toList()));
    }

    public BatchSchema addColumn(Field newField) {
        LinkedHashMap<String, Field> originalFieldMap = new LinkedHashMap<String, Field>();
        for (Field field : this.getFields()) {
            originalFieldMap.put(field.getName().toLowerCase(), field);
        }
        this.addFieldToSchema(originalFieldMap, newField);
        return new BatchSchema(originalFieldMap.values().stream().collect(Collectors.toList()));
    }

    private void addFieldToSchema(Map<String, Field> originalFieldMap, Field newField) {
        ArrayList<String> fieldPaths = new ArrayList<String>();
        Field tempField = newField;
        fieldPaths.add(tempField.getName().toLowerCase());
        while (!tempField.getChildren().isEmpty()) {
            fieldPaths.add(tempField.getChildren().get(0).getName().toLowerCase());
            tempField = tempField.getChildren().get(0);
        }
        Field field = originalFieldMap.get(newField.getName().toLowerCase());
        if (!newField.getType().isComplex() || !originalFieldMap.containsKey(fieldPaths.get(0))) {
            originalFieldMap.put((String)fieldPaths.get(0), newField);
        } else {
            Field newType = new Field(field.getName(), field.getFieldType(), this.addComplexTypes(field.getChildren(), fieldPaths, 1, newField.getChildren().get(0)));
            originalFieldMap.replace((String)fieldPaths.get(0), newType);
        }
    }

    private BatchSchema dropField(List<String> path) {
        path = path.stream().map(String::toLowerCase).collect(Collectors.toList());
        LinkedHashMap<String, Field> originalFieldMap = new LinkedHashMap<String, Field>();
        for (Field field : this.getFields()) {
            originalFieldMap.put(field.getName().toLowerCase(), field);
        }
        Field field = (Field)originalFieldMap.get(path.get(0));
        if (field == null) {
            return new BatchSchema(originalFieldMap.values().stream().collect(Collectors.toList()));
        }
        if (path.size() == 1) {
            originalFieldMap.remove(path.get(0));
        } else {
            Field newType = new Field(field.getName(), field.getFieldType(), this.removeComplexTypes(field.getChildren(), path, 1));
            originalFieldMap.replace(path.get(0), newType);
        }
        return new BatchSchema(originalFieldMap.values().stream().collect(Collectors.toList()));
    }

    public BatchSchema changeTypeRecursive(Field newType) {
        return this.changeType(newType, true);
    }

    public BatchSchema changeTypeTopLevel(Field newType) {
        return this.changeType(newType, false);
    }

    public BatchSchema changeType(Field newType, boolean isRecursive) {
        LinkedHashMap<String, Field> originalFieldMap = new LinkedHashMap<String, Field>();
        for (Field field : this.getFields()) {
            originalFieldMap.put(field.getName().toLowerCase(), field);
        }
        if (!isRecursive) {
            originalFieldMap.replace(newType.getName().toLowerCase(), newType);
        } else {
            this.changeTypeOfField(originalFieldMap, newType);
        }
        return new BatchSchema(originalFieldMap.values().stream().collect(Collectors.toList()));
    }

    private void changeTypeOfField(Map<String, Field> originalFieldMap, Field newField) {
        if (!newField.getType().isComplex() || newField.getType().isComplex() && originalFieldMap.get(newField.getName()) != null && !originalFieldMap.get(newField.getName()).getType().isComplex()) {
            originalFieldMap.replace(newField.getName().toLowerCase(), newField);
            return;
        }
        Field field = originalFieldMap.get(newField.getName().toLowerCase());
        LinkedHashMap<String, Field> childFieldMap = new LinkedHashMap<String, Field>();
        if (field == null) {
            return;
        }
        for (Field child : field.getChildren()) {
            childFieldMap.put(child.getName().toLowerCase(), child);
        }
        for (Field newChild : newField.getChildren()) {
            this.changeTypeOfField(childFieldMap, newChild);
        }
        Field newFinalType = new Field(field.getName(), newField.getFieldType(), childFieldMap.values().stream().collect(Collectors.toList()));
        originalFieldMap.replace(field.getName().toLowerCase(), newFinalType);
    }

    public BatchSchema dropField(Field field) {
        BatchSchema newSchema = new BatchSchema(this.getFields());
        ArrayList<String> fieldPaths = new ArrayList<String>();
        fieldPaths.add(field.getName());
        while (!field.getChildren().isEmpty()) {
            Preconditions.checkArgument(field.getChildren().size() == 1, "Cannot drop a field with more than once children");
            fieldPaths.add(field.getChildren().get(0).getName());
            field = field.getChildren().get(0);
        }
        return this.dropField(fieldPaths);
    }

    public BatchSchema dropField(String name) {
        name = name.toLowerCase();
        LinkedHashMap<String, Field> originalFieldMap = new LinkedHashMap<String, Field>();
        for (Field field : this.getFields()) {
            originalFieldMap.put(field.getName().toLowerCase(), field);
        }
        originalFieldMap.remove(name);
        return new BatchSchema(originalFieldMap.values().stream().collect(Collectors.toList()));
    }

    private List<Field> removeComplexTypes(List<Field> fields, List<String> nameSegments, int index) {
        String name = nameSegments.get(index);
        ArrayList<Field> newFieldList = new ArrayList<Field>(fields);
        if (index == nameSegments.size() - 1) {
            for (Field f : fields) {
                if (!f.getName().equalsIgnoreCase(name)) continue;
                newFieldList.remove(f);
                return newFieldList;
            }
        }
        for (int i = 0; i < fields.size(); ++i) {
            if (!fields.get(i).getName().equalsIgnoreCase(name)) continue;
            Field originalField = fields.get(i);
            Field newField = new Field(originalField.getName(), originalField.getFieldType(), this.removeComplexTypes(originalField.getChildren(), nameSegments, ++index));
            newFieldList.set(i, newField);
        }
        return newFieldList;
    }

    private List<Field> addComplexTypes(List<Field> fields, List<String> nameSegments, int index, Field finalType) {
        String name = nameSegments.get(index);
        ArrayList<Field> newFieldList = new ArrayList<Field>(fields);
        if (index == nameSegments.size() - 1) {
            newFieldList.add(finalType);
            return newFieldList;
        }
        for (int i = 0; i < fields.size(); ++i) {
            if (!fields.get(i).getName().equalsIgnoreCase(name)) continue;
            Field originalField = fields.get(i);
            Field newField = new Field(originalField.getName(), originalField.getFieldType(), this.addComplexTypes(originalField.getChildren(), nameSegments, ++index, finalType.getChildren().get(0)));
            newFieldList.set(i, newField);
        }
        return newFieldList;
    }

    public static enum SelectionVectorMode {
        NONE(-1, false),
        TWO_BYTE(2, true),
        FOUR_BYTE(4, true);

        public final boolean hasSelectionVector;
        public final int size;
        public static final SelectionVectorMode[] DEFAULT;
        public static final SelectionVectorMode[] NONE_AND_TWO;
        public static final SelectionVectorMode[] NONE_AND_FOUR;
        public static final SelectionVectorMode[] ALL;

        private SelectionVectorMode(int size, boolean hasSelectionVector) {
            this.size = size;
            this.hasSelectionVector = hasSelectionVector;
        }

        static {
            DEFAULT = new SelectionVectorMode[]{NONE};
            NONE_AND_TWO = new SelectionVectorMode[]{NONE, TWO_BYTE};
            NONE_AND_FOUR = new SelectionVectorMode[]{NONE, FOUR_BYTE};
            ALL = new SelectionVectorMode[]{NONE, TWO_BYTE, FOUR_BYTE};
        }
    }

    public static class Ser
    extends JsonSerializer<BatchSchema> {
        @Override
        public void serialize(BatchSchema value, JsonGenerator gen, SerializerProvider serializers) throws IOException, JsonProcessingException {
            gen.writeBinary(value.serialize());
        }
    }

    public static class De
    extends JsonDeserializer<BatchSchema> {
        @Override
        public BatchSchema deserialize(JsonParser p, DeserializationContext ctxt) throws IOException, JsonProcessingException {
            return BatchSchema.deserialize(p.getBinaryValue());
        }
    }
}

