/*
 * Decompiled with CFR 0.152.
 */
package com.dremio.jdbc.shaded.com.dremio.exec.record;

import com.dremio.jdbc.shaded.com.dremio.exec.record.BatchSchema;
import com.dremio.jdbc.shaded.com.dremio.exec.record.VectorAccessible;
import com.dremio.jdbc.shaded.com.dremio.exec.record.VectorContainer;
import com.dremio.jdbc.shaded.com.dremio.exec.record.VectorWrapper;
import com.dremio.jdbc.shaded.com.dremio.exec.record.selection.SelectionVector2;
import com.dremio.jdbc.shaded.com.google.common.collect.Lists;
import com.dremio.jdbc.shaded.org.apache.arrow.memory.BufferAllocator;
import com.dremio.jdbc.shaded.org.apache.arrow.vector.ValueVector;
import com.dremio.jdbc.shaded.org.slf4j.Logger;
import com.dremio.jdbc.shaded.org.slf4j.LoggerFactory;
import java.util.ArrayList;
import java.util.List;

public class RecordBatchData
implements AutoCloseable {
    static final Logger logger = LoggerFactory.getLogger(RecordBatchData.class);
    private SelectionVector2 sv2;
    private VectorContainer container = new VectorContainer();

    protected RecordBatchData(List<? extends ValueVector> vectors, int recordCount) {
        this.container.addCollection(new ArrayList<ValueVector>(vectors));
        this.container.setAllCount(recordCount);
        this.container.buildSchema();
    }

    public RecordBatchData(VectorAccessible batch, BufferAllocator allocator) {
        this.sv2 = batch.getSchema().getSelectionVectorMode() == BatchSchema.SelectionVectorMode.TWO_BYTE ? batch.getSelectionVector2().clone() : null;
        for (VectorWrapper v : batch) {
            if (!v.isHyper()) continue;
            throw new UnsupportedOperationException("Record batch data can't be created based on a hyper batch.");
        }
        this.container.transferFrom(batch, allocator);
    }

    public int getRecordCount() {
        return this.container.getRecordCount();
    }

    public List<ValueVector> getVectors() {
        ArrayList<ValueVector> vectors = Lists.newArrayList();
        for (VectorWrapper<?> w : this.container) {
            vectors.add((ValueVector)w.getValueVector());
        }
        return vectors;
    }

    public SelectionVector2 getSv2() {
        return this.sv2;
    }

    public VectorAccessible getVectorAccessible() {
        return this.container;
    }

    @Deprecated
    public void clear() {
        this.close();
    }

    @Override
    public void close() {
        if (this.sv2 != null) {
            this.sv2.clear();
        }
        this.container.clear();
    }

    public BatchSchema getSchema() {
        return this.container.getSchema();
    }
}

