/*
 * Decompiled with CFR 0.152.
 */
package com.dremio.jdbc.shaded.com.dremio.exec.record;

import com.dremio.jdbc.shaded.com.dremio.exec.record.RecordBatchData;
import com.dremio.jdbc.shaded.com.google.common.base.Preconditions;

public final class RecordBatchHolder
implements AutoCloseable {
    private final RecordBatchData data;
    private final int start;
    private final int end;

    private RecordBatchHolder(RecordBatchData data, int start, int end) {
        this.data = data;
        this.start = start;
        this.end = end;
    }

    public static RecordBatchHolder newRecordBatchHolder(RecordBatchData data, int start, int end) {
        Preconditions.checkArgument(start >= 0, "Invalid start index (%s) in RecordBatchData (of size (%s))", start, data.getRecordCount());
        Preconditions.checkArgument(end <= data.getRecordCount(), "Invalid end index (%s) in RecordBatchData (of size (%s))", end, data.getRecordCount());
        Preconditions.checkArgument(start <= end, "Invalid range indices. Start (%s), End (%s), Batch size (%s)", (Object)start, (Object)end, (Object)data.getRecordCount());
        return new RecordBatchHolder(data, start, end);
    }

    public RecordBatchData getData() {
        return this.data;
    }

    public int getStart() {
        return this.start;
    }

    public int getEnd() {
        return this.end;
    }

    public int size() {
        return this.end - this.start;
    }

    @Override
    public void close() throws Exception {
        this.data.close();
    }
}

