/*
 * Decompiled with CFR 0.152.
 */
package com.dremio.jdbc.shaded.com.dremio.exec.record;

import com.dremio.jdbc.shaded.com.dremio.common.StackTrace;
import com.dremio.jdbc.shaded.com.dremio.common.expression.BasePath;
import com.dremio.jdbc.shaded.com.dremio.exec.expr.TypeHelper;
import com.dremio.jdbc.shaded.com.dremio.exec.proto.UserBitShared;
import com.dremio.jdbc.shaded.com.dremio.exec.record.BatchSchema;
import com.dremio.jdbc.shaded.com.dremio.exec.record.TypedFieldId;
import com.dremio.jdbc.shaded.com.dremio.exec.record.VectorAccessible;
import com.dremio.jdbc.shaded.com.dremio.exec.record.VectorContainer;
import com.dremio.jdbc.shaded.com.dremio.exec.record.VectorWrapper;
import com.dremio.jdbc.shaded.com.dremio.exec.record.WritableBatch;
import com.dremio.jdbc.shaded.com.dremio.exec.record.selection.SelectionVector2;
import com.dremio.jdbc.shaded.com.dremio.exec.record.selection.SelectionVector4;
import com.dremio.jdbc.shaded.com.google.common.base.Preconditions;
import com.dremio.jdbc.shaded.com.google.common.collect.Maps;
import com.dremio.jdbc.shaded.org.apache.arrow.memory.ArrowBuf;
import com.dremio.jdbc.shaded.org.apache.arrow.memory.BufferAllocator;
import com.dremio.jdbc.shaded.org.apache.arrow.vector.AllocationHelper;
import com.dremio.jdbc.shaded.org.apache.arrow.vector.ValueVector;
import com.dremio.jdbc.shaded.org.apache.arrow.vector.types.SerializedFieldHelper;
import com.dremio.jdbc.shaded.org.apache.arrow.vector.types.pojo.Field;
import com.dremio.jdbc.shaded.org.slf4j.Logger;
import com.dremio.jdbc.shaded.org.slf4j.LoggerFactory;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;

public class RecordBatchLoader
implements VectorAccessible,
Iterable<VectorWrapper<?>>,
AutoCloseable {
    private static final Logger logger = LoggerFactory.getLogger(RecordBatchLoader.class);
    private final BufferAllocator allocator;
    private VectorContainer container;
    private int valueCount;
    private BatchSchema schema;

    public RecordBatchLoader(BufferAllocator allocator) {
        this.allocator = Preconditions.checkNotNull(allocator);
        this.container = new VectorContainer();
    }

    public RecordBatchLoader(BufferAllocator allocator, VectorContainer container) {
        this.allocator = Preconditions.checkNotNull(allocator);
        this.container = container;
        this.schema = container.getSchema();
    }

    public RecordBatchLoader(BufferAllocator allocator, BatchSchema schema) {
        this.allocator = Preconditions.checkNotNull(allocator);
        this.schema = schema;
        this.container = VectorContainer.create(allocator, schema);
    }

    public boolean load(UserBitShared.RecordBatchDef def, ArrowBuf buf) {
        if (logger.isTraceEnabled()) {
            logger.trace("Loading record batch with def {} and data {}", (Object)def, (Object)buf);
            logger.trace("Load, ThreadID: {}\n{}", (Object)Thread.currentThread().getId(), (Object)new StackTrace());
        }
        this.container.zeroVectors();
        this.valueCount = def.getRecordCount();
        boolean schemaChanged = this.schema == null;
        HashMap<String, ?> oldFields = Maps.newHashMap();
        for (VectorWrapper<?> wrapper : this.container) {
            Object vector = wrapper.getValueVector();
            oldFields.put(vector.getField().getName(), vector);
        }
        VectorContainer newVectors = new VectorContainer();
        try {
            List<UserBitShared.SerializedField> fields = def.getFieldList();
            int bufOffset = 0;
            Iterator<UserBitShared.SerializedField> iterator = fields.iterator();
            while (iterator.hasNext()) {
                UserBitShared.SerializedField field = iterator.next();
                Field fieldDef = SerializedFieldHelper.create(field);
                ValueVector vector = (ValueVector)oldFields.remove(fieldDef.getName());
                if (vector == null) {
                    schemaChanged = true;
                    vector = TypeHelper.getNewVector(fieldDef, this.allocator);
                } else if (!vector.getField().getType().equals(fieldDef.getType())) {
                    vector.clear();
                    schemaChanged = true;
                    vector = TypeHelper.getNewVector(fieldDef, this.allocator);
                }
                if (field.getValueCount() == 0) {
                    AllocationHelper.allocate(vector, 0, 0, 0);
                } else {
                    TypeHelper.load(vector, field, buf.slice(bufOffset, field.getBufferLength()));
                }
                bufOffset += field.getBufferLength();
                newVectors.add(vector);
            }
            newVectors.buildSchema();
            this.schema = newVectors.getSchema();
            if (!oldFields.isEmpty()) {
                schemaChanged = true;
            }
            if (schemaChanged) {
                this.container = newVectors;
            }
        }
        catch (Throwable cause) {
            for (VectorWrapper<?> wrapper : newVectors) {
                wrapper.getValueVector().clear();
            }
            throw cause;
        }
        finally {
            if (!oldFields.isEmpty()) {
                for (ValueVector vector : oldFields.values()) {
                    vector.clear();
                }
            }
        }
        this.container.setRecordCount(def.getRecordCount());
        return schemaChanged;
    }

    @Override
    public TypedFieldId getValueVectorId(BasePath path) {
        return this.container.getValueVectorId(path);
    }

    @Override
    public int getRecordCount() {
        return this.valueCount;
    }

    @Override
    public <T extends ValueVector> VectorWrapper<T> getValueAccessorById(Class<T> clazz, int ... ids) {
        return this.container.getValueAccessorById(clazz, ids);
    }

    public WritableBatch getWritableBatch() {
        boolean isSV2 = this.schema.getSelectionVectorMode() == BatchSchema.SelectionVectorMode.TWO_BYTE;
        return WritableBatch.getBatchNoHVWrap(this.valueCount, this.container, isSV2);
    }

    @Override
    public Iterator<VectorWrapper<?>> iterator() {
        return this.container.iterator();
    }

    @Override
    public SelectionVector2 getSelectionVector2() {
        throw new UnsupportedOperationException();
    }

    @Override
    public SelectionVector4 getSelectionVector4() {
        throw new UnsupportedOperationException();
    }

    @Override
    public BatchSchema getSchema() {
        return this.schema;
    }

    public void resetRecordCount() {
        this.valueCount = 0;
    }

    public void clear() {
        this.close();
    }

    @Override
    public void close() {
        this.container.clear();
        this.resetRecordCount();
    }
}

