/*
 * Decompiled with CFR 0.152.
 */
package com.dremio.jdbc.shaded.com.dremio.exec.record;

import com.dremio.jdbc.shaded.com.dremio.exec.exception.SchemaChangeException;
import com.dremio.jdbc.shaded.com.dremio.exec.proto.UserBitShared;
import com.dremio.jdbc.shaded.com.dremio.exec.record.BatchSchema;
import com.dremio.jdbc.shaded.com.google.common.collect.Lists;
import com.dremio.jdbc.shaded.org.apache.arrow.vector.types.SerializedFieldHelper;
import com.dremio.jdbc.shaded.org.apache.arrow.vector.types.pojo.Field;
import java.util.ArrayList;
import java.util.List;

public class SchemaBuilder {
    private List<Field> fields = Lists.newArrayList();
    private BatchSchema.SelectionVectorMode selectionVectorMode = BatchSchema.SelectionVectorMode.NONE;

    SchemaBuilder() {
    }

    public SchemaBuilder setSelectionVectorMode(BatchSchema.SelectionVectorMode selectionVectorMode) {
        this.selectionVectorMode = selectionVectorMode;
        return this;
    }

    public SchemaBuilder addFields(Iterable<Field> fields) {
        for (Field f : fields) {
            this.addField(f);
        }
        return this;
    }

    public SchemaBuilder addSerializedFields(Iterable<UserBitShared.SerializedField> fields) {
        for (UserBitShared.SerializedField f : fields) {
            this.addField(SerializedFieldHelper.create(f));
        }
        return this;
    }

    public SchemaBuilder addField(Field f) {
        this.fields.add(f);
        return this;
    }

    public SchemaBuilder removeField(Field f) throws SchemaChangeException {
        if (!this.fields.remove(f)) {
            throw new SchemaChangeException("You attempted to remove an nonexistent field.");
        }
        return this;
    }

    public BatchSchema build() {
        ArrayList<Field> fieldList = Lists.newArrayList(this.fields);
        return new BatchSchema(this.selectionVectorMode, fieldList);
    }
}

