/*
 * Decompiled with CFR 0.152.
 */
package com.dremio.jdbc.shaded.com.dremio.exec.record;

import com.dremio.jdbc.shaded.com.dremio.common.expression.BasePath;
import com.dremio.jdbc.shaded.com.dremio.exec.record.TypedFieldId;
import com.dremio.jdbc.shaded.com.dremio.exec.record.VectorWrapper;
import com.dremio.jdbc.shaded.com.google.common.base.Preconditions;
import com.dremio.jdbc.shaded.org.apache.arrow.memory.BufferAllocator;
import com.dremio.jdbc.shaded.org.apache.arrow.vector.ValueVector;
import com.dremio.jdbc.shaded.org.apache.arrow.vector.complex.AbstractStructVector;
import com.dremio.jdbc.shaded.org.apache.arrow.vector.complex.FieldIdUtil2;
import com.dremio.jdbc.shaded.org.apache.arrow.vector.types.pojo.Field;
import com.dremio.jdbc.shaded.org.apache.arrow.vector.util.CallBack;
import com.dremio.jdbc.shaded.org.apache.arrow.vector.util.TransferPair;
import com.dremio.jdbc.shaded.org.slf4j.Logger;
import com.dremio.jdbc.shaded.org.slf4j.LoggerFactory;

public class SimpleVectorWrapper<T extends ValueVector>
implements VectorWrapper<T> {
    static final Logger logger = LoggerFactory.getLogger(SimpleVectorWrapper.class);
    private T vector;

    public SimpleVectorWrapper(T v) {
        this.vector = v;
    }

    @Override
    public Class<T> getVectorClass() {
        return this.vector.getClass();
    }

    @Override
    public Field getField() {
        return this.vector.getField();
    }

    @Override
    public T getValueVector() {
        return this.vector;
    }

    @Override
    public T[] getValueVectors() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean isHyper() {
        return false;
    }

    @Override
    public VectorWrapper<T> cloneAndTransfer(BufferAllocator allocator, CallBack callback) {
        TransferPair tp = this.vector.getTransferPair(this.vector.getField(), allocator, callback);
        tp.transfer();
        return new SimpleVectorWrapper<ValueVector>(tp.getTo());
    }

    @Override
    public void close() {
        this.clear();
    }

    @Override
    public void clear() {
        this.vector.clear();
    }

    public static <T extends ValueVector> SimpleVectorWrapper<T> create(T v) {
        return new SimpleVectorWrapper<T>(v);
    }

    @Override
    public VectorWrapper<?> getChildWrapper(int[] ids) {
        if (ids.length == 1) {
            return this;
        }
        Object vector = this.vector;
        for (int i = 1; i < ids.length; ++i) {
            AbstractStructVector mapLike = (AbstractStructVector)AbstractStructVector.class.cast(vector);
            if (mapLike == null) {
                return null;
            }
            vector = mapLike.getChildByOrdinal(ids[i]);
        }
        return new SimpleVectorWrapper<T>(vector);
    }

    @Override
    public TypedFieldId getFieldIdIfMatches(int id, BasePath expectedPath) {
        return FieldIdUtil2.getFieldId(this.getValueVector().getField(), id, expectedPath, true);
    }

    @Override
    public void transfer(VectorWrapper<?> destination) {
        Preconditions.checkArgument(destination instanceof SimpleVectorWrapper);
        Preconditions.checkArgument(this.getField().getType().equals(destination.getField().getType()));
        this.vector.makeTransferPair((ValueVector)((SimpleVectorWrapper)destination).vector).transfer();
    }
}

