/*
 * Decompiled with CFR 0.152.
 */
package com.dremio.jdbc.shaded.com.dremio.exec.record;

import com.dremio.jdbc.shaded.com.dremio.common.expression.CompleteType;
import com.dremio.jdbc.shaded.com.dremio.common.expression.PathSegment;
import com.dremio.jdbc.shaded.com.dremio.exec.vector.ObjectVector;
import com.dremio.jdbc.shaded.com.google.common.base.Preconditions;
import com.dremio.jdbc.shaded.org.apache.arrow.vector.ValueVector;
import com.dremio.jdbc.shaded.org.apache.commons.lang3.ArrayUtils;
import java.util.ArrayList;
import java.util.Arrays;

public class TypedFieldId {
    private final CompleteType finalType;
    private final CompleteType secondaryFinal;
    private final CompleteType intermediateType;
    private final int[] fieldIds;
    private final boolean isHyperReader;
    private final boolean isListVector;
    private final boolean isListOrUnionInPath;
    private final PathSegment remainder;

    public TypedFieldId(CompleteType type, int ... fieldIds) {
        this(type, type, type, false, null, false, fieldIds);
    }

    public TypedFieldId(CompleteType type, boolean isHyper, int ... fieldIds) {
        this(type, type, type, isHyper, null, false, fieldIds);
    }

    public TypedFieldId(CompleteType intermediateType, CompleteType secondaryFinal, CompleteType finalType, boolean isHyper, PathSegment remainder, boolean isListInPath, int ... fieldIds) {
        this(intermediateType, secondaryFinal, finalType, isHyper, false, remainder, isListInPath, fieldIds);
    }

    public TypedFieldId(CompleteType intermediateType, CompleteType secondaryFinal, CompleteType finalType, boolean isHyper, boolean isListVector, PathSegment remainder, int ... fieldIds) {
        this(intermediateType, secondaryFinal, finalType, isHyper, isListVector, remainder, false, fieldIds);
    }

    public TypedFieldId(CompleteType intermediateType, CompleteType secondaryFinal, CompleteType finalType, boolean isHyper, boolean isListVector, PathSegment remainder, boolean isListInPath, int ... fieldIds) {
        this.intermediateType = intermediateType;
        this.finalType = finalType;
        this.secondaryFinal = secondaryFinal;
        this.fieldIds = fieldIds;
        this.isHyperReader = isHyper;
        this.isListVector = isListVector;
        this.remainder = remainder;
        this.isListOrUnionInPath = isListInPath;
    }

    public TypedFieldId cloneWithChild(int id) {
        int[] fieldIds = ArrayUtils.add(this.fieldIds, id);
        return new TypedFieldId(this.intermediateType, this.secondaryFinal, this.finalType, this.isHyperReader, this.remainder, this.isListOrUnionInPath, fieldIds);
    }

    public PathSegment getLastSegment() {
        if (this.remainder == null) {
            return null;
        }
        PathSegment seg = this.remainder;
        while (seg.getChild() != null) {
            seg = seg.getChild();
        }
        return seg;
    }

    public TypedFieldId cloneWithRemainder(PathSegment remainder) {
        return new TypedFieldId(this.intermediateType, this.secondaryFinal, this.finalType, this.isHyperReader, remainder, this.isListOrUnionInPath, this.fieldIds);
    }

    public boolean hasRemainder() {
        return this.remainder != null;
    }

    public PathSegment getRemainder() {
        return this.remainder;
    }

    public boolean isHyperReader() {
        return this.isHyperReader;
    }

    public boolean isListVector() {
        return this.isListVector;
    }

    public boolean isListOrUnionInPath() {
        return this.isListOrUnionInPath;
    }

    public CompleteType getIntermediateType() {
        return this.intermediateType;
    }

    public Class<? extends ValueVector> getIntermediateClass() {
        if (this.intermediateType == CompleteType.OBJECT) {
            return ObjectVector.class;
        }
        return this.intermediateType.getValueVectorClass();
    }

    public CompleteType getFinalType() {
        return this.finalType;
    }

    public int[] getFieldIds() {
        return this.fieldIds;
    }

    public CompleteType getSecondaryFinal() {
        return this.secondaryFinal;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + Arrays.hashCode(this.fieldIds);
        result = 31 * result + (this.finalType == null ? 0 : this.finalType.hashCode());
        result = 31 * result + (this.intermediateType == null ? 0 : this.intermediateType.hashCode());
        result = 31 * result + (this.isHyperReader ? 1231 : 1237);
        result = 31 * result + (this.remainder == null ? 0 : this.remainder.hashCode());
        result = 31 * result + (this.secondaryFinal == null ? 0 : this.secondaryFinal.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        TypedFieldId other = (TypedFieldId)obj;
        if (!Arrays.equals(this.fieldIds, other.fieldIds)) {
            return false;
        }
        if (this.finalType == null ? other.finalType != null : !this.finalType.equals(other.finalType)) {
            return false;
        }
        if (this.intermediateType == null ? other.intermediateType != null : !this.intermediateType.equals(other.intermediateType)) {
            return false;
        }
        if (this.isHyperReader != other.isHyperReader) {
            return false;
        }
        if (this.remainder == null ? other.remainder != null : !this.remainder.equals(other.remainder)) {
            return false;
        }
        return !(this.secondaryFinal == null ? other.secondaryFinal != null : !this.secondaryFinal.equals(other.secondaryFinal));
    }

    public String toString() {
        int maxLen = 10;
        return "TypedFieldId [fieldIds=" + (this.fieldIds != null ? Arrays.toString(Arrays.copyOf(this.fieldIds, Math.min(this.fieldIds.length, 10))) : null) + ", remainder=" + String.valueOf(this.remainder) + "]";
    }

    public static class Builder {
        private final ArrayList<Integer> ids = new ArrayList();
        private CompleteType finalType;
        private CompleteType intermediateType;
        private CompleteType secondaryFinal;
        private PathSegment remainder;
        private boolean hyperReader = false;
        private boolean withIndex = false;
        private boolean isListVector = false;
        private boolean isListOrUnionInPath = false;

        public Builder addId(int id) {
            this.ids.add(id);
            return this;
        }

        public Builder withIndex() {
            this.withIndex = true;
            return this;
        }

        public Builder remainder(PathSegment remainder) {
            this.remainder = remainder;
            return this;
        }

        public Builder hyper() {
            this.hyperReader = true;
            return this;
        }

        public Builder listVector() {
            this.isListVector = true;
            return this;
        }

        public Builder finalType(CompleteType finalType) {
            this.finalType = finalType;
            return this;
        }

        public Builder secondaryFinal(CompleteType secondaryFinal) {
            this.secondaryFinal = secondaryFinal;
            return this;
        }

        public Builder intermediateType(CompleteType intermediateType) {
            this.intermediateType = intermediateType;
            return this;
        }

        public Builder isListOrUnionInPath(boolean isList) {
            this.isListOrUnionInPath = isList;
            return this;
        }

        public TypedFieldId build() {
            Preconditions.checkNotNull(this.intermediateType);
            Preconditions.checkNotNull(this.finalType);
            if (this.intermediateType == null) {
                this.intermediateType = this.finalType;
            }
            if (this.secondaryFinal == null) {
                this.secondaryFinal = this.finalType;
            }
            CompleteType actualFinalType = this.finalType;
            return new TypedFieldId(this.intermediateType, this.secondaryFinal, actualFinalType, this.hyperReader, this.isListVector, this.remainder, this.isListOrUnionInPath, this.ids.stream().mapToInt(i -> i).toArray());
        }
    }
}

