/*
 * Decompiled with CFR 0.152.
 */
package com.dremio.jdbc.shaded.com.dremio.exec.record.selection;

import com.dremio.jdbc.shaded.com.dremio.exec.record.DeadBuf;
import com.dremio.jdbc.shaded.org.apache.arrow.memory.ArrowBuf;
import com.dremio.jdbc.shaded.org.apache.arrow.memory.BufferAllocator;

public class SelectionVector2
implements AutoCloseable {
    private final BufferAllocator allocator;
    private int recordCount;
    private ArrowBuf buffer = DeadBuf.DEAD_BUFFER;
    public static final int RECORD_SIZE = 2;

    public SelectionVector2(BufferAllocator allocator) {
        this.allocator = allocator;
    }

    public int getCount() {
        return this.recordCount;
    }

    public ArrowBuf getBuffer() {
        return this.getBuffer(true);
    }

    public long memoryAddress() {
        return this.buffer.memoryAddress();
    }

    public ArrowBuf getBuffer(boolean clear) {
        ArrowBuf bufferHandle = this.buffer;
        if (clear) {
            bufferHandle.getReferenceManager().retain(1);
            this.clear();
        }
        return bufferHandle;
    }

    public void setBuffer(ArrowBuf bufferHandle) {
        this.clear();
        this.buffer = bufferHandle;
        this.buffer.getReferenceManager().retain(1);
    }

    public char getIndex(int index) {
        return this.buffer.getChar(index * 2);
    }

    public void setIndex(int index, char value) {
        this.buffer.setChar(index * 2, value);
    }

    public long getDataAddr() {
        return this.buffer.memoryAddress();
    }

    public void setIndex(int index, int value) {
        this.buffer.setChar(index, value);
    }

    public void allocateNew(int size) {
        this.clear();
        this.buffer = this.allocator.buffer(size * 2);
    }

    public SelectionVector2 clone() {
        SelectionVector2 newSV = new SelectionVector2(this.allocator);
        newSV.recordCount = this.recordCount;
        newSV.buffer = this.buffer;
        if (newSV.buffer != null) {
            newSV.buffer.getReferenceManager().retain(1);
        }
        this.clear();
        return newSV;
    }

    public void referTo(SelectionVector2 from) {
        this.buffer = from.buffer;
        this.recordCount = from.recordCount;
        from.buffer = DeadBuf.DEAD_BUFFER;
        from.recordCount = 0;
    }

    public void clear() {
        if (this.buffer != null && this.buffer != DeadBuf.DEAD_BUFFER) {
            this.buffer.close();
            this.buffer = DeadBuf.DEAD_BUFFER;
            this.recordCount = 0;
        }
    }

    public void setRecordCount(int recordCount) {
        this.recordCount = recordCount;
    }

    @Override
    public void close() {
        this.clear();
    }
}

