/*
 * Decompiled with CFR 0.152.
 */
package com.dremio.jdbc.shaded.com.dremio.exec.record.selection;

import com.dremio.jdbc.shaded.com.dremio.exec.record.DeadBuf;
import com.dremio.jdbc.shaded.com.google.common.base.Preconditions;
import com.dremio.jdbc.shaded.org.apache.arrow.memory.ArrowBuf;

public class SelectionVector4
implements AutoCloseable {
    private ArrowBuf data;
    private int recordCount;
    private int start;
    private int length;

    public SelectionVector4(ArrowBuf vector, int recordCount, int batchRecordCount) {
        Preconditions.checkArgument(recordCount < 0x1FFFFFFF, "Currently, Dremio can only support allocations up to 2gb in size.  You requested an allocation of %s bytes.", recordCount * 4);
        this.recordCount = recordCount;
        this.start = 0;
        this.length = Math.min(batchRecordCount, recordCount);
        this.data = vector;
    }

    public int getTotalCount() {
        return this.recordCount;
    }

    public int getCount() {
        return this.length;
    }

    public long getMemoryAddress() {
        return this.data.memoryAddress() + (long)(this.start * 4);
    }

    public void set(int index, int compound) {
        this.data.setInt(index * 4, compound);
    }

    public void set(int index, int recordBatch, int recordIndex) {
        this.data.setInt(index * 4, recordBatch << 16 | recordIndex & 0xFFFF);
    }

    public int get(int index) {
        return this.data.getInt((this.start + index) * 4);
    }

    public SelectionVector4 createNewWrapperCurrent(int batchRecordCount) {
        this.data.getReferenceManager().retain();
        SelectionVector4 sv4 = new SelectionVector4(this.data, this.recordCount, batchRecordCount);
        sv4.start = this.start;
        return sv4;
    }

    public SelectionVector4 createNewWrapperCurrent() {
        return this.createNewWrapperCurrent(this.length);
    }

    public boolean next() {
        if (this.start + this.length >= this.recordCount) {
            this.start = this.recordCount;
            this.length = 0;
            return false;
        }
        this.start += this.length;
        int newEnd = Math.min(this.start + this.length, this.recordCount);
        this.length = newEnd - this.start;
        return this.length > 0;
    }

    public void clear() {
        this.start = 0;
        this.length = 0;
        if (this.data != DeadBuf.DEAD_BUFFER) {
            this.data.close();
            this.data = DeadBuf.DEAD_BUFFER;
        }
    }

    @Override
    public void close() {
        this.clear();
    }
}

