/*
 * Decompiled with CFR 0.152.
 */
package com.dremio.jdbc.shaded.com.dremio.exec.rpc;

import com.dremio.jdbc.shaded.com.dremio.exec.rpc.InboundRpcMessage;
import com.dremio.jdbc.shaded.com.dremio.exec.rpc.RpcException;
import com.dremio.jdbc.shaded.com.google.protobuf.Internal;
import com.dremio.jdbc.shaded.com.google.protobuf.MessageLite;
import com.dremio.jdbc.shaded.com.google.protobuf.Parser;
import com.dremio.jdbc.shaded.io.netty.channel.ChannelHandlerContext;
import com.dremio.jdbc.shaded.io.netty.handler.codec.MessageToMessageDecoder;
import com.dremio.jdbc.shaded.org.slf4j.Logger;
import com.dremio.jdbc.shaded.org.slf4j.LoggerFactory;
import java.util.List;

public abstract class AbstractHandshakeHandler<T extends MessageLite>
extends MessageToMessageDecoder<InboundRpcMessage> {
    static final Logger logger = LoggerFactory.getLogger(AbstractHandshakeHandler.class);
    protected final Internal.EnumLite handshakeType;
    protected final Parser<T> parser;
    protected volatile int coordinationId;

    AbstractHandshakeHandler(Internal.EnumLite handshakeType, Parser<T> parser) {
        this.handshakeType = handshakeType;
        this.parser = parser;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void decode(ChannelHandlerContext ctx, InboundRpcMessage inbound, List<Object> outputs) throws Exception {
        try {
            this.coordinationId = inbound.coordinationId;
            ctx.channel().pipeline().remove(this);
            if (inbound.rpcType != this.handshakeType.getNumber()) {
                throw new RpcException(String.format("Handshake failure.  Expected %s[%d] but received number [%d]", this.handshakeType, this.handshakeType.getNumber(), inbound.rpcType));
            }
            MessageLite msg = (MessageLite)this.parser.parseFrom(inbound.getProtobufBodyAsIS());
            this.consumeHandshake(ctx, msg);
        }
        finally {
            if (inbound.dBody != null) {
                inbound.dBody.release();
            }
        }
    }

    protected abstract void consumeHandshake(ChannelHandlerContext var1, T var2) throws Exception;
}

