/*
 * Decompiled with CFR 0.152.
 */
package com.dremio.jdbc.shaded.com.dremio.exec.rpc;

import com.dremio.jdbc.shaded.com.dremio.exec.proto.GeneralRPCProtos;
import com.dremio.jdbc.shaded.com.dremio.exec.rpc.AbstractClient;
import com.dremio.jdbc.shaded.com.dremio.exec.rpc.AbstractHandshakeHandler;
import com.dremio.jdbc.shaded.com.dremio.exec.rpc.Acks;
import com.dremio.jdbc.shaded.com.dremio.exec.rpc.BasicClient;
import com.dremio.jdbc.shaded.com.dremio.exec.rpc.MessageDecoder;
import com.dremio.jdbc.shaded.com.dremio.exec.rpc.OutboundRpcMessage;
import com.dremio.jdbc.shaded.com.dremio.exec.rpc.RemoteConnection;
import com.dremio.jdbc.shaded.com.dremio.exec.rpc.RpcBus;
import com.dremio.jdbc.shaded.com.dremio.exec.rpc.RpcConfig;
import com.dremio.jdbc.shaded.com.dremio.exec.rpc.RpcConnectionHandler;
import com.dremio.jdbc.shaded.com.dremio.exec.rpc.RpcEncoder;
import com.dremio.jdbc.shaded.com.dremio.exec.rpc.RpcException;
import com.dremio.jdbc.shaded.com.dremio.exec.rpc.RpcExceptionHandler;
import com.dremio.jdbc.shaded.com.dremio.exec.rpc.RpcFuture;
import com.dremio.jdbc.shaded.com.dremio.exec.rpc.RpcOutcome;
import com.dremio.jdbc.shaded.com.dremio.exec.rpc.RpcOutcomeListener;
import com.dremio.jdbc.shaded.com.dremio.exec.rpc.TransportCheck;
import com.dremio.jdbc.shaded.com.dremio.exec.rpc.proxy.ProxyConfig;
import com.dremio.jdbc.shaded.com.dremio.ssl.SSLEngineFactory;
import com.dremio.jdbc.shaded.com.google.common.base.Preconditions;
import com.dremio.jdbc.shaded.com.google.protobuf.Internal;
import com.dremio.jdbc.shaded.com.google.protobuf.MessageLite;
import com.dremio.jdbc.shaded.com.google.protobuf.Parser;
import com.dremio.jdbc.shaded.io.netty.bootstrap.Bootstrap;
import com.dremio.jdbc.shaded.io.netty.buffer.ByteBuf;
import com.dremio.jdbc.shaded.io.netty.buffer.ByteBufAllocator;
import com.dremio.jdbc.shaded.io.netty.channel.ChannelFuture;
import com.dremio.jdbc.shaded.io.netty.channel.ChannelFutureListener;
import com.dremio.jdbc.shaded.io.netty.channel.ChannelHandler;
import com.dremio.jdbc.shaded.io.netty.channel.ChannelHandlerContext;
import com.dremio.jdbc.shaded.io.netty.channel.ChannelInboundHandlerAdapter;
import com.dremio.jdbc.shaded.io.netty.channel.ChannelInitializer;
import com.dremio.jdbc.shaded.io.netty.channel.ChannelOption;
import com.dremio.jdbc.shaded.io.netty.channel.ChannelPipeline;
import com.dremio.jdbc.shaded.io.netty.channel.EventLoopGroup;
import com.dremio.jdbc.shaded.io.netty.channel.socket.SocketChannel;
import com.dremio.jdbc.shaded.io.netty.handler.ssl.SslHandler;
import com.dremio.jdbc.shaded.io.netty.handler.timeout.IdleState;
import com.dremio.jdbc.shaded.io.netty.handler.timeout.IdleStateEvent;
import com.dremio.jdbc.shaded.io.netty.handler.timeout.IdleStateHandler;
import com.dremio.jdbc.shaded.io.netty.util.concurrent.Future;
import com.dremio.jdbc.shaded.io.netty.util.concurrent.GenericFutureListener;
import com.dremio.jdbc.shaded.org.apache.arrow.memory.BufferAllocator;
import com.dremio.jdbc.shaded.org.slf4j.Logger;
import com.dremio.jdbc.shaded.org.slf4j.LoggerFactory;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.SSLEngine;

public abstract class BasicClient<T extends Internal.EnumLite, R extends RemoteConnection, HS extends MessageLite, HR extends MessageLite>
extends AbstractClient<T, R, HS> {
    private static final Logger logger = LoggerFactory.getLogger(BasicClient.class);
    protected static final String PROTOCOL_DECODER = "protocol-decoder";
    protected static final String HANDSHAKE_REQUESTER = "handshake-requester";
    protected static final String SSL_CLIENT_HANDLER = "ssl-client-handler";
    protected static final String IDLE_STATE_HANDLER = "idle-state-handler";
    private static final String PROXY_HANDLER = "proxy-handler";
    private static final OutboundRpcMessage PING_MESSAGE = new OutboundRpcMessage(GeneralRPCProtos.RpcMode.PING, 0, 0, (MessageLite)Acks.OK, new ByteBuf[0]);
    private static final double PERCENT_TIMEOUT_BEFORE_SENDING_PING = 0.5;
    private final Class<HR> responseClass;
    private final T handshakeType;
    private final Parser<HR> handshakeParser;
    private final Optional<SSLEngineFactory> engineFactory;
    private final Bootstrap b;
    protected volatile R connection;

    public BasicClient(RpcConfig rpcMapping, ByteBufAllocator alloc, EventLoopGroup eventLoopGroup, T handshakeType, Class<HR> responseClass, Parser<HR> handshakeParser, Optional<SSLEngineFactory> engineFactory, final Optional<ProxyConfig> proxyConfig) throws RpcException {
        super(rpcMapping);
        this.responseClass = responseClass;
        this.handshakeType = handshakeType;
        this.handshakeParser = handshakeParser;
        this.engineFactory = engineFactory;
        final long timeoutInMillis = rpcMapping.hasTimeout() ? (long)((double)rpcMapping.getTimeout() * 1000.0 * 0.5) : -1L;
        this.b = (Bootstrap)((Bootstrap)((Bootstrap)((Bootstrap)((Bootstrap)((Bootstrap)((Bootstrap)((Bootstrap)((Bootstrap)new Bootstrap().group(eventLoopGroup)).channel(TransportCheck.getClientSocketChannel())).option(ChannelOption.ALLOCATOR, alloc)).option(ChannelOption.CONNECT_TIMEOUT_MILLIS, 30000)).option(ChannelOption.SO_REUSEADDR, true)).option(ChannelOption.SO_RCVBUF, SO_BUF_SZ)).option(ChannelOption.SO_SNDBUF, SO_BUF_SZ)).option(ChannelOption.TCP_NODELAY, true)).handler(new ChannelInitializer<SocketChannel>(){

            @Override
            protected void initChannel(SocketChannel ch) throws Exception {
                BasicClient.this.connection = BasicClient.this.initRemoteConnection(ch);
                ch.closeFuture().addListener(BasicClient.this.newCloseListener(ch, BasicClient.this.connection));
                ChannelPipeline pipe = ch.pipeline();
                pipe.addLast("protocol-encoder", (ChannelHandler)new RpcEncoder("c-" + BasicClient.this.rpcConfig.getName()));
                pipe.addLast(BasicClient.PROTOCOL_DECODER, (ChannelHandler)BasicClient.this.newDecoder(((RemoteConnection)BasicClient.this.connection).getAllocator()));
                pipe.addLast("handshake-handler", (ChannelHandler)new ClientHandshakeHandler());
                proxyConfig.map(ProxyConfig::createProxyHandler).ifPresent(handler -> pipe.addFirst(BasicClient.PROXY_HANDLER, (ChannelHandler)handler));
                if (timeoutInMillis != -1L) {
                    pipe.addLast(BasicClient.IDLE_STATE_HANDLER, (ChannelHandler)new IdlePingHandler(timeoutInMillis));
                }
                pipe.addLast("message-handler", (ChannelHandler)new RpcBus.InboundHandler((RpcBus)BasicClient.this, BasicClient.this.connection));
                pipe.addLast("exception-handler", new RpcExceptionHandler(BasicClient.this.connection));
            }
        });
    }

    public abstract MessageDecoder newDecoder(BufferAllocator var1);

    protected abstract void validateHandshake(HR var1) throws RpcException;

    protected abstract void finalizeConnection(HR var1, R var2);

    public <SEND extends MessageLite, RECEIVE extends MessageLite> void send(RpcOutcomeListener<RECEIVE> listener, T rpcType, SEND protobufBody, Class<RECEIVE> clazz, ByteBuf ... dataBodies) {
        super.send(listener, this.connection, rpcType, protobufBody, clazz, dataBodies);
    }

    public <SEND extends MessageLite, RECEIVE extends MessageLite> RpcFuture<RECEIVE> send(T rpcType, SEND protobufBody, Class<RECEIVE> clazz, ByteBuf ... dataBodies) {
        return super.send(this.connection, rpcType, protobufBody, clazz, dataBodies);
    }

    @Override
    protected void connectAsClient(RpcConnectionHandler<R> connectionHandler, HS handshakeValue, String host, int port) {
        ConnectionMultiListener cml = new ConnectionMultiListener(this, connectionHandler, handshakeValue, host, port);
        this.b.connect(host, port).addListener((GenericFutureListener<? extends Future<? super Void>>)cml.establishmentListener);
    }

    public boolean isActive() {
        return this.connection != null && ((RemoteConnection)this.connection).getChannel() != null && ((RemoteConnection)this.connection).getChannel().isActive();
    }

    public void setAutoRead(boolean enableAutoRead) {
        ((RemoteConnection)this.connection).setAutoRead(enableAutoRead);
    }

    private String getConnectionName(R connection) {
        if (connection != null) {
            return ((RemoteConnection)connection).getName();
        }
        return "connection is null";
    }

    @Override
    public void close() {
        try {
            if (this.connection != null) {
                logger.debug("Closing client in sync mode {}", (Object)this.getConnectionName(this.connection));
                ((RemoteConnection)this.connection).getChannel().close().sync();
            }
        }
        catch (InterruptedException e) {
            logger.warn("Failure while shutting {}", (Object)this.getClass().getName(), (Object)e);
            Thread.currentThread().interrupt();
        }
    }

    private class ConnectionMultiListener {
        private final com.dremio.jdbc.shaded.com.dremio.exec.rpc.BasicClient$ConnectionMultiListener.ConnectionEstablishmentListener establishmentListener = new ConnectionEstablishmentListener();
        private final com.dremio.jdbc.shaded.com.dremio.exec.rpc.BasicClient$ConnectionMultiListener.HandshakeSendListener handshakeSendListener = new HandshakeSendListener();
        private final RpcConnectionHandler<R> connectionHandler;
        private final HS handshakeValue;
        private final String hostName;
        private final int port;
        final /* synthetic */ BasicClient this$0;

        /*
         * WARNING - Possible parameter corruption
         */
        ConnectionMultiListener(RpcConnectionHandler<R> connectionHandler, HS handshakeValue, String hostName, int port) {
            this.this$0 = (BasicClient)n;
            this.hostName = hostName;
            this.port = port;
            assert (connectionHandler != null);
            assert (handshakeValue != null);
            this.connectionHandler = connectionHandler;
            this.handshakeValue = handshakeValue;
        }

        void sendHandshake() {
            if (logger.isDebugEnabled()) {
                logger.debug("sendHandshake - channel active {}", (Object)this.this$0.getConnectionName(this.this$0.connection));
            }
            Preconditions.checkState(this.this$0.connection != null, "connection is not yet initialized");
            this.this$0.send(this.handshakeSendListener, this.this$0.connection, this.this$0.handshakeType, this.handshakeValue, this.this$0.responseClass, true, new ByteBuf[0]);
        }

        private final class ConnectionEstablishmentListener
        implements GenericFutureListener<ChannelFuture> {
            private ConnectionEstablishmentListener() {
            }

            @Override
            public void operationComplete(ChannelFuture connectionFuture) throws Exception {
                boolean isInterrupted = false;
                long remainingWaitTimeMillis = 120000L;
                long startTime = System.currentTimeMillis();
                while (true) {
                    try {
                        connectionFuture.get(remainingWaitTimeMillis, TimeUnit.MILLISECONDS);
                        logger.trace("Connection establishment to '{}' completed with state '{}'", (Object)connectionFuture.channel(), (Object)connectionFuture.isSuccess());
                        if (!connectionFuture.isSuccess()) {
                            ConnectionMultiListener.this.connectionHandler.connectionFailed(RpcConnectionHandler.FailureType.CONNECTION, new RpcException("General connection failure.", connectionFuture.cause()));
                            break;
                        }
                        this.addNegotiator(connectionFuture);
                    }
                    catch (InterruptedException ie) {
                        long now = System.currentTimeMillis();
                        startTime = now;
                        isInterrupted = true;
                        if ((remainingWaitTimeMillis -= now - startTime) >= 1L) continue;
                        ConnectionMultiListener.this.connectionHandler.connectionFailed(RpcConnectionHandler.FailureType.CONNECTION, ie);
                    }
                    catch (Exception ex) {
                        logger.error("Failed to establish connection", ex);
                        ConnectionMultiListener.this.connectionHandler.connectionFailed(RpcConnectionHandler.FailureType.CONNECTION, ex);
                    }
                    break;
                }
                if (isInterrupted) {
                    Thread.currentThread().interrupt();
                }
            }

            void addNegotiator(ChannelFuture connectionFuture) throws Exception {
                if (!ConnectionMultiListener.this.this$0.rpcConfig.getSSLConfig().isPresent()) {
                    logger.trace("Adding handshake negotiator on '{}'", (Object)connectionFuture.channel());
                    this.addHandshakeRequester(connectionFuture);
                    return;
                }
                assert (ConnectionMultiListener.this.this$0.engineFactory.isPresent());
                SSLEngine clientEngine = ConnectionMultiListener.this.this$0.engineFactory.get().newClientEngine(connectionFuture.channel().alloc(), ConnectionMultiListener.this.hostName, ConnectionMultiListener.this.port);
                SslHandler sslHandler = new SslHandler(clientEngine);
                sslHandler.handshakeFuture().addListener(future -> {
                    logger.debug("SSL client state '{}' on connection '{}'", (Object)future.isSuccess(), (Object)connectionFuture.channel());
                    if (future.isSuccess()) {
                        logger.trace("Adding handshake negotiator on '{}', after SSL succeeded", (Object)connectionFuture.channel());
                        this.addHandshakeRequester(connectionFuture);
                    } else {
                        ConnectionMultiListener.this.connectionHandler.connectionFailed(RpcConnectionHandler.FailureType.CONNECTION, new RpcException("SSL negotiation failed", future.cause()));
                    }
                });
                logger.trace("Adding SSL negotiator on '{}'", (Object)connectionFuture.channel());
                connectionFuture.channel().pipeline().addBefore("protocol-encoder", BasicClient.SSL_CLIENT_HANDLER, sslHandler);
            }

            void addHandshakeRequester(ChannelFuture connectionFuture) {
                connectionFuture.channel().pipeline().addBefore("handshake-handler", BasicClient.HANDSHAKE_REQUESTER, new HandshakeRequester());
            }
        }

        private final class HandshakeSendListener
        implements RpcOutcomeListener<HR> {
            private HandshakeSendListener() {
            }

            @Override
            public void failed(RpcException ex) {
                logger.debug("Failure while initiating handshake for connection {}", (Object)ConnectionMultiListener.this.this$0.getConnectionName(ConnectionMultiListener.this.this$0.connection), (Object)ex);
                ConnectionMultiListener.this.connectionHandler.connectionFailed(RpcConnectionHandler.FailureType.HANDSHAKE_COMMUNICATION, ex);
            }

            @Override
            public void success(HR value, ByteBuf buffer) {
                if (logger.isDebugEnabled()) {
                    logger.debug("Handshake received on {}", (Object)ConnectionMultiListener.this.this$0.getConnectionName(ConnectionMultiListener.this.this$0.connection));
                }
                try {
                    ConnectionMultiListener.this.this$0.validateHandshake(value);
                    ConnectionMultiListener.this.this$0.finalizeConnection(value, ConnectionMultiListener.this.this$0.connection);
                    ConnectionMultiListener.this.connectionHandler.connectionSucceeded(ConnectionMultiListener.this.this$0.connection);
                    if (logger.isTraceEnabled()) {
                        logger.trace("Handshake completed successfully on {}", (Object)ConnectionMultiListener.this.this$0.getConnectionName(ConnectionMultiListener.this.this$0.connection));
                    }
                }
                catch (RpcException ex) {
                    logger.info("Failure while validating handshake for connection {}", (Object)ConnectionMultiListener.this.this$0.getConnectionName(ConnectionMultiListener.this.this$0.connection), (Object)ex);
                    ConnectionMultiListener.this.connectionHandler.connectionFailed(RpcConnectionHandler.FailureType.HANDSHAKE_VALIDATION, ex);
                }
            }

            @Override
            public void interrupted(InterruptedException ex) {
                logger.warn("Interrupted while waiting for handshake response", ex);
                ConnectionMultiListener.this.connectionHandler.connectionFailed(RpcConnectionHandler.FailureType.HANDSHAKE_COMMUNICATION, ex);
            }
        }

        private final class HandshakeRequester
        extends ChannelInboundHandlerAdapter {
            private HandshakeRequester() {
            }

            private void sendHandshakeAndRemoveSelf(ChannelHandlerContext ctx) {
                ConnectionMultiListener.this.sendHandshake();
                ctx.channel().pipeline().remove(this);
            }

            @Override
            public void handlerAdded(ChannelHandlerContext ctx) throws Exception {
                if (ctx.channel().isActive()) {
                    if (logger.isDebugEnabled()) {
                        logger.debug("sendHandshakeAndRemoveSelf - handler added: L {} -> R {}", (Object)ctx.channel().localAddress(), (Object)ctx.channel().remoteAddress());
                    }
                    this.sendHandshakeAndRemoveSelf(ctx);
                }
            }

            @Override
            public void channelActive(ChannelHandlerContext ctx) throws Exception {
                if (logger.isDebugEnabled()) {
                    logger.debug("sendHandshakeAndRemoveSelf - channel active: L {} -> R {}", (Object)ctx.channel().localAddress(), (Object)ctx.channel().remoteAddress());
                }
                this.sendHandshakeAndRemoveSelf(ctx);
                super.channelActive(ctx);
            }
        }
    }

    private class IdlePingHandler
    extends IdleStateHandler {
        private final ChannelFutureListener pingFailedListener;

        IdlePingHandler(long idleWaitInMillis) {
            super(0L, idleWaitInMillis, 0L, TimeUnit.MILLISECONDS);
            this.pingFailedListener = future -> {
                if (!future.isSuccess()) {
                    logger.error("Unable to maintain connection {}. Closing connection.", (Object)((RemoteConnection)BasicClient.this.connection).getName());
                    ((RemoteConnection)BasicClient.this.connection).close();
                }
            };
        }

        @Override
        protected void channelIdle(ChannelHandlerContext ctx, IdleStateEvent evt) throws Exception {
            if (evt.state() == IdleState.WRITER_IDLE) {
                ctx.writeAndFlush(PING_MESSAGE).addListener(this.pingFailedListener);
            }
        }
    }

    private class ClientHandshakeHandler
    extends AbstractHandshakeHandler<HR> {
        ClientHandshakeHandler() {
            super((Internal.EnumLite)BasicClient.this.handshakeType, BasicClient.this.handshakeParser);
        }

        @Override
        protected final void consumeHandshake(ChannelHandlerContext ctx, HR msg) throws Exception {
            RpcOutcome response = ((RemoteConnection)BasicClient.this.connection).getAndRemoveRpcOutcome(this.handshakeType.getNumber(), this.coordinationId, BasicClient.this.responseClass);
            response.set(msg, null);
        }
    }
}

